% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgb.Booster.R
\name{xgb.config}
\alias{xgb.config}
\alias{xgb.config<-}
\title{Accessors for model parameters as JSON string}
\usage{
xgb.config(object)

xgb.config(object) <- value
}
\arguments{
\item{object}{Object of class \code{xgb.Booster}.\strong{Will be modified in-place} when assigning to it.}

\item{value}{A list.}
}
\value{
Parameters as a list.
}
\description{
Accessors for model parameters as JSON string
}
\details{
Note that assignment is performed in-place on the booster C object, which unlike assignment
of R attributes, doesn't follow typical copy-on-write semantics for assignment - i.e. all references
to the same booster will also get updated.

See \code{\link[=xgb.copy.Booster]{xgb.copy.Booster()}} for an example of this behavior.
}
\examples{
data(agaricus.train, package = "xgboost")

## Keep the number of threads to 1 for examples
nthread <- 1
data.table::setDTthreads(nthread)
train <- agaricus.train

bst <- xgb.train(
  data = xgb.DMatrix(train$data, label = train$label, nthread = 1),
  nrounds = 2,
  params = xgb.params(
    max_depth = 2,
    nthread = nthread,
    objective = "binary:logistic"
  )
)

config <- xgb.config(bst)

}
