/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.constructors.PointConstructor;
import rene.zirkel.objects.CircleIntersectionObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.IntersectionObject;
import rene.zirkel.objects.LineCircleIntersectionObject;
import rene.zirkel.objects.LineIntersectionObject;
import rene.zirkel.objects.PointonObjectIntersectionObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class IntersectionConstructor
extends ObjectConstructor {
    ConstructionObject P1 = null;
    ConstructionObject P2 = null;

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        IntersectionObject[] intersectionObjectArray;
        if (!zirkelCanvas.Visual) {
            return;
        }
        boolean bl = false;
        if (this.P1 == null && (intersectionObjectArray = zirkelCanvas.selectPointonObjects(mouseEvent.getX(), mouseEvent.getY())).size() == 2) {
            this.P1 = (ConstructionObject)intersectionObjectArray.elementAt(0);
            this.P2 = (ConstructionObject)intersectionObjectArray.elementAt(1);
            if (this.P1.equals(this.P2) || this.P1.isFilled() && this.P2.isFilled()) {
                this.P2 = null;
                this.P1 = null;
            } else {
                bl = true;
            }
        }
        if (this.P1 == null) {
            this.P1 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            if (this.P1 != null) {
                this.P1.setSelected(true);
                zirkelCanvas.repaint();
                this.showStatus(zirkelCanvas);
            }
        } else {
            if (this.P2 == null) {
                this.P2 = this.select(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas);
            }
            if (this.P2 != null) {
                if (this.P2 == this.P1) {
                    this.P2 = null;
                    return;
                }
                intersectionObjectArray = IntersectionConstructor.construct(this.P1, this.P2, zirkelCanvas.getConstruction());
                if (intersectionObjectArray != null) {
                    IntersectionObject intersectionObject = null;
                    if (bl && intersectionObjectArray.length > 1) {
                        if (intersectionObjectArray[1].nearto(mouseEvent.getX(), mouseEvent.getY(), zirkelCanvas)) {
                            intersectionObjectArray[0] = null;
                            intersectionObject = intersectionObjectArray[1];
                        } else {
                            intersectionObjectArray[1] = null;
                            intersectionObject = intersectionObjectArray[0];
                        }
                    }
                    for (int i = 0; i < intersectionObjectArray.length; ++i) {
                        if (intersectionObjectArray[i] == null) continue;
                        intersectionObjectArray[i].setDefaults();
                        zirkelCanvas.addObject(intersectionObjectArray[i]);
                        intersectionObjectArray[i].validate(zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()));
                    }
                    if (intersectionObject != null) {
                        intersectionObject.autoAway();
                    }
                }
                this.P2 = null;
                this.P1 = null;
                zirkelCanvas.clearSelected();
                this.showStatus(zirkelCanvas);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        zirkelCanvas.indicateIntersectedObjects(mouseEvent.getX(), mouseEvent.getY());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IntersectionObject[] construct(ConstructionObject constructionObject, ConstructionObject constructionObject2, Construction construction) {
        IntersectionObject[] intersectionObjectArray = null;
        if (constructionObject instanceof PrimitiveLineObject) {
            if (constructionObject2 instanceof PrimitiveLineObject) {
                intersectionObjectArray = new IntersectionObject[]{new LineIntersectionObject(construction, (PrimitiveLineObject)constructionObject, (PrimitiveLineObject)constructionObject2)};
                return intersectionObjectArray;
            } else {
                if (!(constructionObject2 instanceof PrimitiveCircleObject)) return IntersectionConstructor.construct(constructionObject2, constructionObject, construction);
                intersectionObjectArray = new IntersectionObject[]{new LineCircleIntersectionObject(construction, (PrimitiveLineObject)constructionObject, (PrimitiveCircleObject)constructionObject2, true), new LineCircleIntersectionObject(construction, (PrimitiveLineObject)constructionObject, (PrimitiveCircleObject)constructionObject2, false)};
            }
            return intersectionObjectArray;
        } else if (constructionObject instanceof PrimitiveCircleObject) {
            if (constructionObject2 instanceof PrimitiveCircleObject) {
                intersectionObjectArray = new IntersectionObject[]{new CircleIntersectionObject(construction, (PrimitiveCircleObject)constructionObject, (PrimitiveCircleObject)constructionObject2, true), new CircleIntersectionObject(construction, (PrimitiveCircleObject)constructionObject, (PrimitiveCircleObject)constructionObject2, false)};
                return intersectionObjectArray;
            } else {
                if (!(constructionObject2 instanceof PrimitiveLineObject)) return IntersectionConstructor.construct(constructionObject2, constructionObject, construction);
                intersectionObjectArray = new IntersectionObject[]{new LineCircleIntersectionObject(construction, (PrimitiveLineObject)constructionObject2, (PrimitiveCircleObject)constructionObject, true), new LineCircleIntersectionObject(construction, (PrimitiveLineObject)constructionObject2, (PrimitiveCircleObject)constructionObject, false)};
            }
            return intersectionObjectArray;
        } else {
            intersectionObjectArray = new PointonObjectIntersectionObject[]{new PointonObjectIntersectionObject(construction, constructionObject, constructionObject2)};
        }
        return intersectionObjectArray;
    }

    public ConstructionObject select(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return zirkelCanvas.selectPointonObject(n, n2, false);
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        if (zirkelCanvas.Visual) {
            this.P2 = null;
            this.P1 = null;
            this.showStatus(zirkelCanvas);
        } else {
            zirkelCanvas.setPrompt(Zirkel.name("prompt.intersection"));
        }
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (this.P1 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.intersection.first", "Intersection: Select first object!"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.intersection.second", "Intersection: Select second object!"));
        }
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        block28: {
            if (!this.testTree(xmlTree, "Intersection")) {
                return this.constructOther(xmlTree, construction);
            }
            XmlTag xmlTag = xmlTree.getTag();
            if (!xmlTag.hasParam("first") || !xmlTag.hasParam("second")) {
                throw new ConstructionException("Intersection parameters missing!");
            }
            try {
                ConstructionObject constructionObject = construction.find(xmlTag.getValue("first"));
                ConstructionObject constructionObject2 = construction.find(xmlTag.getValue("second"));
                IntersectionObject[] intersectionObjectArray = IntersectionConstructor.construct(constructionObject, constructionObject2, construction);
                if (intersectionObjectArray == null) {
                    throw new Exception("");
                }
                String string = "";
                String string2 = "";
                if (xmlTag.hasParam("name")) {
                    string = xmlTag.getValue("name");
                }
                if (xmlTag.hasParam("other")) {
                    string2 = xmlTag.getValue("other");
                }
                if (intersectionObjectArray.length > 1) {
                    if (xmlTag.hasParam("which")) {
                        IntersectionObject intersectionObject = xmlTag.getValue("which").equals("second") ? intersectionObjectArray[1] : intersectionObjectArray[0];
                        if (!string.equals("")) {
                            intersectionObject.setName(string);
                        }
                        PointConstructor.setType(xmlTag, intersectionObject);
                        this.setName(xmlTag, intersectionObject);
                        this.set(xmlTree, intersectionObject);
                        construction.add(intersectionObject);
                        this.setConditionals(xmlTree, construction, intersectionObject);
                        if (xmlTag.hasParam("awayfrom")) {
                            intersectionObject.setAway(xmlTag.getValue("awayfrom"), true);
                        } else if (xmlTag.hasParam("closeto")) {
                            intersectionObject.setAway(xmlTag.getValue("closeto"), false);
                        }
                        if (xmlTag.hasParam("valid")) {
                            intersectionObject.setRestricted(false);
                        }
                        if (xmlTag.hasParam("alternate")) {
                            intersectionObject.setAlternate(true);
                        }
                    } else if (xmlTag.hasParam("other")) {
                        if (!string.equals("")) {
                            intersectionObjectArray[0].setName(string);
                        }
                        if (!string2.equals("")) {
                            intersectionObjectArray[1].setName(string2);
                        }
                        if (xmlTag.hasParam("awayfrom")) {
                            intersectionObjectArray[0].setAway(xmlTag.getValue("awayfrom"), true);
                            intersectionObjectArray[1].setAway(xmlTag.getValue("awayfrom"), false);
                        } else if (xmlTag.hasParam("closeto")) {
                            intersectionObjectArray[1].setAway(xmlTag.getValue("awayfrom"), true);
                            intersectionObjectArray[0].setAway(xmlTag.getValue("awayfrom"), false);
                        }
                        for (int i = 0; i < intersectionObjectArray.length; ++i) {
                            if (intersectionObjectArray[i] == null) continue;
                            PointConstructor.setType(xmlTag, intersectionObjectArray[i]);
                            this.set(xmlTree, intersectionObjectArray[i]);
                            construction.add(intersectionObjectArray[i]);
                            this.setConditionals(xmlTree, construction, intersectionObjectArray[i]);
                        }
                    }
                    break block28;
                }
                if (!string.equals("")) {
                    intersectionObjectArray[0].setName(string);
                }
                PointConstructor.setType(xmlTag, intersectionObjectArray[0]);
                this.setName(xmlTag, intersectionObjectArray[0]);
                this.set(xmlTree, intersectionObjectArray[0]);
                construction.add(intersectionObjectArray[0]);
                this.setConditionals(xmlTree, construction, intersectionObjectArray[0]);
                if (xmlTag.hasParam("valid")) {
                    intersectionObjectArray[0].setRestricted(false);
                }
                try {
                    double d2 = new Double(xmlTag.getValue("x"));
                    double d3 = new Double(xmlTag.getValue("y"));
                    intersectionObjectArray[0].setXY(d2, d3);
                }
                catch (Exception exception) {
                }
            }
            catch (ConstructionException constructionException) {
                throw constructionException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ConstructionException("Intersection parameters illegal!");
            }
        }
        return true;
    }

    public boolean constructOther(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "OtherIntersection")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (xmlTag.hasParam("name")) {
            ConstructionObject constructionObject = construction.find(xmlTag.getValue("name"));
            if (constructionObject == null || !(constructionObject instanceof IntersectionObject)) {
                throw new ConstructionException("OtherIntersection not found!");
            }
            IntersectionObject intersectionObject = (IntersectionObject)constructionObject;
            PointConstructor.setType(xmlTag, intersectionObject);
            constructionObject.setDefaults();
            this.set(xmlTree, constructionObject);
            ConstructionObject constructionObject2 = construction.lastButOne();
            if (xmlTag.hasParam("awayfrom")) {
                intersectionObject.setAway(xmlTag.getValue("awayfrom"), true);
                if (constructionObject2 != null && constructionObject2 instanceof IntersectionObject) {
                    ((IntersectionObject)constructionObject2).setAway(xmlTag.getValue("awayfrom"), false);
                }
            } else if (xmlTag.hasParam("closeto")) {
                intersectionObject.setAway(xmlTag.getValue("closeto"), false);
                if (constructionObject2 != null && constructionObject2 instanceof IntersectionObject) {
                    ((IntersectionObject)constructionObject2).setAway(xmlTag.getValue("awayfrom"), true);
                }
            }
            if (xmlTag.hasParam("valid")) {
                intersectionObject.setRestricted(false);
            }
        } else {
            throw new ConstructionException("OtherIntersection must have a name!");
        }
        return true;
    }

    public String getTag() {
        return "Intersection";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        block11: {
            IntersectionObject[] intersectionObjectArray;
            block10: {
                if (n != 2 && n != 3) {
                    throw new ConstructionException(Zirkel.name("exception.nparams"));
                }
                ConstructionObject constructionObject = construction.find(stringArray[0]);
                if (constructionObject == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[0]);
                }
                ConstructionObject constructionObject2 = construction.find(stringArray[1]);
                if (constructionObject2 == null) {
                    throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[0]);
                }
                intersectionObjectArray = IntersectionConstructor.construct(constructionObject, constructionObject2, construction);
                if (intersectionObjectArray == null) {
                    throw new ConstructionException(Zirkel.name("exception.type"));
                }
                if (intersectionObjectArray.length != 1) break block10;
                construction.add(intersectionObjectArray[0]);
                intersectionObjectArray[0].setDefaults();
                if (string.equals("")) break block11;
                intersectionObjectArray[0].setName(string);
                break block11;
            }
            if (string.equals("")) {
                for (int i = 0; i < intersectionObjectArray.length; ++i) {
                    construction.add(intersectionObjectArray[i]);
                    intersectionObjectArray[i].setDefaults();
                }
            } else {
                String[] stringArray2 = new String[2];
                int n2 = string.indexOf(44);
                if (n2 >= 0) {
                    stringArray2[0] = string.substring(n2 + 1).trim();
                    stringArray2[1] = string.substring(0, n2).trim();
                } else {
                    stringArray2[0] = string;
                    stringArray2[1] = "";
                }
                for (int i = 0; i < intersectionObjectArray.length; ++i) {
                    if (stringArray2[i].equals("")) continue;
                    construction.add(intersectionObjectArray[i]);
                    intersectionObjectArray[i].setDefaults();
                    intersectionObjectArray[i].setName(stringArray2[i]);
                }
            }
        }
    }
}

