/*
 * Copyright (C) 2022 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if ENABLE(WEB_CODECS)

#include "AvcEncoderConfig.h"
#include "BitrateMode.h"
#include "HardwareAcceleration.h"
#include "LatencyMode.h"
#include "WebCodecsAlphaOption.h"
#include <optional>

namespace WebCore {

struct WebCodecsVideoEncoderConfig {
    String codec;
    size_t width;
    size_t height;
    std::optional<size_t> displayWidth;
    std::optional<size_t> displayHeight;
    std::optional<uint64_t> bitrate;
    std::optional<double> framerate;
    HardwareAcceleration hardwareAcceleration { HardwareAcceleration::NoPreference };
    WebCodecsAlphaOption alpha { WebCodecsAlphaOption::Discard };
    String scalabilityMode;
    BitrateMode bitrateMode { BitrateMode::Variable };
    LatencyMode latencyMode { LatencyMode::Quality };
    std::optional<AvcEncoderConfig> avc;

    WebCodecsVideoEncoderConfig isolatedCopy() && { return { WTF::move(codec).isolatedCopy(), width, height, displayWidth, displayHeight, bitrate, framerate, hardwareAcceleration, alpha, WTF::move(scalabilityMode).isolatedCopy(), bitrateMode, latencyMode, avc }; }
    WebCodecsVideoEncoderConfig isolatedCopy() const & { return { codec.isolatedCopy(), width, height, displayWidth, displayHeight, bitrate, framerate, hardwareAcceleration, alpha, scalabilityMode.isolatedCopy(), bitrateMode, latencyMode, avc }; }
};

inline bool isSameConfigurationExceptBitrateAndFramerate(const WebCodecsVideoEncoderConfig& a, const WebCodecsVideoEncoderConfig& b)
{
    return a.codec == b.codec
        && a.width == b.width
        && a.height == b.height
        && a.displayWidth == b.displayWidth
        && a.displayHeight == b.displayHeight
        && a.hardwareAcceleration == b.hardwareAcceleration
        && a.alpha == b.alpha
        && a.scalabilityMode == b.scalabilityMode
        && a.bitrateMode == b.bitrateMode
        && a.latencyMode == b.latencyMode
        && (!!a.avc == !!b.avc)
        && (!a.avc || (a.avc->format == b.avc->format));
}

}

#endif // ENABLE(WEB_CODECS)
