
Contributing to scikit-learn
============================

The latest contributing guide is available in the repository at
`doc/developers/contributing.rst`, or online at:

https://scikit-learn.org/dev/developers/contributing.html

There are many ways to contribute to scikit-learn. Improving the
documentation is no less important than improving the code of the library
itself. If you find a typo in the documentation, or have made improvements, do
not hesitate to create a GitHub issue or preferably submit a GitHub pull request.

There are many other ways to help. In particular [improving, triaging, and
investigating issues](https://github.com/scikit-learn/scikit-learn/issues),
and [reviewing other developers' pull
requests](https://scikit-learn.org/dev/developers/contributing.html#code-review-guidelines)
are very valuable contributions that decrease the burden on the project
maintainers.

Another way to contribute is to report issues you're facing, and give a "thumbs
up" on issues that others reported and that are relevant to you. It also helps
us if you spread the word: reference the project from your blog and articles,
link to it from your website, or simply star it in GitHub to say "I use it".

Note that communications on all channels should respect our
[Code of Conduct](./CODE_OF_CONDUCT.md).

Quick links
-----------

* [Submitting a bug report or feature request](https://scikit-learn.org/dev/developers/contributing.html#submitting-a-bug-report-or-a-feature-request)
* [Contributing code](https://scikit-learn.org/dev/developers/contributing.html#contributing-code)
* [Coding guidelines](https://scikit-learn.org/dev/developers/develop.html#coding-guidelines)
* [Tips to read current code](https://scikit-learn.org/dev/developers/contributing.html#reading-the-existing-code-base)
