use crate::common::camera_file_check;
mod camera_quicktake_100_raw_modes {
  super::camera_file_check!("Apple", "QuickTake 100", cam_apple_quicktake_100_320x240_qtk, "raw_modes/Apple_QuickTake_100_320x240.qtk");
  super::camera_file_check!("Apple", "QuickTake 100", cam_apple_quicktake_100_480x640_qtk, "raw_modes/Apple_QuickTake_100_480x640.qtk");
}
mod camera_quicktake_150_raw_modes {
  super::camera_file_check!("Apple", "QuickTake 150", cam_apple_quicktake_150_480x640_qtk, "raw_modes/Apple_QuickTake_150_480x640.qtk");
}
mod camera_eos_1000d_raw_modes {
  super::camera_file_check!("Canon", "EOS 1000D", cam_canon_eos_1000d_iso_200_raw_cr2, "raw_modes/Canon EOS 1000D_ISO_200_RAW.CR2");
}
mod camera_eos_100d_raw_modes {
  super::camera_file_check!("Canon", "EOS 100D", cam_canon_eos_100d_iso_100_raw_cr2, "raw_modes/Canon EOS 100D_ISO_100_RAW.CR2");
}
mod camera_eos_10d_raw_modes {
  super::camera_file_check!("Canon", "EOS 10D", cam_canon_eos_10d_iso_100_decodertablenum2_crw, "raw_modes/Canon EOS 10D_ISO_100_DecoderTableNum2.CRW");
  super::camera_file_check!("Canon", "EOS 10D", cam_canon_eos_10d_iso_200_decodertablenum2_crw, "raw_modes/Canon EOS 10D_ISO_200_DecoderTableNum2.CRW");
  super::camera_file_check!("Canon", "EOS 10D", cam_eos_10d_crw, "raw_modes/EOS 10D.CRW");
}
mod camera_eos_1100d_raw_modes {
  super::camera_file_check!("Canon", "EOS 1100D", cam_canon_eos_1100d_iso_160_raw_cr2, "raw_modes/Canon EOS 1100D_ISO_160_RAW.CR2");
}
mod camera_eos_1200d_raw_modes {
  super::camera_file_check!("Canon", "EOS 1200D", cam_canon_eos_1200d_iso_100_raw_cr2, "raw_modes/Canon EOS 1200D_ISO_100_RAW.CR2");
}
mod camera_eos_1300d_raw_modes {
  super::camera_file_check!("Canon", "EOS 1300D", cam_canon_eos_1300d_iso_100_raw_cr2, "raw_modes/Canon EOS 1300D_ISO_100_RAW.CR2");
}
mod camera_eos_1d_mark_iii_raw_modes {
  super::camera_file_check!("Canon", "EOS-1D Mark III", cam_canon_eos_1d_mark_iii_iso_1000_raw_cr2, "raw_modes/Canon EOS-1D Mark III_ISO_1000_RAW.CR2");
}
mod camera_eos_1d_mark_ii_n_raw_modes {
  super::camera_file_check!("Canon", "EOS-1D Mark II N", cam_canon_eos_1d_mark_ii_n_iso_100_cr2, "raw_modes/Canon EOS-1D Mark II N_ISO_100.CR2");
}
mod camera_eos_1d_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "EOS-1D Mark II", cam_canon_eos_1d_mark_ii_iso_100_cr2, "raw_modes/Canon EOS-1D Mark II_ISO_100.CR2");
}
mod camera_eos_1d_mark_iv_raw_modes {
  super::camera_file_check!("Canon", "EOS-1D Mark IV", cam_canon_eos_1d_mark_iv_iso_400_raw_cr2, "raw_modes/Canon EOS-1D Mark IV_ISO_400_RAW.CR2");
  super::camera_file_check!("Canon", "EOS-1D Mark IV", cam_canon_eos_1d_mark_iv_iso_400_mraw_cr2, "raw_modes/Canon EOS-1D Mark IV_ISO_400_mRAW.CR2");
  super::camera_file_check!("Canon", "EOS-1D Mark IV", cam_canon_eos_1d_mark_iv_iso_400_sraw_cr2, "raw_modes/Canon EOS-1D Mark IV_ISO_400_sRAW.CR2");
}
mod camera_eos_1d_raw_modes {
  super::camera_file_check!("Canon", "EOS-1D", cam_canon_eos_1d_iso_200_tif, "raw_modes/Canon EOS-1D_ISO_200.TIF");
}
mod camera_eos_1ds_mark_iii_raw_modes {
  super::camera_file_check!("Canon", "EOS-1Ds Mark III", cam_canon_eos_1ds_mark_iii_iso_100_raw_cr2, "raw_modes/Canon EOS-1Ds Mark III_ISO_100_RAW.CR2");
}
mod camera_eos_1ds_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "EOS-1Ds Mark II", cam_canon_eos_1ds_mark_ii_iso_640_cr2, "raw_modes/Canon EOS-1Ds Mark II_ISO_640.CR2");
}
mod camera_eos_1ds_raw_modes {
  super::camera_file_check!("Canon", "EOS-1Ds", cam_canon_eos_1ds_iso_100_tif, "raw_modes/Canon EOS-1DS_ISO_100.TIF");
}
mod camera_eos_1d_x_mark_iii_raw_modes {
  super::camera_file_check!("Canon", "EOS-1D X Mark III", cam_canon_eos_1d_x_mark_iii_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS-1D X Mark III_RAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS-1D X Mark III", cam_canon_eos_1d_x_mark_iii_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS-1D X Mark III_CRAW_ISO_100_nocrop_nodual.CR3");
}
mod camera_eos_1d_x_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "EOS-1D X Mark II", cam_canon_eos_1d_x_mark_ii_iso_500_mraw_cr2, "raw_modes/Canon EOS-1D X Mark II_ISO_500_mRAW.CR2");
  super::camera_file_check!("Canon", "EOS-1D X Mark II", cam_canon_eos_1d_x_mark_ii_iso_500_sraw_cr2, "raw_modes/Canon EOS-1D X Mark II_ISO_500_sRAW.CR2");
  super::camera_file_check!("Canon", "EOS-1D X Mark II", cam_canon_eos_1d_x_mark_ii_iso_500_raw_cr2, "raw_modes/Canon EOS-1D X Mark II_ISO_500_RAW.CR2");
}
mod camera_eos_1d_x_raw_modes {
  super::camera_file_check!("Canon", "EOS-1D X", cam_canon_eos_1d_x_iso_1600_raw_cr2, "raw_modes/Canon EOS-1D X_ISO_1600_RAW.CR2");
}
mod camera_eos_2000d_raw_modes {
  super::camera_file_check!("Canon", "EOS 2000D", cam_canon_eos_2000d_iso_400_raw_cr2, "raw_modes/Canon EOS 2000D_ISO_400_RAW.CR2");
}
mod camera_eos_200d_raw_modes {
  super::camera_file_check!("Canon", "EOS 200D", cam_canon_eos_200d_iso_100_raw_cr2, "raw_modes/Canon EOS 200D_ISO_100_RAW.CR2");
}
mod camera_eos_20d_raw_modes {
  super::camera_file_check!("Canon", "EOS 20D", cam_canon_eos_20d_iso_800_cr2, "raw_modes/Canon EOS 20D_ISO_800.CR2");
}
mod camera_eos_250d_raw_modes {
  super::camera_file_check!("Canon", "EOS 250D", cam_canon_eos_250d_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS 250D_CRAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS 250D", cam_canon_eos_250d_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS 250D_RAW_ISO_100_nocrop_nodual.CR3");
}
mod camera_eos_300d_raw_modes {
  super::camera_file_check!("Canon", "EOS 300D", cam_canon_eos_300d_digital_iso_100_crw, "raw_modes/Canon EOS 300D DIGITAL_ISO_100.CRW");
  super::camera_file_check!("Canon", "EOS 300D", cam_eos_300d_crw, "raw_modes/EOS 300D.CRW");
}
mod camera_eos_30d_raw_modes {
  super::camera_file_check!("Canon", "EOS 30D", cam_canon_eos_30d_iso_100_cr2, "raw_modes/Canon EOS 30D_ISO_100.CR2");
}
mod camera_eos_350d_raw_modes {
  super::camera_file_check!("Canon", "EOS 350D", cam_canon_eos_350d_digital_iso_100_cr2, "raw_modes/Canon EOS 350D DIGITAL_ISO_100.CR2");
}
mod camera_eos_4000d_raw_modes {
  super::camera_file_check!("Canon", "EOS 4000D", cam_canon_eos_4000d_iso_100_raw_cr2, "raw_modes/Canon EOS 4000D_ISO_100_RAW.CR2");
}
mod camera_eos_400d_raw_modes {
  super::camera_file_check!("Canon", "EOS 400D", cam_canon_eos_400d_digital_iso_100_cr2, "raw_modes/Canon EOS 400D DIGITAL_ISO_100.CR2");
}
mod camera_eos_40d_raw_modes {
  super::camera_file_check!("Canon", "EOS 40D", cam_canon_eos_40d_iso_100_raw_cr2, "raw_modes/Canon EOS 40D_ISO_100_RAW.CR2");
  super::camera_file_check!("Canon", "EOS 40D", cam_canon_eos_40d_iso_100_sraw_cr2, "raw_modes/Canon EOS 40D_ISO_100_sRAW.CR2");
}
mod camera_eos_450d_raw_modes {
  super::camera_file_check!("Canon", "EOS 450D", cam_canon_eos_450d_iso_400_raw_cr2, "raw_modes/Canon EOS 450D_ISO_400_RAW.CR2");
}
mod camera_eos_500d_raw_modes {
  super::camera_file_check!("Canon", "EOS 500D", cam_canon_eos_500d_iso_200_raw_cr2, "raw_modes/Canon EOS 500D_ISO_200_RAW.CR2");
}
mod camera_eos_50d_raw_modes {
  super::camera_file_check!("Canon", "EOS 50D", cam_canon_eos_50d_iso_100_raw_cr2, "raw_modes/Canon EOS 50D_ISO_100_RAW.CR2");
  super::camera_file_check!("Canon", "EOS 50D", cam_canon_eos_50d_iso_100_sraw_cr2, "raw_modes/Canon EOS 50D_ISO_100_sRAW.CR2");
  super::camera_file_check!("Canon", "EOS 50D", cam_canon_eos_50d_iso_100_mraw_cr2, "raw_modes/Canon EOS 50D_ISO_100_mRAW.CR2");
}
mod camera_eos_550d_raw_modes {
  super::camera_file_check!("Canon", "EOS 550D", cam_canon_eos_550d_iso_100_raw_cr2, "raw_modes/Canon EOS 550D_ISO_100_RAW.CR2");
}
mod camera_eos_5d_mark_iii_raw_modes {
  super::camera_file_check!("Canon", "EOS 5D Mark III", cam_canon_eos_5d_mark_iii_sraw1_iso_200_cr2, "raw_modes/Canon EOS 5D Mark III_sRAW1_ISO_200.CR2");
  super::camera_file_check!("Canon", "EOS 5D Mark III", cam_canon_eos_5d_mark_iii_sraw2_iso_200_cr2, "raw_modes/Canon EOS 5D Mark III_sRAW2_ISO_200.CR2");
  super::camera_file_check!("Canon", "EOS 5D Mark III", cam_canon_eos_5d_mark_iii_raw_iso_200_cr2, "raw_modes/Canon EOS 5D Mark III_RAW_ISO_200.CR2");
}
mod camera_eos_5d_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "EOS 5D Mark II", cam_canon_eos_5d_mark_ii_iso_800_mraw_cr2, "raw_modes/Canon EOS 5D Mark II_ISO_800_mRAW.CR2");
  super::camera_file_check!("Canon", "EOS 5D Mark II", cam_canon_eos_5d_mark_ii_iso_100_raw_cr2, "raw_modes/Canon EOS 5D Mark II_ISO_100_RAW.CR2");
  super::camera_file_check!("Canon", "EOS 5D Mark II", cam_canon_eos_5d_mark_ii_iso_800_raw_cr2, "raw_modes/Canon EOS 5D Mark II_ISO_800_RAW.CR2");
  super::camera_file_check!("Canon", "EOS 5D Mark II", cam_canon_eos_5d_mark_ii_iso_800_sraw_cr2, "raw_modes/Canon EOS 5D Mark II_ISO_800_sRAW.CR2");
}
mod camera_eos_5d_mark_iv_raw_modes {
  super::camera_file_check!("Canon", "EOS 5D Mark IV", cam_canon_eos_5d_mark_iv_iso_100_sraw_cr2, "raw_modes/Canon EOS 5D Mark IV_ISO_100_sRAW.CR2");
  super::camera_file_check!("Canon", "EOS 5D Mark IV", cam_canon_eos_5d_mark_iv_iso_100_mraw_cr2, "raw_modes/Canon EOS 5D Mark IV_ISO_100_mRAW.CR2");
  super::camera_file_check!("Canon", "EOS 5D Mark IV", cam_canon_eos_5d_mark_iv_iso_100_raw_cr2, "raw_modes/Canon EOS 5D Mark IV_ISO_100_RAW.CR2");
}
mod camera_eos_5d_raw_modes {
  super::camera_file_check!("Canon", "EOS 5D", cam_canon_eos_5d_iso_400_cr2, "raw_modes/Canon EOS 5D_ISO_400.CR2");
}
mod camera_eos_5ds_raw_modes {
  super::camera_file_check!("Canon", "EOS 5DS", cam_canon_eos_5ds_iso_1000_mraw_cr2, "raw_modes/Canon EOS 5DS_ISO_1000_mRAW.CR2");
  super::camera_file_check!("Canon", "EOS 5DS", cam_canon_eos_5ds_iso_1000_sraw_cr2, "raw_modes/Canon EOS 5DS_ISO_1000_sRAW.CR2");
  super::camera_file_check!("Canon", "EOS 5DS", cam_canon_eos_5ds_iso_1000_raw_cr2, "raw_modes/Canon EOS 5DS_ISO_1000_RAW.CR2");
}
mod camera_eos_5ds_r_raw_modes {
  super::camera_file_check!("Canon", "EOS 5DS R", cam_canon_eos_5ds_r_iso_100_mraw_cr2, "raw_modes/Canon EOS 5DS R_ISO_100_mRAW.CR2");
  super::camera_file_check!("Canon", "EOS 5DS R", cam_canon_eos_5ds_r_iso_100_sraw_cr2, "raw_modes/Canon EOS 5DS R_ISO_100_sRAW.CR2");
  super::camera_file_check!("Canon", "EOS 5DS R", cam_canon_eos_5ds_r_iso_100_raw_cr2, "raw_modes/Canon EOS 5DS R_ISO_100_RAW.CR2");
}
mod camera_eos_600d_raw_modes {
  super::camera_file_check!("Canon", "EOS 600D", cam_canon_eos_600d_iso_200_raw_cr2, "raw_modes/Canon EOS 600D_ISO_200_RAW.CR2");
}
mod camera_eos_60d_raw_modes {
  super::camera_file_check!("Canon", "EOS 60D", cam_canon_eos_60d_iso_100_mraw_cr2, "raw_modes/Canon EOS 60D_ISO_100_mRAW.CR2");
  super::camera_file_check!("Canon", "EOS 60D", cam_canon_eos_60d_iso_100_sraw_cr2, "raw_modes/Canon EOS 60D_ISO_100_sRAW.CR2");
  super::camera_file_check!("Canon", "EOS 60D", cam_canon_eos_60d_iso_100_raw_cr2, "raw_modes/Canon EOS 60D_ISO_100_RAW.CR2");
}
mod camera_eos_650d_raw_modes {
  super::camera_file_check!("Canon", "EOS 650D", cam_canon_eos_650d_iso_100_raw_cr2, "raw_modes/Canon EOS 650D_ISO_100_RAW.CR2");
}
mod camera_eos_6d_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "EOS 6D Mark II", cam_canon_eos_6d_mark_ii_iso_100_raw_cr2, "raw_modes/Canon EOS 6D Mark II_ISO_100_RAW.CR2");
  super::camera_file_check!("Canon", "EOS 6D Mark II", cam_canon_eos_6d_mark_ii_iso_100_sraw_cr2, "raw_modes/Canon EOS 6D Mark II_ISO_100_sRAW.CR2");
  super::camera_file_check!("Canon", "EOS 6D Mark II", cam_canon_eos_6d_mark_ii_iso_100_mraw_cr2, "raw_modes/Canon EOS 6D Mark II_ISO_100_mRAW.CR2");
}
mod camera_eos_6d_raw_modes {
  super::camera_file_check!("Canon", "EOS 6D", cam_canon_eos_6d_iso_100_raw_cr2, "raw_modes/Canon EOS 6D_ISO_100_RAW.CR2");
  super::camera_file_check!("Canon", "EOS 6D", cam_canon_eos_6d_iso_400_raw_cr2, "raw_modes/Canon EOS 6D_ISO_400_RAW.CR2");
  super::camera_file_check!("Canon", "EOS 6D", cam_canon_eos_6d_iso_100_sraw_cr2, "raw_modes/Canon EOS 6D_ISO_100_sRAW.CR2");
  super::camera_file_check!("Canon", "EOS 6D", cam_canon_eos_6d_iso_100_mraw_cr2, "raw_modes/Canon EOS 6D_ISO_100_mRAW.CR2");
}
mod camera_eos_700d_raw_modes {
  super::camera_file_check!("Canon", "EOS 700D", cam_canon_eos_700d_iso_200_raw_cr2, "raw_modes/Canon EOS 700D_ISO_200_RAW.CR2");
}
mod camera_eos_70d_raw_modes {
  super::camera_file_check!("Canon", "EOS 70D", cam_canon_eos_70d_iso_100_mraw_cr2, "raw_modes/Canon EOS 70D_ISO_100_mRAW.CR2");
  super::camera_file_check!("Canon", "EOS 70D", cam_canon_eos_70d_iso_100_sraw_cr2, "raw_modes/Canon EOS 70D_ISO_100_sRAW.CR2");
  super::camera_file_check!("Canon", "EOS 70D", cam_canon_eos_70d_iso_100_raw_cr2, "raw_modes/Canon EOS 70D_ISO_100_RAW.CR2");
}
mod camera_eos_750d_raw_modes {
  super::camera_file_check!("Canon", "EOS 750D", cam_canon_eos_750d_iso_100_raw_cr2, "raw_modes/Canon EOS 750D_ISO_100_RAW.CR2");
}
mod camera_eos_760d_raw_modes {
  super::camera_file_check!("Canon", "EOS 760D", cam_canon_eos_760d_iso_200_raw_cr2, "raw_modes/Canon EOS 760D_ISO_200_RAW.CR2");
}
mod camera_eos_77d_raw_modes {
  super::camera_file_check!("Canon", "EOS 77D", cam_canon_eos_77d_iso_3200_raw_cr2, "raw_modes/Canon EOS 77D_ISO_3200_RAW.CR2");
}
mod camera_eos_7d_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "EOS 7D Mark II", cam_canon_eos_7d_mark_ii_iso_100_sraw_cr2, "raw_modes/Canon EOS 7D Mark II_ISO_100_sRAW.CR2");
  super::camera_file_check!("Canon", "EOS 7D Mark II", cam_canon_eos_7d_mark_ii_iso_100_mraw_cr2, "raw_modes/Canon EOS 7D Mark II_ISO_100_mRAW.CR2");
  super::camera_file_check!("Canon", "EOS 7D Mark II", cam_canon_eos_7d_mark_ii_iso_100_raw_cr2, "raw_modes/Canon EOS 7D Mark II_ISO_100_RAW.CR2");
}
mod camera_eos_7d_raw_modes {
  super::camera_file_check!("Canon", "EOS 7D", cam_canon_eos_7d_iso_1250_sraw_cr2, "raw_modes/Canon EOS 7D_ISO_1250_sRAW.CR2");
  super::camera_file_check!("Canon", "EOS 7D", cam_canon_eos_7d_iso_1250_mraw_cr2, "raw_modes/Canon EOS 7D_ISO_1250_mRAW.CR2");
  super::camera_file_check!("Canon", "EOS 7D", cam_canon_eos_7d_iso_1250_raw_cr2, "raw_modes/Canon EOS 7D_ISO_1250_RAW.CR2");
  super::camera_file_check!("Canon", "EOS 7D", cam_canon_eos_7d_iso_100_raw_cr2, "raw_modes/Canon EOS 7D_ISO_100_RAW.CR2");
}
mod camera_eos_800d_raw_modes {
  super::camera_file_check!("Canon", "EOS 800D", cam_canon_eos_800d_iso_100_raw_cr2, "raw_modes/Canon EOS 800D_ISO_100_RAW.CR2");
}
mod camera_eos_80d_raw_modes {
  super::camera_file_check!("Canon", "EOS 80D", cam_canon_eos_80d_iso_100_sraw_cr2, "raw_modes/Canon EOS 80D_ISO_100_sRAW.CR2");
  super::camera_file_check!("Canon", "EOS 80D", cam_canon_eos_80d_iso_100_raw_cr2, "raw_modes/Canon EOS 80D_ISO_100_RAW.CR2");
  super::camera_file_check!("Canon", "EOS 80D", cam_canon_eos_80d_iso_100_mraw_cr2, "raw_modes/Canon EOS 80D_ISO_100_mRAW.CR2");
}
mod camera_eos_850d_raw_modes {
  super::camera_file_check!("Canon", "EOS 850D", cam_canon_eos_850d_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS 850D_CRAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS 850D", cam_canon_eos_850d_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS 850D_RAW_ISO_100_nocrop_nodual.CR3");
}
mod camera_eos_90d_raw_modes {
  super::camera_file_check!("Canon", "EOS 90D", cam_canon_eos_90d_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS 90D_RAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS 90D", cam_canon_eos_90d_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS 90D_CRAW_ISO_100_nocrop_nodual.CR3");
}
mod camera_eos_d2000c_raw_modes {
  super::camera_file_check!("Canon", "EOS D2000C", cam_canon_d2000c_raw_iso_200_tif, "raw_modes/Canon D2000C_RAW_ISO_200.TIF");
}
mod camera_eos_d30_raw_modes {
  super::camera_file_check!("Canon", "EOS D30", cam_canon_eos_d30_iso_1600_crw, "raw_modes/Canon EOS D30_ISO_1600.CRW");
}
mod camera_eos_d60_raw_modes {
  super::camera_file_check!("Canon", "EOS D60", cam_canon_eos_d60_iso_100_crw, "raw_modes/Canon EOS D60_ISO_100.CRW");
}
mod camera_eos_digital_rebel_raw_modes {
  super::camera_file_check!("Canon", "EOS Digital Rebel", cam_canon_eos_digital_rebel_iso_1600_crw, "raw_modes/Canon EOS DIGITAL REBEL_ISO_1600.CRW");
}
mod camera_eos_digital_rebel_xsi_raw_modes {
  super::camera_file_check!("Canon", "EOS Digital Rebel XSi", cam_canon_eos_digital_rebel_xsi_iso_400_raw_cr2, "raw_modes/Canon EOS DIGITAL REBEL XSi_ISO_400_RAW.CR2");
}
mod camera_eos_digital_rebel_xs_raw_modes {
  super::camera_file_check!("Canon", "EOS Digital Rebel XS", cam_canon_eos_digital_rebel_xs_iso_100_raw_cr2, "raw_modes/Canon EOS DIGITAL REBEL XS_ISO_100_RAW.CR2");
}
mod camera_eos_digital_rebel_xti_raw_modes {
  super::camera_file_check!("Canon", "EOS Digital Rebel XTi", cam_canon_eos_digital_rebel_xti_iso_400_cr2, "raw_modes/Canon EOS DIGITAL REBEL XTi_ISO_400.CR2");
}
mod camera_eos_digital_rebel_xt_raw_modes {
  super::camera_file_check!("Canon", "EOS Digital Rebel XT", cam_canon_eos_digital_rebel_xt_iso_100_cr2, "raw_modes/Canon EOS DIGITAL REBEL XT_ISO_100.CR2");
}
mod camera_eos_kiss_digital_n_raw_modes {
  super::camera_file_check!("Canon", "EOS Kiss Digital N", cam_canon_eos_kiss_digital_n_iso_100_cr2, "raw_modes/Canon EOS Kiss Digital N_ISO_100.CR2");
}
mod camera_eos_kiss_x3_raw_modes {
  super::camera_file_check!("Canon", "EOS Kiss X3", cam_canon_eos_kiss_x3_iso_400_raw_cr2, "raw_modes/Canon EOS Kiss X3_ISO_400_RAW.CR2");
}
mod camera_eos_kiss_x4_raw_modes {
  super::camera_file_check!("Canon", "EOS Kiss X4", cam_canon_eos_kiss_x4_iso_100_raw_cr2, "raw_modes/Canon EOS Kiss X4_ISO_100_RAW.CR2");
}
mod camera_eos_kiss_x80_raw_modes {
  super::camera_file_check!("Canon", "EOS Kiss X80", cam_canon_eos_kiss_x80_iso_100_raw_cr2, "raw_modes/Canon EOS Kiss X80_ISO_100_RAW.CR2");
}
mod camera_eos_kiss_x9_raw_modes {
  super::camera_file_check!("Canon", "EOS Kiss X9", cam_canon_eos_kiss_x9_iso_6400_raw_cr2, "raw_modes/Canon EOS Kiss X9_ISO_6400_RAW.CR2");
}
mod camera_eos_m100_raw_modes {
  super::camera_file_check!("Canon", "EOS M100", cam_canon_eos_m100_iso_640_raw_cr2, "raw_modes/Canon EOS M100_ISO_640_RAW.CR2");
}
mod camera_eos_m10_raw_modes {
  super::camera_file_check!("Canon", "EOS M10", cam_canon_eos_m10_iso_200_raw_cr2, "raw_modes/Canon EOS M10_ISO_200_RAW.CR2");
}
mod camera_eos_m200_raw_modes {
  super::camera_file_check!("Canon", "EOS M200", cam_canon_eos_m200_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS M200_CRAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS M200", cam_canon_eos_m200_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS M200_RAW_ISO_100_nocrop_nodual.CR3");
}
mod camera_eos_m2_raw_modes {
  super::camera_file_check!("Canon", "EOS M2", cam_canon_eos_m2_iso_500_raw_cr2, "raw_modes/Canon EOS M2_ISO_500_RAW.CR2");
}
mod camera_eos_m3_raw_modes {
  super::camera_file_check!("Canon", "EOS M3", cam_canon_eos_m3_iso_5000_raw_cr2, "raw_modes/Canon EOS M3_ISO_5000_RAW.CR2");
}
mod camera_eos_m50m2_raw_modes {
  super::camera_file_check!("Canon", "EOS M50m2", cam_canon_eos_m50m2_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS M50m2_RAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS M50m2", cam_canon_eos_m50m2_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS M50m2_CRAW_ISO_100_nocrop_nodual.CR3");
}
mod camera_eos_m50_raw_modes {
  super::camera_file_check!("Canon", "EOS M50", cam_canon_eos_m50_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS M50_RAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS M50", cam_canon_eos_m50_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS M50_CRAW_ISO_100_nocrop_nodual.CR3");
}
mod camera_eos_m5_raw_modes {
  super::camera_file_check!("Canon", "EOS M5", cam_canon_eos_m5_iso_100_raw_cr2, "raw_modes/Canon EOS M5_ISO_100_RAW.CR2");
}
mod camera_eos_m6_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "EOS M6 Mark II", cam_canon_eos_m6_mark_ii_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS M6 Mark II_RAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS M6 Mark II", cam_canon_eos_m6_mark_ii_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS M6 Mark II_CRAW_ISO_100_nocrop_nodual.CR3");
}
mod camera_eos_m6_raw_modes {
  super::camera_file_check!("Canon", "EOS M6", cam_canon_eos_m6_iso_100_raw_cr2, "raw_modes/Canon EOS M6_ISO_100_RAW.CR2");
}
mod camera_eos_m_raw_modes {
  super::camera_file_check!("Canon", "EOS M", cam_canon_eos_m_iso_1600_raw_cr2, "raw_modes/Canon EOS M_ISO_1600_RAW.CR2");
}
mod camera_eos_r5_raw_modes {
  super::camera_file_check!("Canon", "EOS R5", cam_canon_eos_r5_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS R5_CRAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R5", cam_canon_eos_r5_raw_iso_100_crop_dual_cr3, "raw_modes/Canon EOS R5_RAW_ISO_100_crop_dual.CR3");
  super::camera_file_check!("Canon", "EOS R5", cam_canon_eos_r5_raw_iso_100_nocrop_dual_cr3, "raw_modes/Canon EOS R5_RAW_ISO_100_nocrop_dual.CR3");
  super::camera_file_check!("Canon", "EOS R5", cam_canon_eos_r5_craw_iso_100_nocrop_dual_cr3, "raw_modes/Canon EOS R5_CRAW_ISO_100_nocrop_dual.CR3");
  super::camera_file_check!("Canon", "EOS R5", cam_canon_eos_r5_craw_iso_100_crop_dual_cr3, "raw_modes/Canon EOS R5_CRAW_ISO_100_crop_dual.CR3");
  super::camera_file_check!("Canon", "EOS R5", cam_canon_eos_r5_craw_iso_100_crop_nodual_cr3, "raw_modes/Canon EOS R5_CRAW_ISO_100_crop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R5", cam_canon_eos_r5_raw_iso_100_crop_nodual_cr3, "raw_modes/Canon EOS R5_RAW_ISO_100_crop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R5", cam_canon_eos_r5_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS R5_RAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R5", cam_standardraw_iso400_tungsten_clog_neutral_bt2020_crm, "raw_modes/StandardRaw_ISO400_Tungsten_CLOG_Neutral_BT2020.CRM");
}
mod camera_eos_r5_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "EOS R5 Mark II", cam_canon_eos_r5m2_raw_iso_640_nocrop_cr3, "raw_modes/Canon EOS R5m2_RAW_ISO_640_nocrop.CR3");
  super::camera_file_check!("Canon", "EOS R5 Mark II", cam_canon_eos_r5m2_raw_iso_65535_nocrop_es_cr3, "raw_modes/Canon EOS R5m2_RAW_ISO_65535_nocrop_ES.CR3");
  super::camera_file_check!("Canon", "EOS R5 Mark II", cam_canon_eos_r5m2_raw_iso_125_nocrop_dustdata_cr3, "raw_modes/Canon EOS R5m2_RAW_ISO_125_nocrop_DUSTDATA.CR3");
  super::camera_file_check!("Canon", "EOS R5 Mark II", cam_canon_eos_r5m2_raw_iso_125_crop_cr3, "raw_modes/Canon EOS R5m2_RAW_ISO_125_crop.CR3");
  super::camera_file_check!("Canon", "EOS R5 Mark II", cam_canon_eos_r5m2_craw_iso_640_nocrop_cr3, "raw_modes/Canon EOS R5m2_CRAW_ISO_640_nocrop.CR3");
  super::camera_file_check!("Canon", "EOS R5 Mark II", cam_canon_eos_r5m2_craw_iso_125_crop_cr3, "raw_modes/Canon EOS R5m2_CRAW_ISO_125_crop.CR3");
}
mod camera_eos_r5_mark_ii_crm_movie_modes {
  super::camera_file_check!("Canon", "EOS R5 Mark II", cam_r5mk2_lightraw_crm, "crm_movie_modes/R5MK2_LightRaw.CRM");
  super::camera_file_check!("Canon", "EOS R5 Mark II", cam_r5mk2_standardraw_crm, "crm_movie_modes/R5MK2_StandardRaw.CRM");
}
mod camera_eos_r5_c_raw_modes {
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_craw_iso_65535_nocrop_nodual_ms_cr3, "raw_modes/Canon EOS R5 C_CRAW_ISO_65535_nocrop_nodual_MS.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_raw_iso_100_nocrop_nodual_ms_burst_cr3, "raw_modes/Canon EOS R5 C_RAW_ISO_100_nocrop_nodual_MS_BURST.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_craw_iso_800_nocrop_nodual_ms_cr3, "raw_modes/Canon EOS R5 C_CRAW_ISO_800_nocrop_nodual_MS.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_craw_iso_800_nocrop_nodual_es_cr3, "raw_modes/Canon EOS R5 C_CRAW_ISO_800_nocrop_nodual_ES.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_craw_iso_65535_nocrop_nodual_es_cr3, "raw_modes/Canon EOS R5 C_CRAW_ISO_65535_nocrop_nodual_ES.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_raw_iso_100_nocrop_dual_cr3, "raw_modes/Canon EOS R5 C_RAW_ISO_100_nocrop_dual.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_craw_iso_100_nocrop_nodual_es_cr3, "raw_modes/Canon EOS R5 C_CRAW_ISO_100_nocrop_nodual_ES.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_craw_iso_100_nocrop_nodual_ms_cr3, "raw_modes/Canon EOS R5 C_CRAW_ISO_100_nocrop_nodual_MS.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_craw_iso_100_nocrop_dual_cr3, "raw_modes/Canon EOS R5 C_CRAW_ISO_100_nocrop_dual.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_raw_iso_100_nocrop_nodual_es_cr3, "raw_modes/Canon EOS R5 C_RAW_ISO_100_nocrop_nodual_ES.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_raw_iso_100_nocrop_nodual_ms_cr3, "raw_modes/Canon EOS R5 C_RAW_ISO_100_nocrop_nodual_MS.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_raw_iso_100_nocrop_nodual_es_burst_cr3, "raw_modes/Canon EOS R5 C_RAW_ISO_100_nocrop_nodual_ES_BURST.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_raw_iso_800_nocrop_nodual_ms_cr3, "raw_modes/Canon EOS R5 C_RAW_ISO_800_nocrop_nodual_MS.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_raw_iso_65535_nocrop_nodual_es_cr3, "raw_modes/Canon EOS R5 C_RAW_ISO_65535_nocrop_nodual_ES.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_raw_iso_800_nocrop_nodual_es_cr3, "raw_modes/Canon EOS R5 C_RAW_ISO_800_nocrop_nodual_ES.CR3");
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_raw_iso_65535_nocrop_nodual_ms_cr3, "raw_modes/Canon EOS R5 C_RAW_ISO_65535_nocrop_nodual_MS.CR3");
}
mod camera_eos_r5_c_crm {
  super::camera_file_check!("Canon", "EOS R5 C", cam_canon_eos_r5_c_standard__raw__iso_100_crm, "crm/Canon EOS R5 C_Standard (RAW)_ISO_100.CRM");
}
mod camera_eos_r6_raw_modes {
  super::camera_file_check!("Canon", "EOS R6", cam_canon_eos_r6_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS R6_RAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R6", cam_canon_eos_r6_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS R6_CRAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R6", cam_canon_eos_r6_raw_iso_100_crop_nodual_cr3, "raw_modes/Canon EOS R6_RAW_ISO_100_crop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R6", cam_canon_eos_r6_craw_iso_100_crop_nodual_cr3, "raw_modes/Canon EOS R6_CRAW_ISO_100_crop_nodual.CR3");
}
mod camera_eos_r6_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "EOS R6 Mark II", cam_canon_eos_r6m2_raw_iso_100_dual_nocrop_cr3, "raw_modes/Canon EOS R6m2_RAW_ISO_100_dual_nocrop.CR3");
  super::camera_file_check!("Canon", "EOS R6 Mark II", cam_canon_eos_r6m2_craw_iso_100_dual_crop_cr3, "raw_modes/Canon EOS R6m2_CRAW_ISO_100_dual_crop.CR3");
  super::camera_file_check!("Canon", "EOS R6 Mark II", cam_canon_eos_r6m2_craw_iso_100_dual_nocrop_cr3, "raw_modes/Canon EOS R6m2_CRAW_ISO_100_dual_nocrop.CR3");
  super::camera_file_check!("Canon", "EOS R6 Mark II", cam_canon_eos_r6m2_raw_iso_100_nodual_crop_cr3, "raw_modes/Canon EOS R6m2_RAW_ISO_100_nodual_crop.CR3");
  super::camera_file_check!("Canon", "EOS R6 Mark II", cam_canon_eos_r6m2_craw_iso_100_nodual_crop_cr3, "raw_modes/Canon EOS R6m2_CRAW_ISO_100_nodual_crop.CR3");
  super::camera_file_check!("Canon", "EOS R6 Mark II", cam_canon_eos_r6m2_raw_iso_100_nodual_nocrop_cr3, "raw_modes/Canon EOS R6m2_RAW_ISO_100_nodual_nocrop.CR3");
  super::camera_file_check!("Canon", "EOS R6 Mark II", cam_canon_eos_r6m2_craw_iso_100_nodual_nocrop_cr3, "raw_modes/Canon EOS R6m2_CRAW_ISO_100_nodual_nocrop.CR3");
  super::camera_file_check!("Canon", "EOS R6 Mark II", cam_canon_eos_r6m2_raw_iso_100_dual_crop_cr3, "raw_modes/Canon EOS R6m2_RAW_ISO_100_dual_crop.CR3");
}
mod camera_eos_r7_raw_modes {
  super::camera_file_check!("Canon", "EOS R7", cam_canon_eos_r7_raw_iso_100_nodual_cr3, "raw_modes/Canon EOS R7_RAW_ISO_100_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R7", cam_canon_eos_r7_raw_iso_800_nodual_cr3, "raw_modes/Canon EOS R7_RAW_ISO_800_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R7", cam_canon_eos_r7_raw_iso_32000_nodual_cr3, "raw_modes/Canon EOS R7_RAW_ISO_32000_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R7", cam_canon_eos_r7_burst_iso_100_nodual_cr3, "raw_modes/Canon EOS R7_BURST_ISO_100_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R7", cam_canon_eos_r7_craw_iso_100_nodual_cr3, "raw_modes/Canon EOS R7_CRAW_ISO_100_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R7", cam_canon_eos_r7_raw_iso_800_dual_cr3, "raw_modes/Canon EOS R7_RAW_ISO_800_dual.CR3");
  super::camera_file_check!("Canon", "EOS R7", cam_canon_eos_r7_craw_iso_32000_nodual_cr3, "raw_modes/Canon EOS R7_CRAW_ISO_32000_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R7", cam_canon_eos_r7_raw_iso_100_dual_cr3, "raw_modes/Canon EOS R7_RAW_ISO_100_dual.CR3");
  super::camera_file_check!("Canon", "EOS R7", cam_canon_eos_r7_craw_iso_800_nodual_cr3, "raw_modes/Canon EOS R7_CRAW_ISO_800_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R7", cam_canon_eos_r7_raw_iso_32000_dual_cr3, "raw_modes/Canon EOS R7_RAW_ISO_32000_dual.CR3");
}
mod camera_eos_r8_raw_modes {
  super::camera_file_check!("Canon", "EOS R8", cam_canon_eos_r8_craw_dual_cr3, "raw_modes/Canon_EOS_R8_CRAW_dual.CR3");
  super::camera_file_check!("Canon", "EOS R8", cam_canon_eos_r8_burst_cr3, "raw_modes/Canon_EOS_R8_BURST.CR3");
  super::camera_file_check!("Canon", "EOS R8", cam_canon_eos_r8_raw_dual_cr3, "raw_modes/Canon_EOS_R8_RAW_dual.CR3");
  super::camera_file_check!("Canon", "EOS R8", cam_canon_eos_r8_craw_nodual_cr3, "raw_modes/Canon_EOS_R8_CRAW_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R8", cam_canon_eos_r8_raw_nodual_cr3, "raw_modes/Canon_EOS_R8_RAW_nodual.CR3");
}
mod camera_eos_r10_raw_modes {
  super::camera_file_check!("Canon", "EOS R10", cam_canon_eos_r10_raw_iso_800_cr3, "raw_modes/Canon EOS R10_RAW_ISO_800.CR3");
  super::camera_file_check!("Canon", "EOS R10", cam_canon_eos_r10_craw_iso_800_cr3, "raw_modes/Canon EOS R10_CRAW_ISO_800.CR3");
  super::camera_file_check!("Canon", "EOS R10", cam_canon_eos_r10_craw_iso_32000_cr3, "raw_modes/Canon EOS R10_CRAW_ISO_32000.CR3");
  super::camera_file_check!("Canon", "EOS R10", cam_canon_eos_r10_raw_iso_32000_cr3, "raw_modes/Canon EOS R10_RAW_ISO_32000.CR3");
  super::camera_file_check!("Canon", "EOS R10", cam_canon_eos_r10_burst_iso_100_cr3, "raw_modes/Canon EOS R10_BURST_ISO_100.CR3");
  super::camera_file_check!("Canon", "EOS R10", cam_canon_eos_r10_raw_iso_100_cr3, "raw_modes/Canon EOS R10_RAW_ISO_100.CR3");
  super::camera_file_check!("Canon", "EOS R10", cam_canon_eos_r10_craw_iso_100_cr3, "raw_modes/Canon EOS R10_CRAW_ISO_100.CR3");
}
mod camera_eos_r50_raw_modes {
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso800_craw_ms_cr3, "raw_modes/Canon_R50_ISO800_CRAW_ms.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso100_raw_ms_cr3, "raw_modes/Canon_R50_ISO100_RAW_ms.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso200_raw_ms_hdr_cr3, "raw_modes/Canon_R50_ISO200_RAW_ms_HDR.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso800_craw_es_cr3, "raw_modes/Canon_R50_ISO800_CRAW_es.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso100_raw_es_cr3, "raw_modes/Canon_R50_ISO100_RAW_es.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso800_raw_es_cr3, "raw_modes/Canon_R50_ISO800_RAW_es.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso200_craw_ms_hdr_cr3, "raw_modes/Canon_R50_ISO200_CRAW_ms_HDR.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso800_raw_ms_cr3, "raw_modes/Canon_R50_ISO800_RAW_ms.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso100_craw_es_cr3, "raw_modes/Canon_R50_ISO100_CRAW_es.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso32000_raw_es_cr3, "raw_modes/Canon_R50_ISO32000_RAW_es.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso100_craw_ms_cr3, "raw_modes/Canon_R50_ISO100_CRAW_ms.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso32000_raw_ms_cr3, "raw_modes/Canon_R50_ISO32000_RAW_ms.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso32000_craw_ms_cr3, "raw_modes/Canon_R50_ISO32000_CRAW_ms.CR3");
  super::camera_file_check!("Canon", "EOS R50", cam_canon_r50_iso32000_craw_es_cr3, "raw_modes/Canon_R50_ISO32000_CRAW_es.CR3");
}
mod camera_eos_r100_raw_modes {
  super::camera_file_check!("Canon", "EOS R100", cam_canon_eos_r100_craw_cr3, "raw_modes/Canon_EOS_R100_CRAW.CR3");
  super::camera_file_check!("Canon", "EOS R100", cam_canon_eos_r100_raw_cr3, "raw_modes/Canon_EOS_R100_RAW.CR3");
}
mod camera_eos_rebel_sl1_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel SL1", cam_canon_eos_rebel_sl1_iso_400_raw_cr2, "raw_modes/Canon EOS REBEL SL1_ISO_400_RAW.CR2");
}
mod camera_eos_rebel_sl2_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel SL2", cam_canon_eos_rebel_sl2_iso_400_raw_cr2, "raw_modes/Canon EOS Rebel SL2_ISO_400_RAW.CR2");
}
mod camera_eos_rebel_sl3_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel SL3", cam_eos_rebel_sl3_cr3, "raw_modes/EOS Rebel SL3.CR3");
}
mod camera_eos_rebel_t100_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel T100", cam_canon_eos_rebel_t100_iso_100_raw_cr2, "raw_modes/Canon EOS Rebel T100_ISO_100_RAW.CR2");
}
mod camera_eos_rebel_t1i_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel T1i", cam_canon_eos_rebel_t1i_iso_1600_raw_cr2, "raw_modes/Canon EOS REBEL T1i_ISO_1600_RAW.CR2");
}
mod camera_eos_rebel_t2i_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel T2i", cam_canon_eos_rebel_t2i_iso_1600_raw_cr2, "raw_modes/Canon EOS REBEL T2i_ISO_1600_RAW.CR2");
}
mod camera_eos_rebel_t3i_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel T3i", cam_canon_eos_rebel_t3i_iso_100_raw_cr2, "raw_modes/Canon EOS REBEL T3i_ISO_100_RAW.CR2");
}
mod camera_eos_rebel_t3_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel T3", cam_canon_eos_rebel_t3_iso_800_raw_cr2, "raw_modes/Canon EOS REBEL T3_ISO_800_RAW.CR2");
}
mod camera_eos_rebel_t4i_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel T4i", cam_canon_eos_rebel_t4i_iso_100_raw_cr2, "raw_modes/Canon EOS REBEL T4i_ISO_100_RAW.CR2");
}
mod camera_eos_rebel_t5i_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel T5i", cam_canon_eos_rebel_t5i_iso_400_raw_cr2, "raw_modes/Canon EOS REBEL T5i_ISO_400_RAW.CR2");
}
mod camera_eos_rebel_t5_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel T5", cam_canon_eos_rebel_t5_iso_800_raw_cr2, "raw_modes/Canon EOS REBEL T5_ISO_800_RAW.CR2");
}
mod camera_eos_rebel_t6i_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel T6i", cam_canon_eos_rebel_t6i_iso_100_raw_cr2, "raw_modes/Canon EOS Rebel T6i_ISO_100_RAW.CR2");
}
mod camera_eos_rebel_t6_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel T6", cam_canon_eos_rebel_t6_iso_200_raw_cr2, "raw_modes/Canon EOS Rebel T6_ISO_200_RAW.CR2");
}
mod camera_eos_rebel_t6s_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel T6s", cam_canon_eos_rebel_t6s_iso_200_raw_cr2, "raw_modes/Canon EOS Rebel T6s_ISO_200_RAW.CR2");
}
mod camera_eos_rebel_t7i_raw_modes {
  super::camera_file_check!("Canon", "EOS REBEL T7i", cam_canon_eos_rebel_t7i_iso_800_raw_cr2, "raw_modes/Canon EOS REBEL T7i_ISO_800_RAW.CR2");
}
mod camera_eos_rebel_t7_raw_modes {
  super::camera_file_check!("Canon", "EOS Rebel T7", cam_canon_eos_rebel_t7_iso_200_raw_cr2, "raw_modes/Canon EOS Rebel T7_ISO_200_RAW.CR2");
}
mod camera_eos_rp_raw_modes {
  super::camera_file_check!("Canon", "EOS RP", cam_canon_eos_rp_craw_iso_100_crop_nodual_cr3, "raw_modes/Canon EOS RP_CRAW_ISO_100_crop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS RP", cam_canon_eos_rp_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS RP_RAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS RP", cam_canon_eos_rp_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS RP_CRAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS RP", cam_canon_eos_rp_raw_iso_100_crop_nodual_cr3, "raw_modes/Canon EOS RP_RAW_ISO_100_crop_nodual.CR3");
}
mod camera_eos_r_raw_modes {
  super::camera_file_check!("Canon", "EOS R", cam_canon_eos_r_raw_iso_100_crop_dual_cr3, "raw_modes/Canon EOS R_RAW_ISO_100_crop_dual.CR3");
  super::camera_file_check!("Canon", "EOS R", cam_canon_eos_r_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS R_RAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R", cam_canon_eos_r_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon EOS R_CRAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R", cam_canon_eos_r_raw_iso_100_crop_nodual_cr3, "raw_modes/Canon EOS R_RAW_ISO_100_crop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R", cam_canon_eos_r_craw_iso_100_crop_nodual_cr3, "raw_modes/Canon EOS R_CRAW_ISO_100_crop_nodual.CR3");
  super::camera_file_check!("Canon", "EOS R", cam_canon_eos_r_raw_iso_100_nocrop_dual_cr3, "raw_modes/Canon EOS R_RAW_ISO_100_nocrop_dual.CR3");
  super::camera_file_check!("Canon", "EOS R", cam_canon_eos_r_craw_iso_100_crop_dual_cr3, "raw_modes/Canon EOS R_CRAW_ISO_100_crop_dual.CR3");
  super::camera_file_check!("Canon", "EOS R", cam_canon_eos_r_craw_iso_100_nocrop_dual_cr3, "raw_modes/Canon EOS R_CRAW_ISO_100_nocrop_dual.CR3");
}
mod camera_ixus900ti_raw_modes {
  super::camera_file_check!("Canon", "IXUS900Ti", cam_canon_ixus900ti_crw, "raw_modes/Canon IXUS900Ti.CRW");
}
mod camera_ixy_220f_raw_modes {
  super::camera_file_check!("Canon", "IXY 220F", cam_canon_ixy_220f_crw, "raw_modes/canon_ixy_220f.CRW");
}
mod camera_powershot_a480_raw_modes {
  super::camera_file_check!("Canon", "PowerShot A480", cam_powershot_a480_crw, "raw_modes/PowerShot A480.CRW");
}
mod camera_powershot_a540_raw_modes {
  super::camera_file_check!("Canon", "PowerShot A540", cam_canon_powershot_a540_crw, "raw_modes/Canon PowerShot A540.CRW");
}
mod camera_powershot_a550_raw_modes {
  super::camera_file_check!("Canon", "PowerShot A550", cam_powershot_a550_crw, "raw_modes/PowerShot A550.CRW");
}
mod camera_powershot_a570_is_raw_modes {
  super::camera_file_check!("Canon", "PowerShot A570 IS", cam_powershot_a570_is_crw, "raw_modes/PowerShot A570 IS.CRW");
}
mod camera_powershot_a610_raw_modes {
  super::camera_file_check!("Canon", "PowerShot A610", cam_canon_powershot_a610_crw, "raw_modes/Canon PowerShot A610.CRW");
}
mod camera_powershot_a620_raw_modes {
  super::camera_file_check!("Canon", "PowerShot A620", cam_powershot_a620_crw, "raw_modes/Powershot A620.CRW");
}
mod camera_powershot_a630_raw_modes {
  super::camera_file_check!("Canon", "PowerShot A630", cam_canon_powershot_a630_crw, "raw_modes/Canon PowerShot A630.CRW");
}
mod camera_powershot_a640_raw_modes {
  super::camera_file_check!("Canon", "PowerShot A640", cam_powershot_a640_crw, "raw_modes/Powershot A640.CRW");
}
mod camera_powershot_a650_raw_modes {
  super::camera_file_check!("Canon", "PowerShot A650", cam_canon_powershot_a650_crw, "raw_modes/Canon Powershot A650.CRW");
}
mod camera_powershot_a710_is_raw_modes {
  super::camera_file_check!("Canon", "PowerShot A710 IS", cam_canon_powershot_a710_is_crw, "raw_modes/Canon PowerShot A710 IS.CRW");
}
mod camera_powershot_a720_is_raw_modes {
  super::camera_file_check!("Canon", "PowerShot A720 IS", cam_powershot_a720is_crw, "raw_modes/Powershot A720IS.CRW");
}
mod camera_powershot_d10_raw_modes {
  super::camera_file_check!("Canon", "PowerShot D10", cam_powershot_d10_crw, "raw_modes/PowerShot D10.CRW");
}
mod camera_powershot_elph_130_is_raw_modes {
  super::camera_file_check!("Canon", "PowerShot ELPH 130 IS", cam_canon_powershot_elph_130_is_crw, "raw_modes/Canon PowerShot ELPH 130 IS.CRW");
}
mod camera_powershot_g10_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G10", cam_canon_powershot_g10_iso_80_raw_cr2, "raw_modes/Canon PowerShot G10_ISO_80_RAW.CR2");
}
mod camera_powershot_g11_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G11", cam_canon_powershot_g11_iso_400_raw_cr2, "raw_modes/Canon PowerShot G11_ISO_400_RAW.CR2");
}
mod camera_powershot_g12_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G12", cam_canon_powershot_g12_iso_200_raw_cr2, "raw_modes/Canon PowerShot G12_ISO_200_RAW.CR2");
}
mod camera_powershot_g15_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G15", cam_canon_powershot_g15_iso_80_raw_cr2, "raw_modes/Canon PowerShot G15_ISO_80_RAW.CR2");
}
mod camera_powershot_g16_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G16", cam_canon_powershot_g16_iso_80_raw_cr2, "raw_modes/Canon PowerShot G16_ISO_80_RAW.CR2");
}
mod camera_powershot_g1_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G1", cam_canon_powershot_g1_iso_50_crw, "raw_modes/Canon PowerShot G1_ISO_50.CRW");
}
mod camera_powershot_g1_x_mark_iii_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G1 X Mark III", cam_canon_powershot_g1_x_mark_iii_iso_100_raw_cr2, "raw_modes/Canon PowerShot G1 X Mark III_ISO_100_RAW.CR2");
}
mod camera_powershot_g1_x_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G1 X Mark II", cam_canon_powershot_g1_x_mark_ii_iso_100_raw_cr2, "raw_modes/Canon PowerShot G1 X Mark II_ISO_100_RAW.CR2");
}
mod camera_powershot_g1_x_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G1 X", cam_canon_powershot_g1_x_iso_100_raw_cr2, "raw_modes/Canon PowerShot G1 X_ISO_100_RAW.CR2");
}
mod camera_powershot_g2_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G2", cam_canon_powershot_g2_iso_100_crw, "raw_modes/Canon PowerShot G2_ISO_100.CRW");
}
mod camera_powershot_g3_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G3", cam_canon_powershot_g3_iso_50_crw, "raw_modes/Canon PowerShot G3_ISO_50.CRW");
}
mod camera_powershot_g3_x_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G3 X", cam_canon_powershot_g3_x_iso_200_raw_cr2, "raw_modes/Canon PowerShot G3 X_ISO_200_RAW.CR2");
}
mod camera_powershot_g5_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G5", cam_canon_powershot_g5_iso_100_crw, "raw_modes/Canon PowerShot G5_ISO_100.CRW");
}
mod camera_powershot_g5_x_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G5 X Mark II", cam_canon_powershot_g5_x_mark_ii_craw_iso_200_nocrop_nodual_cr3, "raw_modes/Canon PowerShot G5 X Mark II_CRAW_ISO_200_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "PowerShot G5 X Mark II", cam_canon_powershot_g5_x_mark_ii_raw_iso_200_nocrop_nodual_cr3, "raw_modes/Canon PowerShot G5 X Mark II_RAW_ISO_200_nocrop_nodual.CR3");
}
mod camera_powershot_g5_x_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G5 X", cam_canon_powershot_g5_x_iso_400_raw_cr2, "raw_modes/Canon PowerShot G5 X_ISO_400_RAW.CR2");
}
mod camera_powershot_g6_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G6", cam_canon_powershot_g6_iso_100_crw, "raw_modes/Canon PowerShot G6_ISO_100.CRW");
}
mod camera_powershot_g7_x_mark_iii_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G7 X Mark III", cam_canon_powershot_g7_x_mark_iii_raw_iso_200_nocrop_nodual_cr3, "raw_modes/Canon PowerShot G7 X Mark III_RAW_ISO_200_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "PowerShot G7 X Mark III", cam_canon_powershot_g7_x_mark_iii_craw_iso_200_nocrop_nodual_cr3, "raw_modes/Canon PowerShot G7 X Mark III_CRAW_ISO_200_nocrop_nodual.CR3");
}
mod camera_powershot_g7_x_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G7 X Mark II", cam_canon_powershot_g7_x_mark_ii_iso_125_raw_cr2, "raw_modes/Canon PowerShot G7 X Mark II_ISO_125_RAW.CR2");
}
mod camera_powershot_g7_x_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G7 X", cam_canon_powershot_g7_x_iso_125_raw_cr2, "raw_modes/Canon PowerShot G7 X_ISO_125_RAW.CR2");
  super::camera_file_check!("Canon", "PowerShot G7 X", cam_powershot_g7_x_crw, "raw_modes/PowerShot G7 X.CRW");
}
mod camera_powershot_g9_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G9", cam_canon_powershot_g9_iso_80_raw_cr2, "raw_modes/Canon PowerShot G9_ISO_80_RAW.CR2");
}
mod camera_powershot_g9_x_mark_ii_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G9 X Mark II", cam_canon_powershot_g9_x_mark_ii_iso_125_raw_cr2, "raw_modes/Canon PowerShot G9 X Mark II_ISO_125_RAW.CR2");
}
mod camera_powershot_g9_x_raw_modes {
  super::camera_file_check!("Canon", "PowerShot G9 X", cam_canon_powershot_g9_x_iso_640_raw_cr2, "raw_modes/Canon PowerShot G9 X_ISO_640_RAW.CR2");
}
mod camera_powershot_pro1_raw_modes {
  super::camera_file_check!("Canon", "PowerShot Pro1", cam_canon_powershot_pro1_iso_50_crw, "raw_modes/Canon PowerShot Pro1_ISO_50.CRW");
}
mod camera_powershot_s100_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S100", cam_canon_powershot_s100_iso_80_raw_cr2, "raw_modes/Canon PowerShot S100_ISO_80_RAW.CR2");
}
mod camera_powershot_s100v_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S100V", cam_canon_powershot_s100v_iso_200_raw_cr2, "raw_modes/Canon PowerShot S100V_ISO_200_RAW.CR2");
}
mod camera_powershot_s110_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S110", cam_canon_powershot_s110_iso_100_raw_cr2, "raw_modes/Canon PowerShot S110_ISO_100_RAW.CR2");
}
mod camera_powershot_s120_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S120", cam_canon_powershot_s120_iso_250_raw_cr2, "raw_modes/Canon PowerShot S120_ISO_250_RAW.CR2");
}
mod camera_powershot_s2_is_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S2 IS", cam_canon_powershot_s2_is_crw, "raw_modes/Canon PowerShot S2 IS.CRW");
}
mod camera_powershot_s30_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S30", cam_canon_powershot_s30_iso_50_crw, "raw_modes/Canon PowerShot S30_ISO_50.CRW");
}
mod camera_powershot_s3is_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S3IS", cam_canon_powershot_s3is_crw, "raw_modes/Canon PowerShot S3IS.CRW");
  super::camera_file_check!("Canon", "PowerShot S3IS", cam_powershot_s3is_crw, "raw_modes/PowerShot S3IS.CRW");
}
mod camera_powershot_s40_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S40", cam_canon_powershot_s40_iso_50_crw, "raw_modes/Canon PowerShot S40_ISO_50.CRW");
}
mod camera_powershot_s45_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S45", cam_canon_powershot_s45_iso_50_crw, "raw_modes/Canon PowerShot S45_ISO_50.CRW");
}
mod camera_powershot_s50_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S50", cam_canon_powershot_s50_iso_50_crw, "raw_modes/Canon PowerShot S50_ISO_50.CRW");
}
mod camera_powershot_s5_is_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S5 IS", cam_canon_powershot_s5_is_crw, "raw_modes/Canon PowerShot S5 IS.CRW");
}
mod camera_powershot_s60_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S60", cam_canon_powershot_s60_iso_50_crw, "raw_modes/Canon PowerShot S60_ISO_50.CRW");
}
mod camera_powershot_s70_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S70", cam_canon_powershot_s70_iso_100_crw, "raw_modes/Canon PowerShot S70_ISO_100.CRW");
}
mod camera_powershot_s90_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S90", cam_canon_powershot_s90_iso_80_raw_cr2, "raw_modes/Canon PowerShot S90_ISO_80_RAW.CR2");
}
mod camera_powershot_s95_raw_modes {
  super::camera_file_check!("Canon", "PowerShot S95", cam_canon_powershot_s95_iso_400_raw_cr2, "raw_modes/Canon PowerShot S95_ISO_400_RAW.CR2");
}
mod camera_powershot_sd750_raw_modes {
  super::camera_file_check!("Canon", "PowerShot SD750", cam_canon_powershot_sd750_crw, "raw_modes/Canon PowerShot SD750.CRW");
}
mod camera_powershot_sx110_is_raw_modes {
  super::camera_file_check!("Canon", "PowerShot SX110 IS", cam_powershot_sx110_is_crw, "raw_modes/PowerShot SX110 IS.CRW");
}
mod camera_powershot_sx160_is_raw_modes {
  super::camera_file_check!("Canon", "PowerShot SX160 IS", cam_canon_powershot_sx160_is_crw, "raw_modes/Canon PowerShot SX160 IS.CRW");
}
mod camera_powershot_sx1_is_raw_modes {
  super::camera_file_check!("Canon", "PowerShot SX1 IS", cam_canon_powershot_sx1_is_iso_80_raw_cr2, "raw_modes/Canon PowerShot SX1 IS_ISO_80_RAW.CR2");
}
mod camera_powershot_sx260_hs_raw_modes {
  super::camera_file_check!("Canon", "PowerShot SX260 HS", cam_powershot_sx260_hs_crw, "raw_modes/PowerShot SX260 HS.CRW");
}
mod camera_powershot_sx40_hs_raw_modes {
  super::camera_file_check!("Canon", "PowerShot SX40 HS", cam_crw_6036_cr2, "raw_modes/CRW_6036.CR2");
}
mod camera_powershot_sx50_hs_raw_modes {
  super::camera_file_check!("Canon", "PowerShot SX50 HS", cam_canon_powershot_sx50_hs_iso_80_raw_cr2, "raw_modes/Canon PowerShot SX50 HS_ISO_80_RAW.CR2");
}
mod camera_powershot_sx60_hs_raw_modes {
  super::camera_file_check!("Canon", "PowerShot SX60 HS", cam_canon_powershot_sx60_hs_iso_100_raw_cr2, "raw_modes/Canon PowerShot SX60 HS_ISO_100_RAW.CR2");
  super::camera_file_check!("Canon", "PowerShot SX60 HS", cam_raw_canon_powershot_sx60_hs_cr2, "raw_modes/RAW_CANON_POWERSHOT_SX60-HS.CR2");
}
mod camera_powershot_sx70_hs_raw_modes {
  super::camera_file_check!("Canon", "PowerShot SX70 HS", cam_canon_powershot_sx70_hs_raw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon PowerShot SX70 HS_RAW_ISO_100_nocrop_nodual.CR3");
  super::camera_file_check!("Canon", "PowerShot SX70 HS", cam_canon_powershot_sx70_hs_craw_iso_100_nocrop_nodual_cr3, "raw_modes/Canon PowerShot SX70 HS_CRAW_ISO_100_nocrop_nodual.CR3");
}
mod camera_sx150is_raw_modes {
  super::camera_file_check!("Canon", "SX150IS", cam_sx150is_crw, "raw_modes/SX150IS.CRW");
}
mod camera_ist_dl2_raw_modes {
  super::camera_file_check!("Pentax", "ist DL2", cam_pentax_ist_dl2_raw_iso_200_pef, "raw_modes/PENTAX ist DL2_RAW_ISO_200.PEF");
}
mod camera_k_5_ii_raw_modes {
  super::camera_file_check!("Pentax", "K-5 II", cam_pentax_k_5_ii_raw_iso_500_pef, "raw_modes/PENTAX K-5 II_RAW_ISO_500.PEF");
}
mod camera_645d_raw_modes {
  super::camera_file_check!("Pentax", "645D", cam_pentax_645d_raw_iso_200_pef, "raw_modes/PENTAX 645D_RAW_ISO_200.PEF");
}
mod camera_645z_raw_modes {
  super::camera_file_check!("Pentax", "645Z", cam_pentax_645z_raw_iso_100_pef, "raw_modes/PENTAX 645Z_RAW_ISO_100.PEF");
}
mod camera_ist_dl_raw_modes {
  super::camera_file_check!("Pentax", "ist DL", cam_pentax_ist_dl_raw_iso_200_pef, "raw_modes/PENTAX ist DL_RAW_ISO_200.PEF");
}
mod camera_k_3_raw_modes {
  super::camera_file_check!("Pentax", "K-3", cam_pentax_k_3_raw_iso_100_pef, "raw_modes/PENTAX K-3_RAW_ISO_100.PEF");
}
mod camera_k_3_iii_monochrome_raw_modes {
  super::camera_file_check!("Pentax", "K-3 III Monochrome", cam_pentax_k_3_mark_iii_monochrome_iso_200_14bits_pef, "raw_modes/PENTAX K-3 Mark III Monochrome_ISO_200_14bits.PEF");
}
mod camera_k_7_raw_modes {
  super::camera_file_check!("Pentax", "K-7", cam_pentax_k_7_raw_iso_3200_pef, "raw_modes/PENTAX K-7_RAW_ISO_3200.PEF");
}
mod camera_k_3_ii_raw_modes {
  super::camera_file_check!("Pentax", "K-3 II", cam_pentax_k_3_ii_raw_iso_100_pef, "raw_modes/PENTAX K-3 II_RAW_ISO_100.PEF");
}
mod camera_k_3_iii_raw_modes {
  super::camera_file_check!("Pentax", "K-3 III", cam_pentax_k_3_mark_iii_iso_800_14bits_pixelshift_without_motion_corr_pef, "raw_modes/PENTAX K-3 Mark III_ISO_800_14bits_pixelshift_without_motion_corr.PEF");
  super::camera_file_check!("Pentax", "K-3 III", cam_pentax_k_3_mark_iii_iso_800_14bits_pixelshift_with_motion_corr_pef, "raw_modes/PENTAX K-3 Mark III_ISO_800_14bits_pixelshift_with_motion_corr.PEF");
  super::camera_file_check!("Pentax", "K-3 III", cam_pentax_k_3_mark_iii_iso_800_14bits_automode_pef, "raw_modes/PENTAX K-3 Mark III_ISO_800_14bits_automode.PEF");
  super::camera_file_check!("Pentax", "K-3 III", cam_pentax_k_3_mark_iii_iso_800_14bits_hdr_advanced_pef, "raw_modes/PENTAX K-3 Mark III_ISO_800_14bits_hdr_advanced.PEF");
}
mod camera_k_70_raw_modes {
  super::camera_file_check!("Pentax", "K-70", cam_pentax_k_70_raw_iso_400_pef, "raw_modes/PENTAX K-70_RAW_ISO_400.PEF");
}
mod camera_k_m_raw_modes {
  super::camera_file_check!("Pentax", "K-m", cam_pentax_k_m_raw_iso_200_pef, "raw_modes/PENTAX K-m_RAW_ISO_200.PEF");
}
mod camera_k_r_raw_modes {
  super::camera_file_check!("Pentax", "K-r", cam_pentax_k_r_raw_iso_200_pef, "raw_modes/PENTAX K-r_RAW_ISO_200.PEF");
}
mod camera_kf_raw_modes {
  super::camera_file_check!("Pentax", "Kf", cam_pentax_kf_iso_200_14bits_pef, "raw_modes/PENTAX KF_ISO_200_14bits.PEF");
}
mod camera_k_5_ii_s_raw_modes {
  super::camera_file_check!("Pentax", "K-5 II s", cam_pentax_k_5_ii_s_raw_iso_200_pef, "raw_modes/PENTAX K-5 II s_RAW_ISO_200.PEF");
}
mod camera_ist_ds_raw_modes {
  super::camera_file_check!("Pentax", "ist DS", cam_pentax_ist_ds_raw_iso_200_pef, "raw_modes/PENTAX ist DS_RAW_ISO_200.PEF");
}
mod camera_k_1_mark_ii_raw_modes {
  super::camera_file_check!("Pentax", "K-1 Mark II", cam_pentax_k_1_mark_ii_raw__pixel_shift_enabled__iso_125_pef, "raw_modes/PENTAX K-1 Mark II_RAW (pixel shift enabled)_ISO_125.PEF");
  super::camera_file_check!("Pentax", "K-1 Mark II", cam_pentax_k_1_mark_ii_raw_iso_125_pef, "raw_modes/PENTAX K-1 Mark II_RAW_ISO_125.PEF");
}
mod camera_ist_d_raw_modes {
  super::camera_file_check!("Pentax", "ist D", cam_pentax_ist_d_raw_iso_200_pef, "raw_modes/PENTAX ist D_RAW_ISO_200.PEF");
}
mod camera_k100d_super_raw_modes {
  super::camera_file_check!("Pentax", "K100D Super", cam_pentax_k100d_super_raw_iso_200_pef, "raw_modes/PENTAX K100D Super_RAW_ISO_200.PEF");
}
mod camera_k_s2_raw_modes {
  super::camera_file_check!("Pentax", "K-S2", cam_pentax_k_s2_raw_iso_1250_pef, "raw_modes/PENTAX K-S2_RAW_ISO_1250.PEF");
}
mod camera_k_5_raw_modes {
  super::camera_file_check!("Pentax", "K-5", cam_pentax_k_5_raw_iso_160_pef, "raw_modes/PENTAX K-5_RAW_ISO_160.PEF");
}
mod camera_k10d_raw_modes {
  super::camera_file_check!("Pentax", "K10D", cam_pentax_k10d_raw_iso_100_pef, "raw_modes/PENTAX K10D_RAW_ISO_100.PEF");
}
mod camera_k100d_raw_modes {
  super::camera_file_check!("Pentax", "K100D", cam_pentax_k100d_raw_iso_200_pef, "raw_modes/PENTAX K100D_RAW_ISO_200.PEF");
}
mod camera_k_1_raw_modes {
  super::camera_file_check!("Pentax", "K-1", cam_pentax_k_1_raw__pixel_shift_enabled__iso_160_pef, "raw_modes/PENTAX K-1_RAW (pixel shift enabled)_ISO_160.PEF");
  super::camera_file_check!("Pentax", "K-1", cam_pentax_k_1_raw_iso_160_pef, "raw_modes/PENTAX K-1_RAW_ISO_160.PEF");
}
mod camera_kp_raw_modes {
  super::camera_file_check!("Pentax", "KP", cam_pentax_kp_raw_iso_400_pef, "raw_modes/PENTAX KP_RAW_ISO_400.PEF");
}
mod camera_k200d_raw_modes {
  super::camera_file_check!("Pentax", "K200D", cam_pentax_k200d_raw_iso_100_pef, "raw_modes/PENTAX K200D_RAW_ISO_100.PEF");
}
mod camera_k_s1_raw_modes {
  super::camera_file_check!("Pentax", "K-S1", cam_pentax_k_s1_raw_iso_100_pef, "raw_modes/PENTAX K-S1_RAW_ISO_100.PEF");
}
mod camera_k_x_raw_modes {
  super::camera_file_check!("Pentax", "K-x", cam_pentax_k_x_raw_iso_2000_pef, "raw_modes/PENTAX K-x_RAW_ISO_2000.PEF");
}
mod camera_k20d_raw_modes {
  super::camera_file_check!("Pentax", "K20D", cam_pentax_k20d_raw_iso_200_pef, "raw_modes/PENTAX K20D_RAW_ISO_200.PEF");
}
mod camera_k110d_raw_modes {
  super::camera_file_check!("Pentax", "K110D", cam_pentax_k110d_raw_iso_200_pef, "raw_modes/PENTAX K110D_RAW_ISO_200.PEF");
}
mod camera_iq3_100mp_raw_modes {
  super::camera_file_check!("Phase One", "IQ3 100MP", cam_iq3_100mp_l16_iso_50_iiq, "raw_modes/IQ3 100MP_L16_ISO_50.IIQ");
  super::camera_file_check!("Phase One", "IQ3 100MP", cam_iq3_100mp_iiq_l_iso_50_iiq, "raw_modes/IQ3 100MP_IIQ L_ISO_50.IIQ");
  super::camera_file_check!("Phase One", "IQ3 100MP", cam_iq3_100mp_iiq_sv2_iso_50_iiq, "raw_modes/IQ3 100MP_IIQ Sv2_ISO_50.IIQ");
}
mod camera_h_25_raw_modes {
  super::camera_file_check!("Phase One", "H 25", cam_h_25_iiq_s_iso_100_iiq, "raw_modes/H 25_IIQ S_ISO_100.IIQ");
  super::camera_file_check!("Phase One", "H 25", cam_h_25_raw0_iso_50_iiq, "raw_modes/H 25_Raw0_ISO_50.IIQ");
}
mod camera_ixm_100_raw_modes {
  super::camera_file_check!("Phase One", "iXM-100", cam_ixm_100_iiq_l_iso_100_iiq, "raw_modes/iXM-100_IIQ L_ISO_100.IIQ");
  super::camera_file_check!("Phase One", "iXM-100", cam_ixm_100_iiq_sv2_iso_100_iiq, "raw_modes/iXM-100_IIQ Sv2_ISO_100.IIQ");
}
mod camera_iq180_raw_modes {
  super::camera_file_check!("Phase One", "IQ180", cam_iq180_iiq_l_iso_100_iiq, "raw_modes/IQ180_IIQ L_ISO_100.IIQ");
}
mod camera_iq4_150mp_raw_modes {
  super::camera_file_check!("Phase One", "IQ4 150MP", cam_iq4_150mp_iiq_l16_iso_100_iiq, "raw_modes/IQ4 150MP_IIQ L16_ISO_100.IIQ");
  super::camera_file_check!("Phase One", "IQ4 150MP", cam_iq4_150mp_iiq_l16ex_iso_100_iiq, "raw_modes/IQ4 150MP_IIQ L16ex_ISO_100.IIQ");
  super::camera_file_check!("Phase One", "IQ4 150MP", cam_iq4_150mp_iiq_l_iso_100_iiq, "raw_modes/IQ4 150MP_IIQ L_ISO_100.IIQ");
}
mod camera_iq140_raw_modes {
  super::camera_file_check!("Phase One", "IQ140", cam_iq140_iiq_l_iso_50_iiq, "raw_modes/IQ140_IIQ L_ISO_50.IIQ");
  super::camera_file_check!("Phase One", "IQ140", cam_iq140_iiq_l_iso_200_sensorplus_iiq, "raw_modes/IQ140_IIQ L_ISO_200_SensorPlus.IIQ");
  super::camera_file_check!("Phase One", "IQ140", cam_iq140_iiq_sv2_iso_50_iiq, "raw_modes/IQ140_IIQ Sv2_ISO_50.IIQ");
  super::camera_file_check!("Phase One", "IQ140", cam_iq140_iiq_sv2_iso_200_sensorplus_iiq, "raw_modes/IQ140_IIQ Sv2_ISO_200_SensorPlus.IIQ");
}
mod camera_p30_raw_modes {
  super::camera_file_check!("Phase One", "P30", cam_p30_iiq_l_iso_100_iiq, "raw_modes/P30_IIQ L_ISO_100.IIQ");
}
mod camera_iq3_100mp_trichr_raw_modes {
  super::camera_file_check!("Phase One", "IQ3 100MP Trichr", cam_iq3_100mp_trichr_l16_iso_50_iiq, "raw_modes/IQ3 100MP Trichr_L16_ISO_50.IIQ");
}
mod camera_iq150_raw_modes {
  super::camera_file_check!("Phase One", "IQ150", cam_iq150_iiq_l_iso_400_iiq, "raw_modes/IQ150_IIQ L_ISO_400.IIQ");
}
mod camera_ixm_rs150f_raw_modes {
  super::camera_file_check!("Phase One", "iXM-RS150F", cam_ixm_rs150f_iiq_sv2_iso_160_iiq, "raw_modes/iXM-RS150F_IIQ Sv2_ISO_160.IIQ");
}
mod camera_p65_raw_modes {
  super::camera_file_check!("Phase One", "P65", cam_p65_plus_iiq_l_iso_200_iiq, "raw_modes/P65 Plus_IIQ L_ISO_200.IIQ");
  super::camera_file_check!("Phase One", "P65", cam_p65_plus_iiq_s_iso_200_iiq, "raw_modes/P65 Plus_IIQ S_ISO_200.IIQ");
}
mod camera_p20_raw_modes {
  super::camera_file_check!("Phase One", "P20", cam_p20_plus_iiq_s_iso_50_iiq, "raw_modes/P20 Plus_IIQ S_ISO_50.IIQ");
  super::camera_file_check!("Phase One", "P20", cam_p20_plus_iiq_l_iso_50_iiq, "raw_modes/P20 Plus_IIQ L_ISO_50.IIQ");
}
mod camera_p25_raw_modes {
  super::camera_file_check!("Phase One", "P25", cam_p25_4x3_s_iiq, "raw_modes/P25_4x3_S.IIQ");
  super::camera_file_check!("Phase One", "P25", cam_p25_4x3_l_iiq, "raw_modes/P25_4x3_L.IIQ");
}
mod camera_p25plus_raw_modes {
  super::camera_file_check!("Phase One", "P25+", cam_p25__s_4x3_iiq, "raw_modes/P25+_S_4x3.IIQ");
  super::camera_file_check!("Phase One", "P25+", cam_p25__l_4x3_iiq, "raw_modes/P25+_L_4x3.IIQ");
}
mod camera_p45plus_raw_modes {
  super::camera_file_check!("Phase One", "P45+", cam_p45__l_4x3_iiq, "raw_modes/P45+_L_4x3.IIQ");
  super::camera_file_check!("Phase One", "P45+", cam_p45__s_4x3_iiq, "raw_modes/P45+_S_4x3.IIQ");
}
mod camera_d3500_raw_modes {
  super::camera_file_check!("Nikon", "D3500", cam_nikon_d3500_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON D3500_ISO_100_12bits_Lossy (type 2).NEF");
}
mod camera_1_v2_raw_modes {
  super::camera_file_check!("Nikon", "1 V2", cam_nikon_1_v2_iso_200_12bits_lossy__type_2__nef, "raw_modes/NIKON 1 V2_ISO_200_12bits_Lossy (type 2).NEF");
}
mod camera_d40x_raw_modes {
  super::camera_file_check!("Nikon", "D40X", cam_nikon_d40x_iso_250_12bits_lossy__type_1__nef, "raw_modes/NIKON D40X_ISO_250_12bits_Lossy (type 1).NEF");
}
mod camera_d5600_raw_modes {
  super::camera_file_check!("Nikon", "D5600", cam_nikon_d5600_iso_12800_12bits_lossy__type_2__nef, "raw_modes/NIKON D5600_ISO_12800_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D5600", cam_nikon_d5600_iso_200_14bits_lossy__type_2__nef, "raw_modes/NIKON D5600_ISO_200_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D5600", cam_nikon_d5600_iso_12800_14bits_lossy__type_2__nef, "raw_modes/NIKON D5600_ISO_12800_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D5600", cam_nikon_d5600_iso_200_12bits_lossy__type_2__nef, "raw_modes/NIKON D5600_ISO_200_12bits_Lossy (type 2).NEF");
}
mod camera_d70s_raw_modes {
  super::camera_file_check!("Nikon", "D70s", cam_nikon_d70s_iso_200_12bits_lossy__type_1__nef, "raw_modes/NIKON D70s_ISO_200_12bits_Lossy (type 1).NEF");
}
mod camera_coolpix_p7100_raw_modes {
  super::camera_file_check!("Nikon", "Coolpix P7100", cam_coolpix_p7100_iso_100_12bits_uncompressed_nrw, "raw_modes/COOLPIX P7100_ISO_100_12bits_Uncompressed.NRW");
}
mod camera_d600_raw_modes {
  super::camera_file_check!("Nikon", "D600", cam_nikon_d600_iso_400_14bits_lossless_nef, "raw_modes/NIKON D600_ISO_400_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D600", cam_nikon_d600_iso_400_12bits_lossy__type_2__nef, "raw_modes/NIKON D600_ISO_400_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D600", cam_nikon_d600_iso_400_12bits_lossless_nef, "raw_modes/NIKON D600_ISO_400_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D600", cam_nikon_d600_iso_400_14bits_lossy__type_2__nef, "raw_modes/NIKON D600_ISO_400_14bits_Lossy (type 2).NEF");
}
mod camera_d2x_raw_modes {
  super::camera_file_check!("Nikon", "D2X", cam_nikon_d2x_iso_100_12bits_uncompressed_nef, "raw_modes/NIKON D2X_ISO_100_12bits_Uncompressed.NEF");
}
mod camera_d40_raw_modes {
  super::camera_file_check!("Nikon", "D40", cam_nikon_d40_iso_200_12bits_lossy__type_1__nef, "raw_modes/NIKON D40_ISO_200_12bits_Lossy (type 1).NEF");
}
mod camera_d4_raw_modes {
  super::camera_file_check!("Nikon", "D4", cam_nikon_d4_iso_400_12bits_lossy__type_2__nef, "raw_modes/NIKON D4_ISO_400_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D4", cam_nikon_d4_iso_400_12bits_uncompressed_nef, "raw_modes/NIKON D4_ISO_400_12bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D4", cam_nikon_d4_iso_400_14bits_lossless_nef, "raw_modes/NIKON D4_ISO_400_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D4", cam_nikon_d4_iso_400_14bits_uncompressed_nef, "raw_modes/NIKON D4_ISO_400_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D4", cam_nikon_d4_iso_400_12bits_lossless_nef, "raw_modes/NIKON D4_ISO_400_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D4", cam_nikon_d4_iso_400_14bits_lossy__type_2__nef, "raw_modes/NIKON D4_ISO_400_14bits_Lossy (type 2).NEF");
}
mod camera_d300s_raw_modes {
  super::camera_file_check!("Nikon", "D300S", cam_nikon_d300s_iso_100_14bits_uncompressed_nef, "raw_modes/NIKON D300S_ISO_100_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D300S", cam_nikon_d300s_iso_100_12bits_lossless_nef, "raw_modes/NIKON D300S_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D300S", cam_nikon_d300s_iso_100_12bits_uncompressed_nef, "raw_modes/NIKON D300S_ISO_100_12bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D300S", cam_nikon_d300s_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON D300S_ISO_100_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D300S", cam_nikon_d300s_iso_100_14bits_lossless_nef, "raw_modes/NIKON D300S_ISO_100_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D300S", cam_nikon_d300s_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON D300S_ISO_100_12bits_Lossy (type 2).NEF");
}
mod camera_d2xs_raw_modes {
  super::camera_file_check!("Nikon", "D2Xs", cam_nikon_d2xs_iso_100_12bits_uncompressed_nef, "raw_modes/NIKON D2Xs_ISO_100_12bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D2Xs", cam_nikon_d2xs_iso_100_12bits_lossy__type_1__nef, "raw_modes/NIKON D2Xs_ISO_100_12bits_Lossy (type 1).NEF");
}
mod camera_d3_raw_modes {
  super::camera_file_check!("Nikon", "D3", cam_nikon_d3_iso_200_14bits_lossless_nef, "raw_modes/NIKON D3_ISO_200_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D3", cam_nikon_d3_iso_200_12bits_lossy__type_2__nef, "raw_modes/NIKON D3_ISO_200_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D3", cam_nikon_d3_iso_200_12bits_lossless_nef, "raw_modes/NIKON D3_ISO_200_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D3", cam_nikon_d3_iso_200_14bits_uncompressed_nef, "raw_modes/NIKON D3_ISO_200_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D3", cam_nikon_d3_iso_200_14bits_lossy__type_2__nef, "raw_modes/NIKON D3_ISO_200_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D3", cam_nikon_d3_iso_200_12bits_uncompressed_nef, "raw_modes/NIKON D3_ISO_200_12bits_Uncompressed.NEF");
}
mod camera_d800e_raw_modes {
  super::camera_file_check!("Nikon", "D800E", cam_nikon_d800e_iso_560_14bits_uncompressed_nef, "raw_modes/NIKON D800E_ISO_560_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D800E", cam_nikon_d800e_iso_100_14bits_lossless_nef, "raw_modes/NIKON D800E_ISO_100_14bits_Lossless.NEF");
}
mod camera_e5400_raw_modes {
  super::camera_file_check!("Nikon", "E5400", cam_e5400_iso_0_12bits_uncompressed_nef, "raw_modes/E5400_ISO_0_12bits_Uncompressed.NEF");
}
mod camera_coolpix_p6000_raw_modes {
  super::camera_file_check!("Nikon", "Coolpix P6000", cam_coolpix_p6000_iso_64_12bits_uncompressed_nrw, "raw_modes/COOLPIX P6000_ISO_64_12bits_Uncompressed.NRW");
}
mod camera_d700_raw_modes {
  super::camera_file_check!("Nikon", "D700", cam_nikon_d700_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON D700_ISO_100_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D700", cam_nikon_d700_iso_100_14bits_lossless_nef, "raw_modes/NIKON D700_ISO_100_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D700", cam_nikon_d700_iso_100_14bits_uncompressed_nef, "raw_modes/NIKON D700_ISO_100_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D700", cam_nikon_d700_iso_100_12bits_lossless_nef, "raw_modes/NIKON D700_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D700", cam_nikon_d700_iso_100_12bits_uncompressed_nef, "raw_modes/NIKON D700_ISO_100_12bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D700", cam_nikon_d700_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON D700_ISO_100_12bits_Lossy (type 2).NEF");
}
mod camera_coolpix_p7000_raw_modes {
  super::camera_file_check!("Nikon", "Coolpix P7000", cam_coolpix_p7000_iso_800_12bits_uncompressed_nrw, "raw_modes/COOLPIX P7000_ISO_800_12bits_Uncompressed.NRW");
}
mod camera_d3400_raw_modes {
  super::camera_file_check!("Nikon", "D3400", cam_nikon_d3400_iso_3200_12bits_lossy__type_2__nef, "raw_modes/NIKON D3400_ISO_3200_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D3400", cam_nikon_d3400_iso_400_12bits_lossy__type_2__nef, "raw_modes/NIKON D3400_ISO_400_12bits_Lossy (type 2).NEF");
}
mod camera_d780_raw_modes {
  super::camera_file_check!("Nikon", "D780", cam_nikon_d780_iso_100_14bits_lossless_nef, "raw_modes/NIKON D780_ISO_100_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D780", cam_nikon_d780_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON D780_ISO_100_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D780", cam_nikon_d780_iso_100_12bits_lossless_nef, "raw_modes/NIKON D780_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D780", cam_nikon_d780_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON D780_ISO_100_12bits_Lossy (type 2).NEF");
}
mod camera_d2hs_raw_modes {
  super::camera_file_check!("Nikon", "D2Hs", cam_nikon_d2hs_iso_200_12bits_uncompressed_nef, "raw_modes/NIKON D2Hs_ISO_200_12bits_Uncompressed.NEF");
}
mod camera_1_v1_raw_modes {
  super::camera_file_check!("Nikon", "1 V1", cam_nikon_1_v1_iso_400_12bits_lossy__type_2__nef, "raw_modes/NIKON 1 V1_ISO_400_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "1 V1", cam_nikon_1_v1_iso_800_12bits_lossy__type_2__nef, "raw_modes/NIKON 1 V1_ISO_800_12bits_Lossy (type 2).NEF");
}
mod camera_d610_raw_modes {
  super::camera_file_check!("Nikon", "D610", cam_nikon_d610_iso_400_14bits_lossy__type_2__nef, "raw_modes/NIKON D610_ISO_400_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D610", cam_nikon_d610_iso_400_12bits_lossy__type_2__nef, "raw_modes/NIKON D610_ISO_400_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D610", cam_nikon_d610_iso_400_14bits_lossless_nef, "raw_modes/NIKON D610_ISO_400_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D610", cam_nikon_d610_iso_400_12bits_lossless_nef, "raw_modes/NIKON D610_ISO_400_12bits_Lossless.NEF");
}
mod camera_1_j3_raw_modes {
  super::camera_file_check!("Nikon", "1 J3", cam_nikon_1_j3_iso_160_12bits_lossy__type_2__nef, "raw_modes/NIKON 1 J3_ISO_160_12bits_Lossy (type 2).NEF");
}
mod camera_d50_raw_modes {
  super::camera_file_check!("Nikon", "D50", cam_nikon_d50_iso_200_12bits_lossy__type_1__nef, "raw_modes/NIKON D50_ISO_200_12bits_Lossy (type 1).NEF");
}
mod camera_d3x_raw_modes {
  super::camera_file_check!("Nikon", "D3X", cam_nikon_d3x_iso_125_14bits_uncompressed_nef, "raw_modes/NIKON D3X_ISO_125_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D3X", cam_nikon_d3x_iso_100_14bits_lossless_nef, "raw_modes/NIKON D3X_ISO_100_14bits_Lossless.NEF");
}
mod camera_d5500_raw_modes {
  super::camera_file_check!("Nikon", "D5500", cam_nikon_d5500_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON D5500_ISO_100_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D5500", cam_nikon_d5500_iso_6400_14bits_lossy__type_2__nef, "raw_modes/NIKON D5500_ISO_6400_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D5500", cam_nikon_d5500_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON D5500_ISO_100_14bits_Lossy (type 2).NEF");
}
mod camera_d500_raw_modes {
  super::camera_file_check!("Nikon", "D500", cam_nikon_d500_large_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON D500_Large_ISO_100_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D500", cam_nikon_d500_small_iso_100_12bits_lossless_nef, "raw_modes/NIKON D500_Small_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D500", cam_nikon_d500_large_iso_100_14bits_lossless_nef, "raw_modes/NIKON D500_Large_ISO_100_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D500", cam_nikon_d500_large_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON D500_Large_ISO_100_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D500", cam_nikon_d500_large_iso_100_14bits_uncompressed_nef, "raw_modes/NIKON D500_Large_ISO_100_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D500", cam_nikon_d500_large_iso_100_12bits_uncompressed__reduced_to_12_bit__nef, "raw_modes/NIKON D500_Large_ISO_100_12bits_Uncompressed (reduced to 12 bit).NEF");
  super::camera_file_check!("Nikon", "D500", cam_nikon_d500_medium_iso_100_12bits_lossless_nef, "raw_modes/NIKON D500_Medium_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D500", cam_nikon_d500_large_iso_100_12bits_lossless_nef, "raw_modes/NIKON D500_Large_ISO_100_12bits_Lossless.NEF");
}
mod camera_coolpix_b700_raw_modes {
  super::camera_file_check!("Nikon", "COOLPIX B700", cam_coolpix_b700_iso_100_12bits_uncompressed_nrw, "raw_modes/COOLPIX B700_ISO_100_12bits_Uncompressed.NRW");
}
mod camera_coolpix_p7800_raw_modes {
  super::camera_file_check!("Nikon", "Coolpix P7800", cam_coolpix_p7800_iso_80_12bits_uncompressed_nrw, "raw_modes/COOLPIX P7800_ISO_80_12bits_Uncompressed.NRW");
}
mod camera_coolpix_p1000_raw_modes {
  super::camera_file_check!("Nikon", "COOLPIX P1000", cam_coolpix_p1000_iso_100_12bits_uncompressed_nrw, "raw_modes/COOLPIX P1000_ISO_100_12bits_Uncompressed.NRW");
}
mod camera_e5700_raw_modes {
  super::camera_file_check!("Nikon", "E5700", cam_e5700_iso_0_12bits_uncompressed_nef, "raw_modes/E5700_ISO_0_12bits_Uncompressed.NEF");
}
mod camera_d850_raw_modes {
  super::camera_file_check!("Nikon", "D850", cam_nikon_d850_medium_iso_64_12bits_lossless_nef, "raw_modes/NIKON D850_Medium_ISO_64_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D850", cam_nikon_d850_large_iso_64_14bits_lossy__type_2__nef, "raw_modes/NIKON D850_Large_ISO_64_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D850", cam_nikon_d850_large_iso_64_12bits_uncompressed__reduced_to_12_bit__nef, "raw_modes/NIKON D850_Large_ISO_64_12bits_Uncompressed (reduced to 12 bit).NEF");
  super::camera_file_check!("Nikon", "D850", cam_nikon_d850_large_iso_64_14bits_uncompressed_nef, "raw_modes/NIKON D850_Large_ISO_64_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D850", cam_nikon_d850_large_iso_64_14bits_lossless_nef, "raw_modes/NIKON D850_Large_ISO_64_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D850", cam_nikon_d850_large_iso_64_12bits_lossy__type_2__nef, "raw_modes/NIKON D850_Large_ISO_64_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D850", cam_nikon_d850_small_iso_64_12bits_lossless_nef, "raw_modes/NIKON D850_Small_ISO_64_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D850", cam_nikon_d850_large_iso_64_12bits_lossless_nef, "raw_modes/NIKON D850_Large_ISO_64_12bits_Lossless.NEF");
}
mod camera_d2h_raw_modes {
  super::camera_file_check!("Nikon", "D2H", cam_nikon_d2h_iso_200_12bits_lossy__type_1__nef, "raw_modes/NIKON D2H_ISO_200_12bits_Lossy (type 1).NEF");
}
mod camera_d7500_raw_modes {
  super::camera_file_check!("Nikon", "D7500", cam_nikon_d7500_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON D7500_ISO_100_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D7500", cam_nikon_d7500_iso_100_12bits_lossless_nef, "raw_modes/NIKON D7500_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D7500", cam_nikon_d7500_iso_100_14bits_lossless_nef, "raw_modes/NIKON D7500_ISO_100_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D7500", cam_nikon_d7500_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON D7500_ISO_100_12bits_Lossy (type 2).NEF");
}
mod camera_coolpix_a_raw_modes {
  super::camera_file_check!("Nikon", "Coolpix A", cam_coolpix_a_iso_100_14bits_lossy__type_2__nef, "raw_modes/COOLPIX A_ISO_100_14bits_Lossy (type 2).NEF");
}
mod camera_d3300_raw_modes {
  super::camera_file_check!("Nikon", "D3300", cam_nikon_d3300_iso_400_12bits_lossy__type_2__nef, "raw_modes/NIKON D3300_ISO_400_12bits_Lossy (type 2).NEF");
}
mod camera_d5000_raw_modes {
  super::camera_file_check!("Nikon", "D5000", cam_nikon_d5000_iso_400_12bits_lossy__type_2__nef, "raw_modes/NIKON D5000_ISO_400_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D5000", cam_nikon_d5000_iso_200_12bits_lossy__type_2__nef, "raw_modes/NIKON D5000_ISO_200_12bits_Lossy (type 2).NEF");
}
mod camera_d7100_raw_modes {
  super::camera_file_check!("Nikon", "D7100", cam_nikon_d7100_iso_200_14bits_lossy__type_2__nef, "raw_modes/NIKON D7100_ISO_200_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D7100", cam_nikon_d7100_iso_200_12bits_lossless_nef, "raw_modes/NIKON D7100_ISO_200_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D7100", cam_nikon_d7100_iso_200_14bits_lossless_nef, "raw_modes/NIKON D7100_ISO_200_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D7100", cam_nikon_d7100_iso_200_12bits_lossy__type_2__nef, "raw_modes/NIKON D7100_ISO_200_12bits_Lossy (type 2).NEF");
}
mod camera_1_s2_raw_modes {
  super::camera_file_check!("Nikon", "1 S2", cam_nikon_1_s2_iso_720_12bits_lossy__type_2__nef, "raw_modes/NIKON 1 S2_ISO_720_12bits_Lossy (type 2).NEF");
}
mod camera_d90_raw_modes {
  super::camera_file_check!("Nikon", "D90", cam_nikon_d90_iso_250_12bits_lossy__type_2__nef, "raw_modes/NIKON D90_ISO_250_12bits_Lossy (type 2).NEF");
}
mod camera_1_aw1_raw_modes {
  super::camera_file_check!("Nikon", "1 AW1", cam_nikon_1_aw1_iso_160_12bits_lossy__type_2__nef, "raw_modes/NIKON 1 AW1_ISO_160_12bits_Lossy (type 2).NEF");
}
mod camera_d5_raw_modes {
  super::camera_file_check!("Nikon", "D5", cam_nikon_d5_iso_400_14bits_lossy__type_2__nef, "raw_modes/NIKON D5_ISO_400_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D5", cam_nikon_d5_iso_100_14bits_uncompressed_nef, "raw_modes/NIKON D5_ISO_100_14bits_Uncompressed.NEF");
}
mod camera_coolpix_a1000_raw_modes {
  super::camera_file_check!("Nikon", "COOLPIX A1000", cam_coolpix_a1000_iso_280_12bits_uncompressed_nrw, "raw_modes/COOLPIX A1000_ISO_280_12bits_Uncompressed.NRW");
}
mod camera_e8400_raw_modes {
  super::camera_file_check!("Nikon", "E8400", cam_e8400_iso_100_12bits_uncompressed_nef, "raw_modes/E8400_ISO_100_12bits_Uncompressed.NEF");
}
mod camera_d100_raw_modes {
  super::camera_file_check!("Nikon", "D100", cam_nikon_d100_iso_400_12bits_uncompressed_nef, "raw_modes/NIKON D100_ISO_400_12bits_Uncompressed.NEF");
}
mod camera_d810_raw_modes {
  super::camera_file_check!("Nikon", "D810", cam_nikon_d810_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON D810_ISO_100_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D810", cam_nikon_d810_iso_100_12bits_lossless_nef, "raw_modes/NIKON D810_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D810", cam_nikon_d810_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON D810_ISO_100_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D810", cam_nikon_d810_iso_100_12bits_small_nef, "raw_modes/NIKON D810_ISO_100_12bits_Small.NEF");
  super::camera_file_check!("Nikon", "D810", cam_nikon_d810_iso_100_14bits_uncompressed_nef, "raw_modes/NIKON D810_ISO_100_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D810", cam_nikon_d810_iso_100_14bits_lossless_nef, "raw_modes/NIKON D810_ISO_100_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D810", cam_nikon_d810_iso_100_12bits_uncompressed__reduced_to_12_bit__nef, "raw_modes/NIKON D810_ISO_100_12bits_Uncompressed (reduced to 12 bit).NEF");
}
mod camera_1_j1_raw_modes {
  super::camera_file_check!("Nikon", "1 J1", cam_nikon_1_j1_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON 1 J1_ISO_100_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "1 J1", cam_nikon_1_j1_iso_200_12bits_lossy__type_2__nef, "raw_modes/NIKON 1 J1_ISO_200_12bits_Lossy (type 2).NEF");
}
mod camera_d7000_raw_modes {
  super::camera_file_check!("Nikon", "D7000", cam_nikon_d7000_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON D7000_ISO_100_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D7000", cam_nikon_d7000_iso_hi_12800_14bits_lossy__type_2__nef, "raw_modes/NIKON D7000_ISO_Hi 12800_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D7000", cam_nikon_d7000_iso_100_14bits_lossless_nef, "raw_modes/NIKON D7000_ISO_100_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D7000", cam_nikon_d7000_iso_100_12bits_lossless_nef, "raw_modes/NIKON D7000_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D7000", cam_nikon_d7000_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON D7000_ISO_100_12bits_Lossy (type 2).NEF");
}
mod camera_1_v3_raw_modes {
  super::camera_file_check!("Nikon", "1 V3", cam_nikon_1_v3_iso_160_12bits_lossy__type_2__nef, "raw_modes/NIKON 1 V3_ISO_160_12bits_Lossy (type 2).NEF");
}
mod camera_d5100_raw_modes {
  super::camera_file_check!("Nikon", "D5100", cam_nikon_d5100_iso_500_14bits_lossless_nef, "raw_modes/NIKON D5100_ISO_500_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D5100", cam_nikon_d5100_iso_500_14bits_lossy__type_2__nef, "raw_modes/NIKON D5100_ISO_500_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D5100", cam_nikon_d5100_iso_500_14bits_uncompressed_nef, "raw_modes/NIKON D5100_ISO_500_14bits_Uncompressed.NEF");
}
mod camera_d60_raw_modes {
  super::camera_file_check!("Nikon", "D60", cam_nikon_d60_iso_100_12bits_lossy__type_1__nef, "raw_modes/NIKON D60_ISO_100_12bits_Lossy (type 1).NEF");
}
mod camera_d3200_raw_modes {
  super::camera_file_check!("Nikon", "D3200", cam_nikon_d3200_iso_800_12bits_lossy__type_2__nef, "raw_modes/NIKON D3200_ISO_800_12bits_Lossy (type 2).NEF");
}
mod camera_d750_raw_modes {
  super::camera_file_check!("Nikon", "D750", cam_nikon_d750_iso_100_14bits_lossless_nef, "raw_modes/NIKON D750_ISO_100_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D750", cam_nikon_d750_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON D750_ISO_100_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D750", cam_nikon_d750_iso_100_12bits_lossless_nef, "raw_modes/NIKON D750_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D750", cam_nikon_d750_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON D750_ISO_100_14bits_Lossy (type 2).NEF");
}
mod camera_d80_raw_modes {
  super::camera_file_check!("Nikon", "D80", cam_nikon_d80_iso_100_12bits_lossy__type_1__nef, "raw_modes/NIKON D80_ISO_100_12bits_Lossy (type 1).NEF");
}
mod camera_d3000_raw_modes {
  super::camera_file_check!("Nikon", "D3000", cam_nikon_d3000_iso_100_12bits_lossy__type_1__nef, "raw_modes/NIKON D3000_ISO_100_12bits_Lossy (type 1).NEF");
}
mod camera_d5300_raw_modes {
  super::camera_file_check!("Nikon", "D5300", cam_nikon_d5300_iso_160_14bits_lossy__type_2__nef, "raw_modes/NIKON D5300_ISO_160_14bits_Lossy (type 2).NEF");
}
mod camera_coolpix_p340_raw_modes {
  super::camera_file_check!("Nikon", "Coolpix P340", cam_coolpix_p340_iso_80_12bits_uncompressed_nrw, "raw_modes/COOLPIX P340_ISO_80_12bits_Uncompressed.NRW");
}
mod camera_1_j5_raw_modes {
  super::camera_file_check!("Nikon", "1 J5", cam_nikon_1_j5_iso_6400_12bits_lossy__type_2__nef, "raw_modes/NIKON 1 J5_ISO_6400_12bits_Lossy (type 2).NEF");
}
mod camera_d4s_raw_modes {
  super::camera_file_check!("Nikon", "D4S", cam_nikon_d4s_iso_360_12bits_small_nef, "raw_modes/NIKON D4S_ISO_360_12bits_Small.NEF");
  super::camera_file_check!("Nikon", "D4S", cam_nikon_d4s_iso_360_14bits_lossy__type_2__nef, "raw_modes/NIKON D4S_ISO_360_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D4S", cam_nikon_d4s_iso_280_14bits_uncompressed_nef, "raw_modes/NIKON D4S_ISO_280_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D4S", cam_nikon_d4s_iso_320_14bits_lossless_nef, "raw_modes/NIKON D4S_ISO_320_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D4S", cam_nikon_d4s_iso_280_12bits_lossy__type_2__nef, "raw_modes/NIKON D4S_ISO_280_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D4S", cam_nikon_d4s_iso_320_12bits_uncompressed__reduced_to_12_bit__nef, "raw_modes/NIKON D4S_ISO_320_12bits_Uncompressed (reduced to 12 bit).NEF");
  super::camera_file_check!("Nikon", "D4S", cam_nikon_d4s_iso_280_12bits_lossless_nef, "raw_modes/NIKON D4S_ISO_280_12bits_Lossless.NEF");
}
mod camera_d7200_raw_modes {
  super::camera_file_check!("Nikon", "D7200", cam_nikon_d7200_iso_1600_12bits_lossy__type_2__nef, "raw_modes/NIKON D7200_ISO_1600_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D7200", cam_nikon_d7200_iso_1600_14bits_lossless_nef, "raw_modes/NIKON D7200_ISO_1600_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D7200", cam_nikon_d7200_iso_1600_12bits_lossless_nef, "raw_modes/NIKON D7200_ISO_1600_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D7200", cam_nikon_d7200_iso_1600_14bits_lossy__type_2__nef, "raw_modes/NIKON D7200_ISO_1600_14bits_Lossy (type 2).NEF");
}
mod camera_d300_raw_modes {
  super::camera_file_check!("Nikon", "D300", cam_nikon_d300_iso_200_12bits_lossy__type_2__nef, "raw_modes/NIKON D300_ISO_200_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D300", cam_nikon_d300_iso_200_12bits_uncompressed_nef, "raw_modes/NIKON D300_ISO_200_12bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D300", cam_nikon_d300_iso_200_12bits_lossless_nef, "raw_modes/NIKON D300_ISO_200_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D300", cam_nikon_d300_iso_200_14bits_uncompressed_nef, "raw_modes/NIKON D300_ISO_200_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D300", cam_nikon_d300_iso_200_14bits_lossy__type_2__nef, "raw_modes/NIKON D300_ISO_200_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D300", cam_nikon_d300_iso_200_14bits_lossless_nef, "raw_modes/NIKON D300_ISO_200_14bits_Lossless.NEF");
}
mod camera_d1_raw_modes {
  super::camera_file_check!("Nikon", "D1", cam_nikon_d1_iso_200_12bits_uncompressed_nef, "raw_modes/NIKON D1_ISO_200_12bits_Uncompressed.NEF");
}
mod camera_d200_raw_modes {
  super::camera_file_check!("Nikon", "D200", cam_nikon_d200_iso_200_12bits_uncompressed_nef, "raw_modes/NIKON D200_ISO_200_12bits_Uncompressed.NEF");
}
mod camera_d1x_raw_modes {
  super::camera_file_check!("Nikon", "D1X", cam_nikon_d1x_iso_200_12bits_uncompressed_nef, "raw_modes/NIKON D1X_ISO_200_12bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D1X", cam_nikon_d1x_iso_125_12bits_lossy__type_1__nef, "raw_modes/NIKON D1X_ISO_125_12bits_Lossy (type 1).NEF");
}
mod camera_d70_raw_modes {
  super::camera_file_check!("Nikon", "D70", cam_nikon_d70_iso_200_12bits_lossy__type_1__nef, "raw_modes/NIKON D70_ISO_200_12bits_Lossy (type 1).NEF");
}
mod camera_coolpix_p330_raw_modes {
  super::camera_file_check!("Nikon", "Coolpix P330", cam_coolpix_p330_iso_80_12bits_uncompressed_nrw, "raw_modes/COOLPIX P330_ISO_80_12bits_Uncompressed.NRW");
}
mod camera_1_j2_raw_modes {
  super::camera_file_check!("Nikon", "1 J2", cam_nikon_1_j2_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON 1 J2_ISO_100_12bits_Lossy (type 2).NEF");
}
mod camera_d5200_raw_modes {
  super::camera_file_check!("Nikon", "D5200", cam_nikon_d5200_iso_280_14bits_lossy__type_2__nef, "raw_modes/NIKON D5200_ISO_280_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D5200", cam_nikon_d5200_iso_200_14bits_lossy__type_2__nef, "raw_modes/NIKON D5200_ISO_200_14bits_Lossy (type 2).NEF");
}
mod camera_d3s_raw_modes {
  super::camera_file_check!("Nikon", "D3S", cam_nikon_d3s_iso_200_12bits_lossless_nef, "raw_modes/NIKON D3S_ISO_200_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D3S", cam_nikon_d3s_iso_200_12bits_uncompressed_nef, "raw_modes/NIKON D3S_ISO_200_12bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D3S", cam_nikon_d3s_iso_200_14bits_uncompressed_nef, "raw_modes/NIKON D3S_ISO_200_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D3S", cam_nikon_d3s_iso_200_14bits_lossless_nef, "raw_modes/NIKON D3S_ISO_200_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D3S", cam_nikon_d3s_iso_200_12bits_lossy__type_2__nef, "raw_modes/NIKON D3S_ISO_200_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D3S", cam_nikon_d3s_iso_200_14bits_lossy__type_2__nef, "raw_modes/NIKON D3S_ISO_200_14bits_Lossy (type 2).NEF");
}
mod camera_df_raw_modes {
  super::camera_file_check!("Nikon", "Df", cam_nikon_df_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON Df_ISO_100_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "Df", cam_nikon_df_iso_100_12bits_uncompressed_nef, "raw_modes/NIKON Df_ISO_100_12bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "Df", cam_nikon_df_iso_100_14bits_uncompressed_nef, "raw_modes/NIKON Df_ISO_100_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "Df", cam_nikon_df_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON Df_ISO_100_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "Df", cam_nikon_df_iso_100_12bits_lossless_nef, "raw_modes/NIKON Df_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "Df", cam_nikon_df_iso_100_14bits_lossless_nef, "raw_modes/NIKON Df_ISO_100_14bits_Lossless.NEF");
}
mod camera_d800_raw_modes {
  super::camera_file_check!("Nikon", "D800", cam_nikon_d800_iso_50_14bits_uncompressed_nef, "raw_modes/NIKON D800_ISO_50_14bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D800", cam_nikon_d800_iso_50_12bits_lossy__type_2__nef, "raw_modes/NIKON D800_ISO_50_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "D800", cam_nikon_d800_iso_50_12bits_uncompressed_nef, "raw_modes/NIKON D800_ISO_50_12bits_Uncompressed.NEF");
  super::camera_file_check!("Nikon", "D800", cam_nikon_d800_iso_50_12bits_lossless_nef, "raw_modes/NIKON D800_ISO_50_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D800", cam_nikon_d800_iso_50_14bits_lossless_nef, "raw_modes/NIKON D800_ISO_50_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "D800", cam_nikon_d800_iso_50_14bits_lossy__type_2__nef, "raw_modes/NIKON D800_ISO_50_14bits_Lossy (type 2).NEF");
}
mod camera_d3100_raw_modes {
  super::camera_file_check!("Nikon", "D3100", cam_nikon_d3100_iso_220_12bits_lossy__type_2__nef, "raw_modes/NIKON D3100_ISO_220_12bits_Lossy (type 2).NEF");
}
mod camera_z_5_raw_modes {
  super::camera_file_check!("Nikon", "Z 5", cam_nikon_z_5_large_iso_400_12bits_lossless_nef, "raw_modes/NIKON Z 5_Large_ISO_400_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "Z 5", cam_nikon_z_5_large_iso_400_14bits_lossless_nef, "raw_modes/NIKON Z 5_Large_ISO_400_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "Z 5", cam_nikon_z_5_large_iso_360_12bits_lossy__type_2__nef, "raw_modes/NIKON Z 5_Large_ISO_360_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "Z 5", cam_nikon_z_5_large_iso_360_14bits_lossy__type_2__nef, "raw_modes/NIKON Z 5_Large_ISO_360_14bits_Lossy (type 2).NEF");
}
mod camera_nikon_z_6_2_raw_modes {
  super::camera_file_check!("Nikon", "NIKON Z 6_2", cam_nikon_z_6_2_large_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON Z 6_2_Large_ISO_100_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "NIKON Z 6_2", cam_nikon_z_6_2_large_iso_100_12bits_uncompressed__reduced_to_12_bit__nef, "raw_modes/NIKON Z 6_2_Large_ISO_100_12bits_Uncompressed (reduced to 12 bit).NEF");
  super::camera_file_check!("Nikon", "NIKON Z 6_2", cam_nikon_z_6_2_large_iso_100_12bits_lossless_nef, "raw_modes/NIKON Z 6_2_Large_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "NIKON Z 6_2", cam_nikon_z_6_2_large_iso_100_14bits_lossless_nef, "raw_modes/NIKON Z 6_2_Large_ISO_100_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "NIKON Z 6_2", cam_nikon_z_6_2_large_iso_100_14bits_packed_14_bits_nef, "raw_modes/NIKON Z 6_2_Large_ISO_100_14bits_Packed 14 bits.NEF");
  super::camera_file_check!("Nikon", "NIKON Z 6_2", cam_nikon_z_6_2_large_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON Z 6_2_Large_ISO_100_14bits_Lossy (type 2).NEF");
}
mod camera_nikon_z_7_2_raw_modes {
  super::camera_file_check!("Nikon", "NIKON Z 7_2", cam_nikon_z_7_2_large_iso_100_12bits_uncompressed__reduced_to_12_bit__nef, "raw_modes/NIKON Z 7_2_Large_ISO_100_12bits_Uncompressed (reduced to 12 bit).NEF");
  super::camera_file_check!("Nikon", "NIKON Z 7_2", cam_nikon_z_7_2_large_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON Z 7_2_Large_ISO_100_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "NIKON Z 7_2", cam_nikon_z_7_2_large_iso_100_14bits_packed_14_bits_nef, "raw_modes/NIKON Z 7_2_Large_ISO_100_14bits_Packed 14 bits.NEF");
  super::camera_file_check!("Nikon", "NIKON Z 7_2", cam_nikon_z_7_2_large_iso_100_14bits_lossless_nef, "raw_modes/NIKON Z 7_2_Large_ISO_100_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "NIKON Z 7_2", cam_nikon_z_7_2_large_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON Z 7_2_Large_ISO_100_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "NIKON Z 7_2", cam_nikon_z_7_2_large_iso_100_12bits_lossless_nef, "raw_modes/NIKON Z 7_2_Large_ISO_100_12bits_Lossless.NEF");
}
mod camera_z_30_raw_modes {
  super::camera_file_check!("Nikon", "Z 30", cam_nikon_z30_lossless_12bit_nef, "raw_modes/Nikon_Z30_Lossless_12bit.NEF");
  super::camera_file_check!("Nikon", "Z 30", cam_nikon_z30_lossless_14bit_nef, "raw_modes/Nikon_Z30_Lossless_14bit.NEF");
}
mod camera_z_50_raw_modes {
  super::camera_file_check!("Nikon", "Z 50", cam_nikon_z_50_large_iso_250_14bits_lossless_nef, "raw_modes/NIKON Z 50_Large_ISO_250_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "Z 50", cam_nikon_z_50_large_iso_250_12bits_lossless_nef, "raw_modes/NIKON Z 50_Large_ISO_250_12bits_Lossless.NEF");
}
mod camera_z_50_ii_raw_modes {
  super::camera_file_check!("Nikon", "Z 50 II", cam_z50ii_dx_lossless_nef, "raw_modes/Z50II_DX_lossless.NEF");
  super::camera_file_check!("Nikon", "Z 50 II", cam_z50ii_1x1_lossless_nef, "raw_modes/Z50II_1x1_lossless.NEF");
  super::camera_file_check!("Nikon", "Z 50 II", cam_z50ii_16x9_lossless_nef, "raw_modes/Z50II_16x9_lossless.NEF");
}
mod camera_z_6_raw_modes {
  super::camera_file_check!("Nikon", "Z 6", cam_nikon_z_6_large_iso_100_12bits_lossy__type_2__nef, "raw_modes/NIKON Z 6_Large_ISO_100_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "Z 6", cam_nikon_z_6_small_iso_100_12bits_lossless_nef, "raw_modes/NIKON Z 6_Small_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "Z 6", cam_nikon_z_6_large_iso_100_14bits_packed_14_bits_nef, "raw_modes/NIKON Z 6_Large_ISO_100_14bits_Packed 14 bits.NEF");
  super::camera_file_check!("Nikon", "Z 6", cam_nikon_z_6_large_iso_100_14bits_lossless_nef, "raw_modes/NIKON Z 6_Large_ISO_100_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "Z 6", cam_nikon_z_6_large_iso_100_12bits_uncompressed__reduced_to_12_bit__nef, "raw_modes/NIKON Z 6_Large_ISO_100_12bits_Uncompressed (reduced to 12 bit).NEF");
  super::camera_file_check!("Nikon", "Z 6", cam_nikon_z_6_large_iso_100_14bits_lossy__type_2__nef, "raw_modes/NIKON Z 6_Large_ISO_100_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "Z 6", cam_nikon_z_6_medium_iso_100_12bits_lossless_nef, "raw_modes/NIKON Z 6_Medium_ISO_100_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "Z 6", cam_nikon_z_6_large_iso_100_12bits_lossless_nef, "raw_modes/NIKON Z 6_Large_ISO_100_12bits_Lossless.NEF");
}
mod camera_nikon_z_f_raw_modes {
  super::camera_file_check!("Nikon", "NIKON Z f", cam_nikon_z_f_iso_160_14bits_lossless_nrw, "raw_modes/NIKON Z f_ISO_160_14bits_Lossless.NRW");
}
mod camera_nikon_z_fc_raw_modes {
  super::camera_file_check!("Nikon", "NIKON Z fc", cam_nikon_z_fc_large_iso_200_14bits_lossless_nef, "raw_modes/NIKON Z fc_Large_ISO_200_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "NIKON Z fc", cam_nikon_z_fc_large_iso_400_12bits_lossless_nef, "raw_modes/NIKON Z fc_Large_ISO_400_12bits_Lossless.NEF");
}
mod camera_z_7_raw_modes {
  super::camera_file_check!("Nikon", "Z 7", cam_nikon_z_7_large_iso_64_12bits_lossy__type_2__nef, "raw_modes/NIKON Z 7_Large_ISO_64_12bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "Z 7", cam_nikon_z_7_large_iso_64_14bits_lossless_nef, "raw_modes/NIKON Z 7_Large_ISO_64_14bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "Z 7", cam_nikon_z_7_small_iso_64_12bits_lossless_nef, "raw_modes/NIKON Z 7_Small_ISO_64_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "Z 7", cam_nikon_z_7_large_iso_64_12bits_lossless_nef, "raw_modes/NIKON Z 7_Large_ISO_64_12bits_Lossless.NEF");
  super::camera_file_check!("Nikon", "Z 7", cam_nikon_z_7_large_iso_64_14bits_packed_14_bits_nef, "raw_modes/NIKON Z 7_Large_ISO_64_14bits_Packed 14 bits.NEF");
  super::camera_file_check!("Nikon", "Z 7", cam_nikon_z_7_large_iso_64_14bits_lossy__type_2__nef, "raw_modes/NIKON Z 7_Large_ISO_64_14bits_Lossy (type 2).NEF");
  super::camera_file_check!("Nikon", "Z 7", cam_nikon_z_7_large_iso_64_12bits_uncompressed__reduced_to_12_bit__nef, "raw_modes/NIKON Z 7_Large_ISO_64_12bits_Uncompressed (reduced to 12 bit).NEF");
  super::camera_file_check!("Nikon", "Z 7", cam_nikon_z_7_medium_iso_64_12bits_lossless_nef, "raw_modes/NIKON Z 7_Medium_ISO_64_12bits_Lossless.NEF");
}
mod camera_nikon_z_9_raw_modes {
  super::camera_file_check!("Nikon", "NIKON Z 9", cam_nikon_z_9_large_iso_64_14bits_lossless_nef, "raw_modes/NIKON Z 9_Large_ISO_64_14bits_Lossless.NEF");
}
mod camera_nikon_z_8_raw_modes {
  super::camera_file_check!("Nikon", "NIKON Z 8", cam_nikon_z8_raw_14_bit_lossless_compression_nef, "raw_modes/Nikon_Z8_raw_14_bit_lossless_compression.NEF");
}
mod camera_dsc_f828_raw_modes {
  super::camera_file_check!("Sony", "DSC-F828", cam_dsc_f828_iso_64_14_14_14bits_uncompressed_srf, "raw_modes/DSC-F828_ISO_64_14 14 14bits_Uncompressed.SRF");
}
mod camera_dsc_hx95_raw_modes {
  super::camera_file_check!("Sony", "DSC-HX95", cam_dsc_hx95_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/DSC-HX95_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_hx99_raw_modes {
  super::camera_file_check!("Sony", "DSC-HX99", cam_dsc_hx99_iso_80_12bits_sony_arw_compressed_arw, "raw_modes/DSC-HX99_ISO_80_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_r1_raw_modes {
  super::camera_file_check!("Sony", "DSC-R1", cam_dsc_r1_iso_160_14bits_uncompressed_sr2, "raw_modes/DSC-R1_ISO_160_14bits_Uncompressed.SR2");
}
mod camera_dsc_rx0m2_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX0M2", cam_dsc_rx0m2_iso_400_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX0M2_ISO_400_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx0_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX0", cam_dsc_rx0_iso_125_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX0_ISO_125_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx100m2_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX100M2", cam_dsc_rx100m2_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX100M2_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx100m3_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX100M3", cam_dsc_rx100m3_iso_125_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX100M3_ISO_125_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx100m4_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX100M4", cam_dsc_rx100m4_iso_125_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX100M4_ISO_125_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx100m5a_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX100M5A", cam_dsc_rx100m5a_iso_125_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX100M5A_ISO_125_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx100m5_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX100M5", cam_dsc_rx100m5_iso_125_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX100M5_ISO_125_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx100m6_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX100M6", cam_dsc_rx100m6_iso_125_12bits_compressed_raw_arw, "raw_modes/DSC-RX100M6_ISO_125_12bits_Compressed RAW.ARW");
}
mod camera_dsc_rx100m7_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX100M7", cam_dsc_rx100m7_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX100M7_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx100_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX100", cam_dsc_rx100_iso_640_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX100_ISO_640_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx10m2_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX10M2", cam_dsc_rx10m2_iso_1250_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX10M2_ISO_1250_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx10m3_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX10M3", cam_dsc_rx10m3_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX10M3_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx10m4_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX10M4", cam_dsc_rx10m4_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX10M4_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx10_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX10", cam_dsc_rx10_iso_320_12bits_sony_arw_compressed_arw, "raw_modes/DSC-RX10_ISO_320_12bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx1_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX1", cam_dsc_rx1_iso_100_14bits_sony_arw_compressed_arw, "raw_modes/DSC-RX1_ISO_100_14bits_Sony ARW Compressed.ARW");
}
mod camera_dsc_rx1rm2_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX1RM2", cam_dsc_rx1rm2_iso_100_14bits_compressed_raw_arw, "raw_modes/DSC-RX1RM2_ISO_100_14bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "DSC-RX1RM2", cam_dsc_rx1rm2_iso_100_14bits_uncompressed_raw_arw, "raw_modes/DSC-RX1RM2_ISO_100_14bits_Uncompressed RAW.ARW");
}
mod camera_dsc_rx1r_raw_modes {
  super::camera_file_check!("Sony", "DSC-RX1R", cam_dsc_rx1r_iso_6400_14bits_sony_arw_compressed_arw, "raw_modes/DSC-RX1R_ISO_6400_14bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a100_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A100", cam_dslr_a100_iso_100_arw, "raw_modes/DSLR-A100_ISO_100.ARW");
}
mod camera_dslr_a200_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A200", cam_dslr_a200_iso_800_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A200_ISO_800_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a230_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A230", cam_dslr_a230_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A230_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a290_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A290", cam_dslr_a290_iso_400_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A290_ISO_400_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a300_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A300", cam_dslr_a300_iso_400_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A300_ISO_400_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a330_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A330", cam_dslr_a330_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A330_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a350_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A350", cam_dslr_a350_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A350_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a380_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A380", cam_dslr_a380_iso_400_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A380_ISO_400_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a390_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A390", cam_dslr_a390_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A390_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a450_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A450", cam_dslr_a450_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A450_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a500_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A500", cam_dslr_a500_iso_500_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A500_ISO_500_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a550_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A550", cam_dslr_a550_iso_3200_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A550_ISO_3200_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a560_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A560", cam_dslr_a560_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A560_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a580_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A580", cam_dslr_a580_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A580_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a700_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A700", cam_dslr_a700_iso_200_8bits_sony_arw_compressed_arw, "raw_modes/DSLR-A700_ISO_200_8bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a850_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A850", cam_dslr_a850_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A850_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_dslr_a900_raw_modes {
  super::camera_file_check!("Sony", "DSLR-A900", cam_dslr_a900_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/DSLR-A900_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilca_68_raw_modes {
  super::camera_file_check!("Sony", "ILCA-68", cam_ilca_68_iso_250_12bits_sony_arw_compressed_arw, "raw_modes/ILCA-68_ISO_250_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilca_77m2_raw_modes {
  super::camera_file_check!("Sony", "ILCA-77M2", cam_ilca_77m2_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/ILCA-77M2_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilca_99m2_raw_modes {
  super::camera_file_check!("Sony", "ILCA-99M2", cam_ilca_99m2_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/ILCA-99M2_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilme_fx30_raw_modes {
  super::camera_file_check!("Sony", "ILME-FX30", cam_ilme_fx30_iso_125_arw, "raw_modes/ILME-FX30_ISO_125.ARW");
}
mod camera_ilme_fx3_raw_modes {
  super::camera_file_check!("Sony", "ILME-FX3", cam_ilme_fx3_iso_20000_14bits_arw, "raw_modes/ILME-FX3_ISO_20000_14bits.ARW");
}
mod camera_ilce_1_raw_modes {
  super::camera_file_check!("Sony", "ILCE-1", cam_ilce_1_iso_500_14bits_uncompressed_raw_arw, "raw_modes/ILCE-1_ISO_500_14bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-1", cam_ilce_1_iso_500_14bits_lossless_compressed_raw_arw, "raw_modes/ILCE-1_ISO_500_14bits_Lossless Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-1", cam_ilce_1_iso_500_14bits_compressed_raw_arw, "raw_modes/ILCE-1_ISO_500_14bits_Compressed RAW.ARW");
}
mod camera_ilce_3000_raw_modes {
  super::camera_file_check!("Sony", "ILCE-3000", cam_ilce_3000_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/ILCE-3000_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_3500_raw_modes {
  super::camera_file_check!("Sony", "ILCE-3500", cam_ilce_3500_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/ILCE-3500_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_5000_raw_modes {
  super::camera_file_check!("Sony", "ILCE-5000", cam_ilce_5000_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/ILCE-5000_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_5100_raw_modes {
  super::camera_file_check!("Sony", "ILCE-5100", cam_ilce_5100_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/ILCE-5100_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_6000_raw_modes {
  super::camera_file_check!("Sony", "ILCE-6000", cam_ilce_6000_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/ILCE-6000_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_6001_raw_modes {
  super::camera_file_check!("Sony", "ILCE-6001", cam_ilce_6001_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/ILCE-6001_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_6100_raw_modes {
  super::camera_file_check!("Sony", "ILCE-6100", cam_ilce_6100_iso_100_14bits_sony_arw_compressed_arw, "raw_modes/ILCE-6100_ISO_100_14bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_6300_raw_modes {
  super::camera_file_check!("Sony", "ILCE-6300", cam_ilce_6300_iso_100_14bits_sony_arw_compressed_arw, "raw_modes/ILCE-6300_ISO_100_14bits_Sony ARW Compressed.ARW");
  super::camera_file_check!("Sony", "ILCE-6300", cam_ilce_6300_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/ILCE-6300_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_6400_raw_modes {
  super::camera_file_check!("Sony", "ILCE-6400", cam_ilce_6400_iso_250_12bits_compressed_raw_arw, "raw_modes/ILCE-6400_ISO_250_12bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-6400", cam_ilce_6400_iso_160_14bits_compressed_raw_arw, "raw_modes/ILCE-6400_ISO_160_14bits_Compressed RAW.ARW");
}
mod camera_ilce_6500_raw_modes {
  super::camera_file_check!("Sony", "ILCE-6500", cam_ilce_6500_iso_100_14bits_compressed_raw_arw, "raw_modes/ILCE-6500_ISO_100_14bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-6500", cam_ilce_6500_iso_100_12bits_compressed_raw_arw, "raw_modes/ILCE-6500_ISO_100_12bits_Compressed RAW.ARW");
}
mod camera_ilce_6600_raw_modes {
  super::camera_file_check!("Sony", "ILCE-6600", cam_ilce_6600_iso_100_14bits_sony_arw_compressed_arw, "raw_modes/ILCE-6600_ISO_100_14bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_6700_raw_modes {
  super::camera_file_check!("Sony", "ILCE-6700", cam_ilce_6700_iso_100_14bits_compressed_arw, "raw_modes/ILCE-6700_ISO_100_14bits_Compressed.ARW");
  super::camera_file_check!("Sony", "ILCE-6700", cam_ilce_6700_iso_100_14bits_lossless_compressed_arw, "raw_modes/ILCE-6700_ISO_100_14bits_Lossless_Compressed.ARW");
  super::camera_file_check!("Sony", "ILCE-6700", cam_ilce_6700_iso_100_12bits_compressed_arw, "raw_modes/ILCE-6700_ISO_100_12bits_Compressed.ARW");
}
mod camera_ilce_7cr_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7CR", cam_ilce_7cr_apsc_s_iso_125_15bits_jpeg_arw, "raw_modes/ILCE-7CR_APSC_S_ISO_125_15bits_JPEG.ARW");
  super::camera_file_check!("Sony", "ILCE-7CR", cam_ilce_7cr_fullframe_m_iso_125_15bits_jpeg_arw, "raw_modes/ILCE-7CR_Fullframe_M_ISO_125_15bits_JPEG.ARW");
  super::camera_file_check!("Sony", "ILCE-7CR", cam_ilce_7cr_fullframe_iso_125_14bits_uncompressed_arw, "raw_modes/ILCE-7CR_Fullframe_ISO_125_14bits_Uncompressed.ARW");
  super::camera_file_check!("Sony", "ILCE-7CR", cam_ilce_7cr_apsc_iso_125_14bits_sony_arw_compressed_arw, "raw_modes/ILCE-7CR_APSC_ISO_125_14bits_Sony ARW Compressed.ARW");
  super::camera_file_check!("Sony", "ILCE-7CR", cam_ilce_7cr_apsc_iso_125_14bits_uncompressed_arw, "raw_modes/ILCE-7CR_APSC_ISO_125_14bits_Uncompressed.ARW");
  super::camera_file_check!("Sony", "ILCE-7CR", cam_ilce_7cr_fullframe_l_iso_125_14bits_jpeg_arw, "raw_modes/ILCE-7CR_Fullframe_L_ISO_125_14bits_JPEG.ARW");
  super::camera_file_check!("Sony", "ILCE-7CR", cam_ilce_7cr_apsc_m_iso_125_14bits_jpeg_arw, "raw_modes/ILCE-7CR_APSC_M_ISO_125_14bits_JPEG.ARW");
  super::camera_file_check!("Sony", "ILCE-7CR", cam_ilce_7cr_fullframe_iso_125_14bits_sony_arw_compressed_arw, "raw_modes/ILCE-7CR_Fullframe_ISO_125_14bits_Sony ARW Compressed.ARW");
  super::camera_file_check!("Sony", "ILCE-7CR", cam_ilce_7cr_fullframe_s_iso_125_15bits_jpeg_arw, "raw_modes/ILCE-7CR_Fullframe_S_ISO_125_15bits_JPEG.ARW");
}
mod camera_ilce_7c_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7C", cam_ilce_7c_iso_12800_14bits_uncompressed_raw_arw, "raw_modes/ILCE-7C_ISO_12800_14bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7C", cam_ilce_7c_iso_2000_14bits_compressed_raw_arw, "raw_modes/ILCE-7C_ISO_2000_14bits_Compressed RAW.ARW");
}
mod camera_ilce_7cm2_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7CM2", cam_ilce_7cm2_iso_100_14bits_jpeg_arw, "raw_modes/ILCE-7CM2_ISO_100_14bits_JPEG.ARW");
  super::camera_file_check!("Sony", "ILCE-7CM2", cam_ilce_7cm2_iso_100_14bits_uncompressed_arw, "raw_modes/ILCE-7CM2_ISO_100_14bits_Uncompressed.ARW");
  super::camera_file_check!("Sony", "ILCE-7CM2", cam_ilce_7cm2_iso_100_14bits_sony_arw_compressed_arw, "raw_modes/ILCE-7CM2_ISO_100_14bits_Sony ARW Compressed.ARW");
  super::camera_file_check!("Sony", "ILCE-7CM2", cam_ilce_7cm2_iso_100_14bits_uncompressed_raw_arw, "raw_modes/ILCE-7CM2_ISO_100_14bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7CM2", cam_ilce_7cm2_iso_100_14bits_compressed_raw_arw, "raw_modes/ILCE-7CM2_ISO_100_14bits_Compressed RAW.ARW");
}
mod camera_ilce_7m2_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7M2", cam_ilce_7m2_iso_100_14bits_uncompressed_arw, "raw_modes/ILCE-7M2_ISO_100_14bits_Uncompressed.ARW");
  super::camera_file_check!("Sony", "ILCE-7M2", cam_ilce_7m2_iso_100_14bits_sony_arw_compressed_arw, "raw_modes/ILCE-7M2_ISO_100_14bits_Sony ARW Compressed.ARW");
  super::camera_file_check!("Sony", "ILCE-7M2", cam_ilce_7m2_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/ILCE-7M2_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_7m3_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7M3", cam_ilce_7m3_iso_400_12bits_compressed_raw_arw, "raw_modes/ILCE-7M3_ISO_400_12bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7M3", cam_ilce_7m3_iso_400_14bits_uncompressed_raw_arw, "raw_modes/ILCE-7M3_ISO_400_14bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7M3", cam_ilce_7m3_iso_400_14bits_compressed_raw_arw, "raw_modes/ILCE-7M3_ISO_400_14bits_Compressed RAW.ARW");
}
mod camera_ilce_7m4_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_iso_100_14bits_compressed_raw_arw, "raw_modes/ILCE-7M4_ISO_100_14bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_iso_100_12bits_compressed_raw_arw, "raw_modes/ILCE-7M4_ISO_100_12bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_iso_100_14bits_lossless_compressed_raw_arw, "raw_modes/ILCE-7M4_ISO_100_14bits_Lossless Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_iso_100_14bits_uncompressed_raw_arw, "raw_modes/ILCE-7M4_ISO_100_14bits_Uncompressed RAW.ARW");
}
mod camera_ilce_7m4_resolutions {
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_dsc06680_aps_c_lossless_small_arw, "resolutions/ILCE-7M4_DSC06680_APS-C-LossLess-Small.ARW");
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_dsc06674_fullframe_lossless_compressed_large_arw, "resolutions/ILCE-7M4_DSC06674_FullFrame-LossLess-Compressed-Large.ARW");
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_dsc06681_aps_c_raw_compressed_arw, "resolutions/ILCE-7M4_DSC06681_APS-C-Raw-Compressed.ARW");
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_dsc06678_aps_c_raw_uncompressed_arw, "resolutions/ILCE-7M4_DSC06678_APS-C-Raw-Uncompressed.ARW");
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_dsc06677_fullframe_raw_compressed_arw, "resolutions/ILCE-7M4_DSC06677_FullFrame-Raw-Compressed.ARW");
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_dsc06679_aps_c_lossless_medium_arw, "resolutions/ILCE-7M4_DSC06679_APS-C-LossLess-Medium.ARW");
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_dsc06675_fullframe_lossless_compressed_medium_arw, "resolutions/ILCE-7M4_DSC06675_FullFrame-LossLess-Compressed-Medium.ARW");
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_dsc06676_fullframe_lossless_compressed_small_arw, "resolutions/ILCE-7M4_DSC06676_FullFrame-LossLess-Compressed-Small.ARW");
  super::camera_file_check!("Sony", "ILCE-7M4", cam_ilce_7m4_dsc06673_fullframe_raw_uncompressed_arw, "resolutions/ILCE-7M4_DSC06673_FullFrame-Raw-Uncompressed.ARW");
}
mod camera_ilce_7_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7", cam_ilce_7_iso_200_14bits_sony_arw_compressed_arw, "raw_modes/ILCE-7_ISO_200_14bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_7rm2_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7RM2", cam_ilce_7rm2_iso_100_12bits_compressed_raw_arw, "raw_modes/ILCE-7RM2_ISO_100_12bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM2", cam_ilce_7rm2_iso_100_12bits_uncompressed_raw_arw, "raw_modes/ILCE-7RM2_ISO_100_12bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM2", cam_ilce_7rm2_iso_100_14bits_uncompressed_raw_arw, "raw_modes/ILCE-7RM2_ISO_100_14bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM2", cam_ilce_7rm2_iso_100_14bits_compressed_raw_arw, "raw_modes/ILCE-7RM2_ISO_100_14bits_Compressed RAW.ARW");
}
mod camera_ilce_7rm3a_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7RM3A", cam_ilce_7rm3a_iso_200_14bits_uncompressed_raw_arw, "raw_modes/ILCE-7RM3A_ISO_200_14bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM3A", cam_ilce_7rm3a_iso_500_14bits_compressed_raw_arw, "raw_modes/ILCE-7RM3A_ISO_500_14bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM3A", cam_ilce_7rm3a_iso_250_14bits_compressed_raw_arw, "raw_modes/ILCE-7RM3A_ISO_250_14bits_Compressed RAW.ARW");
}
mod camera_ilce_7rm3_raw_modes {}
mod camera_ilce_7rm4a_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7RM4A", cam_ilce_7rm4a_iso_250_14bits_uncompressed_raw_arw, "raw_modes/ILCE-7RM4A_ISO_250_14bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM4A", cam_ilce_7rm4a_iso_125_14bits_compressed_raw_arw, "raw_modes/ILCE-7RM4A_ISO_125_14bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM4A", cam_ilce_7rm4a_iso_1250_12bits_uncompressed_raw_arw, "raw_modes/ILCE-7RM4A_ISO_1250_12bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM4A", cam_ilce_7rm4a_iso_160_12bits_compressed_raw_arw, "raw_modes/ILCE-7RM4A_ISO_160_12bits_Compressed RAW.ARW");
}
mod camera_ilce_7rm4_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7RM4", cam_ilce_7rm4_iso_50_14bits_uncompressed_raw_arw, "raw_modes/ILCE-7RM4_ISO_50_14bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM4", cam_ilce_7rm4_iso_50_12bits_uncompressed_raw_arw, "raw_modes/ILCE-7RM4_ISO_50_12bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM4", cam_ilce_7rm4_iso_50_14bits_compressed_raw_arw, "raw_modes/ILCE-7RM4_ISO_50_14bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM4", cam_ilce_7rm4_iso_50_12bits_compressed_raw_arw, "raw_modes/ILCE-7RM4_ISO_50_12bits_Compressed RAW.ARW");
}
mod camera_ilce_7rm5_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7RM5", cam_sony_7rm5_lossless_l_ljpeg_arw, "raw_modes/Sony_7RM5_Lossless_L_LJPEG.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM5", cam_sony_7rm5_uncompressed_arw, "raw_modes/Sony_7RM5_Uncompressed.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM5", cam_sony_7rm5_lossy_arw, "raw_modes/Sony_7RM5_Lossy.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM5", cam_sony_7rm5_s35_lossy_arw, "raw_modes/Sony_7RM5_S35_Lossy.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM5", cam_sony_7rm5_s35_uncompressed_arw, "raw_modes/Sony_7RM5_S35_Uncompressed.ARW");
}
mod camera_ilce_7rm5_yuv {
  super::camera_file_check!("Sony", "ILCE-7RM5", cam_sony_7rm5_lossless_s_ljpeg_arw, "yuv/Sony_7RM5_Lossless_S_LJPEG.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM5", cam_sony_7rm5_s35_lossless_m_ljpeg_arw, "yuv/Sony_7RM5_S35_Lossless_M_LJPEG.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM5", cam_sony_7rm5_s35_lossless_s_ljpeg_arw, "yuv/Sony_7RM5_S35_Lossless_S_LJPEG.ARW");
  super::camera_file_check!("Sony", "ILCE-7RM5", cam_sony_7rm5_lossless_m_ljpeg_arw, "yuv/Sony_7RM5_Lossless_M_LJPEG.ARW");
}
mod camera_ilce_7r_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7R", cam_ilce_7r_iso_50_14bits_sony_arw_compressed_arw, "raw_modes/ILCE-7R_ISO_50_14bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_7sm2_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7SM2", cam_ilce_7sm2_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/ILCE-7SM2_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_7sm3_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7SM3", cam_ilce_7sm3_iso_80_14bits_uncompressed_raw_arw, "raw_modes/ILCE-7SM3_ISO_80_14bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7SM3", cam_ilce_7sm3_iso_2500_14bits_compressed_raw_arw, "raw_modes/ILCE-7SM3_ISO_2500_14bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-7SM3", cam_ilce_7sm3_iso_80_14bits_compressed_raw_arw, "raw_modes/ILCE-7SM3_ISO_80_14bits_Compressed RAW.ARW");
}
mod camera_ilce_7s_raw_modes {
  super::camera_file_check!("Sony", "ILCE-7S", cam_ilce_7s_iso_400_14bits_sony_arw_compressed_arw, "raw_modes/ILCE-7S_ISO_400_14bits_Sony ARW Compressed.ARW");
}
mod camera_ilce_9m2_raw_modes {
  super::camera_file_check!("Sony", "ILCE-9M2", cam_ilce_9m2_iso_640_14bits_compressed_raw_arw, "raw_modes/ILCE-9M2_ISO_640_14bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-9M2", cam_ilce_9m2_iso_800_14bits_uncompressed_raw_arw, "raw_modes/ILCE-9M2_ISO_800_14bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-9M2", cam_ilce_9m2_iso_640_12bits_compressed_raw_arw, "raw_modes/ILCE-9M2_ISO_640_12bits_Compressed RAW.ARW");
}
mod camera_ilce_9m3_raw_modes {
  super::camera_file_check!("Sony", "ILCE-9M3", cam_sony_ilce_9m3_14bits_lossless_m_arw, "raw_modes/Sony_ILCE_9M3_14bits_lossless_M.ARW");
  super::camera_file_check!("Sony", "ILCE-9M3", cam_sony_ilce_9m3_14bits_apsc_14bits_lossy_arw, "raw_modes/Sony_ILCE_9M3_14bits_APSC_14bits_lossy.ARW");
  super::camera_file_check!("Sony", "ILCE-9M3", cam_sony_ilce_9m3_14bits_uncompressed_arw, "raw_modes/Sony_ILCE_9M3_14bits_uncompressed.ARW");
  super::camera_file_check!("Sony", "ILCE-9M3", cam_sony_ilce_9m3_14bits_lossless_l_arw, "raw_modes/Sony_ILCE_9M3_14bits_lossless_L.ARW");
  super::camera_file_check!("Sony", "ILCE-9M3", cam_sony_ilce_9m3_14bits_apsc_14bits_lossless_m_arw, "raw_modes/Sony_ILCE_9M3_14bits_APSC_14bits_lossless_M.ARW");
  super::camera_file_check!("Sony", "ILCE-9M3", cam_sony_ilce_9m3_14bits_lossless_s_arw, "raw_modes/Sony_ILCE_9M3_14bits_lossless_S.ARW");
  super::camera_file_check!("Sony", "ILCE-9M3", cam_sony_ilce_9m3_14bits_lossy_arw, "raw_modes/Sony_ILCE_9M3_14bits_lossy.ARW");
  super::camera_file_check!("Sony", "ILCE-9M3", cam_sony_ilce_9m3_14bits_apsc_14bits_lossless_s_arw, "raw_modes/Sony_ILCE_9M3_14bits_APSC_14bits_lossless_S.ARW");
  super::camera_file_check!("Sony", "ILCE-9M3", cam_sony_ilce_9m3_14bits_apsc_14bits_uncompressed_arw, "raw_modes/Sony_ILCE_9M3_14bits_APSC_14bits_uncompressed.ARW");
}
mod camera_ilce_9_raw_modes {
  super::camera_file_check!("Sony", "ILCE-9", cam_ilce_9_iso_100_14bits_uncompressed_raw_arw, "raw_modes/ILCE-9_ISO_100_14bits_Uncompressed RAW.ARW");
  super::camera_file_check!("Sony", "ILCE-9", cam_ilce_9_iso_100_14bits_compressed_raw_arw, "raw_modes/ILCE-9_ISO_100_14bits_Compressed RAW.ARW");
}
mod camera_ilce_qx1_raw_modes {
  super::camera_file_check!("Sony", "ILCE-QX1", cam_ilce_qx1_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/ILCE-QX1_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_nex_3n_raw_modes {
  super::camera_file_check!("Sony", "NEX-3N", cam_nex_3n_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/NEX-3N_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_nex_3_raw_modes {
  super::camera_file_check!("Sony", "NEX-3", cam_nex_3_iso_1600_12bits_sony_arw_compressed_arw, "raw_modes/NEX-3_ISO_1600_12bits_Sony ARW Compressed.ARW");
}
mod camera_nex_5n_raw_modes {
  super::camera_file_check!("Sony", "NEX-5N", cam_nex_5n_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/NEX-5N_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_nex_5_raw_modes {
  super::camera_file_check!("Sony", "NEX-5", cam_nex_5_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/NEX-5_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_nex_5r_raw_modes {
  super::camera_file_check!("Sony", "NEX-5R", cam_nex_5r_iso_1600_12bits_sony_arw_compressed_arw, "raw_modes/NEX-5R_ISO_1600_12bits_Sony ARW Compressed.ARW");
}
mod camera_nex_5t_raw_modes {
  super::camera_file_check!("Sony", "NEX-5T", cam_nex_5t_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/NEX-5T_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_nex_6_raw_modes {
  super::camera_file_check!("Sony", "NEX-6", cam_nex_6_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/NEX-6_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_nex_7_raw_modes {
  super::camera_file_check!("Sony", "NEX-7", cam_nex_7_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/NEX-7_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_nex_c3_raw_modes {
  super::camera_file_check!("Sony", "NEX-C3", cam_nex_c3_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/NEX-C3_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_nex_f3_raw_modes {
  super::camera_file_check!("Sony", "NEX-F3", cam_nex_f3_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/NEX-F3_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_slt_a33_raw_modes {
  super::camera_file_check!("Sony", "SLT-A33", cam_slt_a33_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/SLT-A33_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_slt_a35_raw_modes {
  super::camera_file_check!("Sony", "SLT-A35", cam_slt_a35_iso_400_12bits_sony_arw_compressed_arw, "raw_modes/SLT-A35_ISO_400_12bits_Sony ARW Compressed.ARW");
}
mod camera_slt_a37_raw_modes {
  super::camera_file_check!("Sony", "SLT-A37", cam_slt_a37_iso_800_12bits_sony_arw_compressed_arw, "raw_modes/SLT-A37_ISO_800_12bits_Sony ARW Compressed.ARW");
}
mod camera_slt_a55_raw_modes {
  super::camera_file_check!("Sony", "SLT-A55", cam_slt_a55v_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/SLT-A55V_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_slt_a57_raw_modes {
  super::camera_file_check!("Sony", "SLT-A57", cam_slt_a57_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/SLT-A57_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_slt_a58_raw_modes {
  super::camera_file_check!("Sony", "SLT-A58", cam_slt_a58_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/SLT-A58_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_slt_a65_raw_modes {
  super::camera_file_check!("Sony", "SLT-A65", cam_slt_a65v_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/SLT-A65V_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_slt_a77_raw_modes {
  super::camera_file_check!("Sony", "SLT-A77", cam_slt_a77v_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/SLT-A77V_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_slt_a99_raw_modes {
  super::camera_file_check!("Sony", "SLT-A99", cam_slt_a99v_iso_100_12bits_sony_arw_compressed_arw, "raw_modes/SLT-A99V_ISO_100_12bits_Sony ARW Compressed.ARW");
}
mod camera_zv_1_raw_modes {
  super::camera_file_check!("Sony", "ZV-1", cam_zv_1_iso_125_12bits_sony_arw_compressed_arw, "raw_modes/ZV-1_ISO_125_12bits_Sony ARW Compressed.ARW");
}
mod camera_zv_e1_raw_modes {
  super::camera_file_check!("Sony", "ZV-E1", cam_zv_e1_iso_200_14bits_arw, "raw_modes/ZV-E1_ISO_200_14bits.ARW");
}
mod camera_zv_e10_raw_modes {
  super::camera_file_check!("Sony", "ZV-E10", cam_zv_e10_iso_400_14bits_sony_arw_compressed_arw, "raw_modes/ZV-E10_ISO_400_14bits_Sony ARW Compressed.ARW");
}
mod camera_zv_e10m2_raw_modes {
  super::camera_file_check!("Sony", "ZV-E10M2", cam_zv_e10m2_iso_400_12bits_compressed_raw_arw, "raw_modes/ZV-E10M2_ISO_400_12bits_Compressed RAW.ARW");
  super::camera_file_check!("Sony", "ZV-E10M2", cam_zv_e10m2_iso_400_12bits_lossless_compressed_raw_arw, "raw_modes/ZV-E10M2_ISO_400_12bits_Lossless Compressed RAW.ARW");
}
mod camera_umc_r10c_raw_modes {
  super::camera_file_check!("Sony", "UMC-R10C", cam_umc_r10c_iso_200_12bits_sony_arw_compressed_arw, "raw_modes/UMC-R10C_ISO_200_12bits_Sony ARW Compressed.ARW");
}
mod camera_r_d1_raw_modes {
  super::camera_file_check!("Epson", "R-D1", cam_r_d1_iso_400_12bits_erf, "raw_modes/R-D1_ISO_400_12bits.ERF");
}
mod camera_r_d1s_raw_modes {
  super::camera_file_check!("Epson", "R-D1s", cam_r_d1s_iso_200_12bits_erf, "raw_modes/R-D1s_ISO_200_12bits.ERF");
}
mod camera_r_d1x_raw_modes {
  super::camera_file_check!("Epson", "R-D1x", cam_r_d1x_iso_200_12bits_erf, "raw_modes/R-D1x_ISO_200_12bits.ERF");
}
mod camera_aptus_22_raw_modes {
  super::camera_file_check!("Leaf", "Aptus 22", cam_aptus_22_iso_25_16bits_mos, "raw_modes/Aptus 22_ISO_25_16bits.MOS");
}
mod camera_aptus_75_raw_modes {
  super::camera_file_check!("Leaf", "Aptus 75", cam_aptus_75_iso_50_16bits_mos, "raw_modes/Aptus 75_ISO_50_16bits.MOS");
}
mod camera_credo_40_raw_modes {
  super::camera_file_check!("Leaf", "Credo 40", cam_credo_40_iso_100_iiq_sv2_iiq, "raw_modes/Credo 40_ISO_100_IIQ Sv2.IIQ");
  super::camera_file_check!("Leaf", "Credo 40", cam_credo_40_iso_100_iiq_l_iiq, "raw_modes/Credo 40_ISO_100_IIQ L.IIQ");
}
mod camera_alexa_65_raw_modes {
  super::camera_file_check!("Arri", "Alexa 65", cam_alexa_65_ari, "raw_modes/Alexa_65.ari");
}
mod camera_alexa_lf_raw_modes {
  super::camera_file_check!("Arri", "Alexa LF", cam_alexa_lf_ari, "raw_modes/Alexa_LF.ari");
}
mod camera_alexa_mini_raw_modes {
  super::camera_file_check!("Arri", "Alexa Mini", cam_alexa_mini_ari, "raw_modes/Alexa_Mini.ari");
}
mod camera_alexa_sxt_raw_modes {
  super::camera_file_check!("Arri", "Alexa SXT", cam_alexa_sxt_ari, "raw_modes/Alexa_SXT.ari");
}
mod camera_alexa_xt_raw_modes {
  super::camera_file_check!("Arri", "Alexa XT", cam_alexa_xt_ari, "raw_modes/Alexa_XT.ari");
}
mod camera_alpha_7_digital_raw_modes {
  super::camera_file_check!("Minolta", "ALPHA-7 DIGITAL", cam_alpha_7_digital_iso_200_uncompressed_mrw, "raw_modes/ALPHA-7 DIGITAL_ISO_200_Uncompressed.MRW");
}
mod camera_dimage_7hi_raw_modes {
  super::camera_file_check!("Minolta", "DiMAGE 7Hi", cam_dimage_7hi_iso_100_uncompressed_mrw, "raw_modes/DiMAGE 7Hi_ISO_100_Uncompressed.MRW");
}
mod camera_dimage_7i_raw_modes {
  super::camera_file_check!("Minolta", "DiMAGE 7i", cam_dimage_7i_iso_100_uncompressed_mrw, "raw_modes/DiMAGE 7i_ISO_100_Uncompressed.MRW");
}
mod camera_dimage_7_raw_modes {
  super::camera_file_check!("Minolta", "DiMAGE 7", cam_dimage_7_iso_100_uncompressed_mrw, "raw_modes/DiMAGE 7_ISO_100_Uncompressed.MRW");
}
mod camera_dimage_a1_raw_modes {
  super::camera_file_check!("Minolta", "DiMAGE A1", cam_dimage_a1_iso_100_uncompressed_mrw, "raw_modes/DiMAGE A1_ISO_100_Uncompressed.MRW");
}
mod camera_dimage_a200_raw_modes {
  super::camera_file_check!("Minolta", "DiMAGE A200", cam_dimage_a200_iso_200_uncompressed_mrw, "raw_modes/DiMAGE A200_ISO_200_Uncompressed.MRW");
}
mod camera_dimage_a2_raw_modes {
  super::camera_file_check!("Minolta", "DiMAGE A2", cam_dimage_a2_iso_64_uncompressed_mrw, "raw_modes/DiMAGE A2_ISO_64_Uncompressed.MRW");
}
mod camera_dimage_g600_raw_modes {
  super::camera_file_check!("Minolta", "DiMAGE G600", cam_minolta_dimage_g600_1_mrw, "raw_modes/Minolta_DiMAGE_G600_1.MRW");
  super::camera_file_check!("Minolta", "DiMAGE G600", cam_minolta_dimage_g600_2_mrw, "raw_modes/Minolta_DiMAGE_G600_2.MRW");
}
mod camera_dynax_7d_raw_modes {
  super::camera_file_check!("Minolta", "Dynax 7D", cam_dynax_7d_iso_100_uncompressed_mrw, "raw_modes/DYNAX 7D_ISO_100_Uncompressed.MRW");
}
mod camera_maxxum_7d_raw_modes {
  super::camera_file_check!("Minolta", "Maxxum 7D", cam_maxxum_7d_iso_200_uncompressed_mrw, "raw_modes/MAXXUM 7D_ISO_200_Uncompressed.MRW");
}
mod camera_zd_raw_modes {
  super::camera_file_check!("Mamiya", "ZD", cam_mamiya_zd_mef, "raw_modes/MAMIYA_ZD.MEF");
}
mod camera_cfv_50_raw_modes {
  super::camera_file_check!("Hasselblad", "CFV-50", cam_hasselblad_cfv_50_iso_50_jpeg_fff, "raw_modes/Hasselblad CFV-50_ISO_50_JPEG.FFF");
}
mod camera_cfv_raw_modes {
  super::camera_file_check!("Hasselblad", "CFV", cam_hasselblad_500_mech__iso_100_jpeg_3fr, "raw_modes/Hasselblad 500 mech._ISO_100_JPEG.3FR");
}
mod camera_h3d_raw_modes {
  super::camera_file_check!("Hasselblad", "H3D", cam_hasselblad_h3d_iso_50_jpeg_3fr, "raw_modes/Hasselblad H3D_ISO_50_JPEG.3FR");
}
mod camera_h4d_50_raw_modes {
  super::camera_file_check!("Hasselblad", "H4D-50", cam_hasselblad_h4d_50_iso_100_jpeg_fff, "raw_modes/Hasselblad H4D-50_ISO_100_JPEG.FFF");
}
mod camera_h5d_40_raw_modes {
  super::camera_file_check!("Hasselblad", "H5D-40", cam_hasselblad_h5d_40_iso_100_jpeg_fff, "raw_modes/Hasselblad H5D-40_ISO_100_JPEG.FFF");
}
mod camera_h5d_50c_raw_modes {
  super::camera_file_check!("Hasselblad", "H5D-50c", cam_hasselblad_h5d_50c_iso_100_jpeg_fff, "raw_modes/Hasselblad H5D-50c_ISO_100_JPEG.FFF");
}
mod camera_hasselblad_h4d_40_raw_modes {
  super::camera_file_check!("Hasselblad", "Hasselblad H4D-40", cam_hasselblad_h4d_40_iso_100_jpeg_fff, "raw_modes/Hasselblad H4D-40_ISO_100_JPEG.FFF");
}
mod camera_hasselblad_h4d_raw_modes {
  super::camera_file_check!("Hasselblad", "Hasselblad H4D", cam_hasselblad_h4d_iso_50_jpeg_3fr, "raw_modes/Hasselblad H4D_ISO_50_JPEG.3FR");
}
mod camera_hasselblad_h6d_100cms_raw_modes {
  super::camera_file_check!("Hasselblad", "Hasselblad H6D-100cMS", cam_hasselblad_h6d_100cms_iso_64_jpeg_fff, "raw_modes/Hasselblad H6D-100cMS_ISO_64_JPEG.FFF");
}
mod camera_hasselblad_x1d_raw_modes {
  super::camera_file_check!("Hasselblad", "Hasselblad X1D", cam_hasselblad_x1d_iso_1600_uncompressed_3fr, "raw_modes/Hasselblad X1D_ISO_1600_Uncompressed.3FR");
}
mod camera_hasselblad_x2d_100c_raw_modes {
  super::camera_file_check!("Hasselblad", "Hasselblad X2D 100C", cam_x2d_100c_iso_64_3fr, "raw_modes/X2D 100C_ISO_64.3FR");
}
mod camera_x1d_ii_50c_raw_modes {
  super::camera_file_check!("Hasselblad", "X1D II 50C", cam_x1d_ii_50c_iso_100_uncompressed_3fr, "raw_modes/X1D II 50C_ISO_100_Uncompressed.3FR");
}
mod camera_ex1_raw_modes {
  super::camera_file_check!("Samsung", "EX1", cam_ex1_iso_80_packed_raw_srw, "raw_modes/EX1_ISO_80_Packed RAW.SRW");
}
mod camera_ex2f_raw_modes {
  super::camera_file_check!("Samsung", "EX2F", cam_ex2f_iso_480_packed_raw_srw, "raw_modes/EX2F_ISO_480_Packed RAW.SRW");
}
mod camera_nx1000_raw_modes {
  super::camera_file_check!("Samsung", "NX1000", cam_nx1000_iso_400_samsung_srw_compressed_srw, "raw_modes/NX1000_ISO_400_Samsung SRW Compressed.SRW");
}
mod camera_nx100_raw_modes {
  super::camera_file_check!("Samsung", "NX100", cam_nx100_iso_100_samsung_srw_compressed_srw, "raw_modes/NX100_ISO_100_Samsung SRW Compressed.SRW");
}
mod camera_nx1100_raw_modes {
  super::camera_file_check!("Samsung", "NX1100", cam_nx1100_iso_200_samsung_srw_compressed_srw, "raw_modes/NX1100_ISO_200_Samsung SRW Compressed.SRW");
}
mod camera_nx1_raw_modes {
  super::camera_file_check!("Samsung", "NX1", cam_nx1_iso_400_packbits_srw, "raw_modes/NX1_ISO_400_PackBits.SRW");
}
mod camera_nx2000_raw_modes {
  super::camera_file_check!("Samsung", "NX2000", cam_nx2000_iso_320_samsung_srw_compressed_srw, "raw_modes/NX2000_ISO_320_Samsung SRW Compressed.SRW");
}
mod camera_nx200_raw_modes {
  super::camera_file_check!("Samsung", "NX200", cam_nx200_iso_200_samsung_srw_compressed_srw, "raw_modes/NX200_ISO_200_Samsung SRW Compressed.SRW");
}
mod camera_nx20_raw_modes {
  super::camera_file_check!("Samsung", "NX20", cam_nx20_iso_200_samsung_srw_compressed_srw, "raw_modes/NX20_ISO_200_Samsung SRW Compressed.SRW");
}
mod camera_nx210_raw_modes {
  super::camera_file_check!("Samsung", "NX210", cam_nx210_iso_100_samsung_srw_compressed_srw, "raw_modes/NX210_ISO_100_Samsung SRW Compressed.SRW");
}
mod camera_nx3000_raw_modes {
  super::camera_file_check!("Samsung", "NX3000", cam_nx3000_iso_100_samsung_srw_compressed_2_srw, "raw_modes/NX3000_ISO_100_Samsung SRW Compressed 2.SRW");
}
mod camera_nx3300_raw_modes {
  super::camera_file_check!("Samsung", "NX3300", cam_nx3300_12bits_srw, "raw_modes/NX3300_12bits.SRW");
}
mod camera_nx300m_raw_modes {
  super::camera_file_check!("Samsung", "NX300M", cam_nx300m_iso_800_samsung_srw_compressed_srw, "raw_modes/NX300M_ISO_800_Samsung SRW Compressed.SRW");
}
mod camera_nx300_raw_modes {
  super::camera_file_check!("Samsung", "NX300", cam_nx300_iso_100_samsung_srw_compressed_srw, "raw_modes/NX300_ISO_100_Samsung SRW Compressed.SRW");
}
mod camera_nx30_raw_modes {
  super::camera_file_check!("Samsung", "NX30", cam_nx30_iso_800_samsung_srw_compressed_srw, "raw_modes/NX30_ISO_800_Samsung SRW Compressed.SRW");
}
mod camera_nx500_raw_modes {
  super::camera_file_check!("Samsung", "NX500", cam_nx500_iso_100_14bits_normal_compression_srw, "raw_modes/NX500_ISO_100_14bits_normal_compression.SRW");
  super::camera_file_check!("Samsung", "NX500", cam_nx500_iso_100_12bits_lossless_compression_srw, "raw_modes/NX500_ISO_100_12bits_lossless_compression.SRW");
  super::camera_file_check!("Samsung", "NX500", cam_nx500_iso_100_12bits_normal_compression_srw, "raw_modes/NX500_ISO_100_12bits_normal_compression.SRW");
  super::camera_file_check!("Samsung", "NX500", cam_nx500_iso_100_14bits_lossless_compression_srw, "raw_modes/NX500_ISO_100_14bits_lossless_compression.SRW");
}
mod camera_nx_mini_raw_modes {
  super::camera_file_check!("Samsung", "NX mini", cam_nx_mini_iso_1000_samsung_srw_compressed_2_srw, "raw_modes/NX mini_ISO_1000_Samsung SRW Compressed 2.SRW");
}
mod camera_wb2000_raw_modes {
  super::camera_file_check!("Samsung", "WB2000", cam_wb2000_iso_80_packed_raw_srw, "raw_modes/WB2000_ISO_80_Packed RAW.SRW");
}
mod camera_dc120_raw_modes {
  super::camera_file_check!("Kodak", "DC120", cam_kodak_dc120_zoom_digital_camera_jpeg_kdc, "raw_modes/Kodak DC120 ZOOM Digital Camera_JPEG.KDC");
  super::camera_file_check!("Kodak", "DC120", cam_kodak_dc120_zoom_digital_camera_uncompressed_kdc, "raw_modes/Kodak DC120 ZOOM Digital Camera_Uncompressed.KDC");
}
mod camera_dc50_raw_modes {
  super::camera_file_check!("Kodak", "DC50", cam_kodak_dc50_compressed_kdc, "raw_modes/Kodak_DC50_compressed.KDC");
}
mod camera_dcs460d_raw_modes {
  super::camera_file_check!("Kodak", "DCS460D", cam_dcs460d_tiff, "raw_modes/DCS460D.TIFF");
}
mod camera_dcs560c_raw_modes {
  super::camera_file_check!("Kodak", "DCS560C", cam_raw_kodak_dcs560c_tif, "raw_modes/RAW_KODAK_DCS560C.TIF");
}
mod camera_dcs760c_raw_modes {
  super::camera_file_check!("Kodak", "DCS760C", cam_dcs760c_dcr, "raw_modes/DCS760C.DCR");
}
mod camera_dcs_pro_14n_raw_modes {
  super::camera_file_check!("Kodak", "DCS Pro 14N", cam_dcs_pro_14n_iso_160_kodak_dcr_compressed_dcr, "raw_modes/DCS Pro 14N_ISO_160_Kodak DCR Compressed.DCR");
}
mod camera_dcs_pro_14nx_raw_modes {
  super::camera_file_check!("Kodak", "DCS Pro 14nx", cam_dcs_pro_14nx_iso_160_kodak_dcr_compressed_dcr, "raw_modes/DCS Pro 14nx_ISO_160_Kodak DCR Compressed.DCR");
}
mod camera_dcs_pro_slrc_raw_modes {
  super::camera_file_check!("Kodak", "DCS Pro SLRc", cam_dcs_pro_slrc_iso_160_kodak_dcr_compressed_dcr, "raw_modes/DCS Pro SLRc_ISO_160_Kodak DCR Compressed.DCR");
}
mod camera_dcs_pro_slrn_raw_modes {
  super::camera_file_check!("Kodak", "DCS Pro SLRn", cam_dcs_pro_slrn_iso_160_kodak_dcr_compressed_dcr, "raw_modes/DCS Pro SLRn_ISO_160_Kodak DCR Compressed.DCR");
}
mod camera_easyshare_z981_raw_modes {
  super::camera_file_check!("Kodak", "EasyShare Z981", cam_kodak_easyshare_z981_digital_camera_iso_100_jpeg_kdc, "raw_modes/KODAK EasyShare Z981 Digital Camera_ISO_100_JPEG.KDC");
}
mod camera_easyshare_z990_raw_modes {
  super::camera_file_check!("Kodak", "EasyShare Z990", cam_kodak_easyshare_z990_digital_camera_iso_125_kdc, "raw_modes/KODAK EasyShare Z990 Digital Camera_ISO_125.KDC");
}
mod camera_eos_dcs_1_raw_modes {
  super::camera_file_check!("Kodak", "EOS DCS 1", cam_raw_canon_dcs1_tif, "raw_modes/RAW_CANON_DCS1.TIF");
}
mod camera_eos_dcs_3_raw_modes {
  super::camera_file_check!("Kodak", "EOS DCS 3", cam_eos_dcs_3_tif, "raw_modes/EOS DCS 3.TIF");
}
mod camera_kodak_p712_zoom_digital_camera_raw_modes {
  super::camera_file_check!("Kodak", "KODAK P712 ZOOM DIGITAL CAMERA", cam_kodak_p712_zoom_digital_camera_iso_64_jpeg_kdc, "raw_modes/KODAK P712 ZOOM DIGITAL CAMERA_ISO_64_JPEG.KDC");
}
mod camera_p880_raw_modes {
  super::camera_file_check!("Kodak", "P880", cam_kodak_p880_zoom_digital_camera_iso_50_jpeg_kdc, "raw_modes/KODAK P880 ZOOM DIGITAL CAMERA_ISO_50_JPEG.KDC");
}
mod camera_z1015_is_raw_modes {
  super::camera_file_check!("Kodak", "Z1015 IS", cam_raw_kodak_easyshare_z1015_is_kdc, "raw_modes/RAW_KODAK_EASYSHARE_Z1015-IS.KDC");
}
mod camera_c5050z_raw_modes {
  super::camera_file_check!("Olympus", "C5050Z", cam_c5050z_iso_100_orf, "raw_modes/C5050Z_ISO_100.ORF");
}
mod camera_c5060wz_raw_modes {
  super::camera_file_check!("Olympus", "C5060WZ", cam_c5060wz_iso_80_orf, "raw_modes/C5060WZ_ISO_80.ORF");
}
mod camera_c7070wz_raw_modes {
  super::camera_file_check!("Olympus", "C7070WZ", cam_c7070wz_iso_80_orf, "raw_modes/C7070WZ_ISO_80.ORF");
}
mod camera_c8080wz_raw_modes {
  super::camera_file_check!("Olympus", "C8080WZ", cam_c8080wz_iso_50_orf, "raw_modes/C8080WZ_ISO_50.ORF");
}
mod camera_e_10_raw_modes {
  super::camera_file_check!("Olympus", "E-10", cam_e_10_iso_80_orf, "raw_modes/E-10_ISO_80.ORF");
}
mod camera_e_1_raw_modes {
  super::camera_file_check!("Olympus", "E-1", cam_e_1_iso_100_orf, "raw_modes/E-1_ISO_100.ORF");
}
mod camera_e_20_raw_modes {
  super::camera_file_check!("Olympus", "E-20", cam_e_20_iso_80_orf, "raw_modes/E-20_ISO_80.ORF");
}
mod camera_e_300_raw_modes {
  super::camera_file_check!("Olympus", "E-300", cam_e_300_iso_400_orf, "raw_modes/E-300_ISO_400.ORF");
}
mod camera_e_30_raw_modes {
  super::camera_file_check!("Olympus", "E-30", cam_e_30_iso_200_orf, "raw_modes/E-30_ISO_200.ORF");
}
mod camera_e_330_raw_modes {
  super::camera_file_check!("Olympus", "E-330", cam_e_330_iso_100_orf, "raw_modes/E-330_ISO_100.ORF");
}
mod camera_e_3_raw_modes {
  super::camera_file_check!("Olympus", "E-3", cam_e_3_iso_100_orf, "raw_modes/E-3_ISO_100.ORF");
}
mod camera_e_400_raw_modes {
  super::camera_file_check!("Olympus", "E-400", cam_e_400_iso_200_orf, "raw_modes/E-400_ISO_200.ORF");
}
mod camera_e_410_raw_modes {
  super::camera_file_check!("Olympus", "E-410", cam_e_410_iso_400_orf, "raw_modes/E-410_ISO_400.ORF");
}
mod camera_e_420_raw_modes {
  super::camera_file_check!("Olympus", "E-420", cam_e_420_iso_100_orf, "raw_modes/E-420_ISO_100.ORF");
}
mod camera_e_450_raw_modes {
  super::camera_file_check!("Olympus", "E-450", cam_e_450_iso_200_orf, "raw_modes/E-450_ISO_200.ORF");
}
mod camera_e_500_raw_modes {
  super::camera_file_check!("Olympus", "E-500", cam_e_500_iso_400_orf, "raw_modes/E-500_ISO_400.ORF");
}
mod camera_e_510_raw_modes {
  super::camera_file_check!("Olympus", "E-510", cam_e_510_iso_100_orf, "raw_modes/E-510_ISO_100.ORF");
}
mod camera_e_520_raw_modes {
  super::camera_file_check!("Olympus", "E-520", cam_e_520_iso_400_orf, "raw_modes/E-520_ISO_400.ORF");
}
mod camera_e_5_raw_modes {
  super::camera_file_check!("Olympus", "E-5", cam_e_5_iso_200_orf, "raw_modes/E-5_ISO_200.ORF");
}
mod camera_e_600_raw_modes {
  super::camera_file_check!("Olympus", "E-600", cam_e_600_iso_100_orf, "raw_modes/E-600_ISO_100.ORF");
}
mod camera_e_620_raw_modes {
  super::camera_file_check!("Olympus", "E-620", cam_e_620_iso_200_orf, "raw_modes/E-620_ISO_200.ORF");
}
mod camera_e_m10_mark_iii_raw_modes {
  super::camera_file_check!("Olympus", "E-M10 Mark III", cam_e_m10_mark_iii_iso_100_orf, "raw_modes/E-M10 Mark III_ISO_100.ORF");
}
mod camera_e_m10markiiis_raw_modes {
  super::camera_file_check!("Olympus", "E-M10MarkIIIS", cam_e_m10markiiis_iso_200_orf, "raw_modes/E-M10MarkIIIS_ISO_200.ORF");
}
mod camera_e_m10_mark_ii_raw_modes {
  super::camera_file_check!("Olympus", "E-M10 Mark II", cam_e_m10markii_iso_3200_orf, "raw_modes/E-M10MarkII_ISO_3200.ORF");
}
mod camera_e_m10_mark_iv_raw_modes {
  super::camera_file_check!("Olympus", "E-M10 Mark IV", cam_e_m10markiv_iso_100_stackedmode_no_orf, "raw_modes/E-M10MarkIV_ISO_100_StackedMode_No.ORF");
}
mod camera_e_m10_raw_modes {
  super::camera_file_check!("Olympus", "E-M10", cam_e_m10_iso_200_orf, "raw_modes/E-M10_ISO_200.ORF");
}
mod camera_e_m1markiii_raw_modes {
  super::camera_file_check!("Olympus", "E-M1MarkIII", cam_e_m1markiii_iso_200_stackedmode_no_orf, "raw_modes/E-M1MarkIII_ISO_200_StackedMode_No.ORF");
  super::camera_file_check!("Olympus", "E-M1MarkIII", cam_e_m1markiii_iso_200_stackedmode_hand_held_high_resolution_orf, "raw_modes/E-M1MarkIII_ISO_200_StackedMode_Hand-held high resolution.ORF");
  super::camera_file_check!("Olympus", "E-M1MarkIII", cam_e_m1markiii_iso_200_stackedmode_tripod_high_resolution_orf, "raw_modes/E-M1MarkIII_ISO_200_StackedMode_Tripod high resolution.ORF");
}
mod camera_e_m1markii_raw_modes {
  super::camera_file_check!("Olympus", "E-M1MarkII", cam_olympus_em1mk2__hires_25mp_ori, "raw_modes/Olympus_EM1mk2__HIRES_25MP.ORI");
  super::camera_file_check!("Olympus", "E-M1MarkII", cam_olympus_em1mk2__hires_50mp_ori, "raw_modes/Olympus_EM1mk2__HIRES_50MP.ORI");
  super::camera_file_check!("Olympus", "E-M1MarkII", cam_olympus_em1mk2_standard_20mp_colorchecker_orf, "raw_modes/Olympus_EM1mk2_Standard_20MP_ColorChecker.ORF");
  super::camera_file_check!("Olympus", "E-M1MarkII", cam_olympus_em1mk2_standard_20mp_orf, "raw_modes/Olympus_EM1mk2_Standard_20MP.ORF");
  super::camera_file_check!("Olympus", "E-M1MarkII", cam_olympus_em1mk2__hires_25mp_orf, "raw_modes/Olympus_EM1mk2__HIRES_25MP.ORF");
  super::camera_file_check!("Olympus", "E-M1MarkII", cam_olympus_em1mk2__hires_50mp_orf, "raw_modes/Olympus_EM1mk2__HIRES_50MP.ORF");
}
mod camera_e_m1_raw_modes {
  super::camera_file_check!("Olympus", "E-M1", cam_e_m1_iso_200_orf, "raw_modes/E-M1_ISO_200.ORF");
}
mod camera_e_m1x_raw_modes {
  super::camera_file_check!("Olympus", "E-M1X", cam_e_m1x_iso_1600_orf, "raw_modes/E-M1X_ISO_1600.ORF");
}
mod camera_e_m5_mark_iii_raw_modes {
  super::camera_file_check!("Olympus", "E-M5 Mark III", cam_e_m5markiii_iso_200_orf, "raw_modes/E-M5MarkIII_ISO_200.ORF");
}
mod camera_e_m5_mark_ii_raw_modes {
  super::camera_file_check!("Olympus", "E-M5 Mark II", cam_e_m5markii_iso_200_stackedmode_tripod_high_resolution_orf, "raw_modes/E-M5MarkII_ISO_200_StackedMode_Tripod high resolution.ORF");
  super::camera_file_check!("Olympus", "E-M5 Mark II", cam_e_m5markii_iso_200_stackedmode_no_orf, "raw_modes/E-M5MarkII_ISO_200_StackedMode_No.ORF");
}
mod camera_e_m5_raw_modes {
  super::camera_file_check!("Olympus", "E-M5", cam_e_m5_iso_200_orf, "raw_modes/E-M5_ISO_200.ORF");
}
mod camera_e_p1_raw_modes {
  super::camera_file_check!("Olympus", "E-P1", cam_e_p1_iso_100_orf, "raw_modes/E-P1_ISO_100.ORF");
  super::camera_file_check!("Olympus", "E-P1", cam_e_p1_iso_200_orf, "raw_modes/E-P1_ISO_200.ORF");
}
mod camera_e_p2_raw_modes {
  super::camera_file_check!("Olympus", "E-P2", cam_e_p2_iso_800_orf, "raw_modes/E-P2_ISO_800.ORF");
}
mod camera_e_p3_raw_modes {
  super::camera_file_check!("Olympus", "E-P3", cam_e_p3_iso_200_orf, "raw_modes/E-P3_ISO_200.ORF");
}
mod camera_e_p5_raw_modes {
  super::camera_file_check!("Olympus", "E-P5", cam_e_p5_iso_200_orf, "raw_modes/E-P5_ISO_200.ORF");
}
mod camera_e_pl10_raw_modes {
  super::camera_file_check!("Olympus", "E-PL10", cam_e_pl10_iso_1000_orf, "raw_modes/E-PL10_ISO_1000.ORF");
}
mod camera_e_pl1_raw_modes {
  super::camera_file_check!("Olympus", "E-PL1", cam_e_pl1_iso_1600_orf, "raw_modes/E-PL1_ISO_1600.ORF");
}
mod camera_e_pl2_raw_modes {
  super::camera_file_check!("Olympus", "E-PL2", cam_e_pl2_iso_200_orf, "raw_modes/E-PL2_ISO_200.ORF");
}
mod camera_e_pl3_raw_modes {
  super::camera_file_check!("Olympus", "E-PL3", cam_e_pl3_iso_200_orf, "raw_modes/E-PL3_ISO_200.ORF");
}
mod camera_e_pl5_raw_modes {
  super::camera_file_check!("Olympus", "E-PL5", cam_e_pl5_iso_320_orf, "raw_modes/E-PL5_ISO_320.ORF");
}
mod camera_e_pl6_raw_modes {
  super::camera_file_check!("Olympus", "E-PL6", cam_e_pl6_iso_200_orf, "raw_modes/E-PL6_ISO_200.ORF");
}
mod camera_e_pl7_raw_modes {
  super::camera_file_check!("Olympus", "E-PL7", cam_e_pl7_iso_200_orf, "raw_modes/E-PL7_ISO_200.ORF");
}
mod camera_e_pl8_raw_modes {
  super::camera_file_check!("Olympus", "E-PL8", cam_e_pl8_iso_200_orf, "raw_modes/E-PL8_ISO_200.ORF");
}
mod camera_e_pl9_raw_modes {
  super::camera_file_check!("Olympus", "E-PL9", cam_e_pl9_iso_200_orf, "raw_modes/E-PL9_ISO_200.ORF");
}
mod camera_e_pm1_raw_modes {
  super::camera_file_check!("Olympus", "E-PM1", cam_e_pm1_iso_200_orf, "raw_modes/E-PM1_ISO_200.ORF");
}
mod camera_e_pm2_raw_modes {
  super::camera_file_check!("Olympus", "E-PM2", cam_e_pm2_iso_200_orf, "raw_modes/E-PM2_ISO_200.ORF");
}
mod camera_pen_f_raw_modes {
  super::camera_file_check!("Olympus", "PEN-F", cam_pen_f_iso_200_stackedmode_no_orf, "raw_modes/PEN-F_ISO_200_StackedMode_No.ORF");
  super::camera_file_check!("Olympus", "PEN-F", cam_pen_f_iso_200_stackedmode_tripod_high_resolution_orf, "raw_modes/PEN-F_ISO_200_StackedMode_Tripod high resolution.ORF");
}
mod camera_sh_2_raw_modes {
  super::camera_file_check!("Olympus", "SH-2", cam_sh_2_iso_125_orf, "raw_modes/SH-2_ISO_125.ORF");
}
mod camera_sp350_raw_modes {
  super::camera_file_check!("Olympus", "SP350", cam_sp350_iso_100_orf, "raw_modes/SP350_ISO_100.ORF");
}
mod camera_sp500uz_raw_modes {
  super::camera_file_check!("Olympus", "SP500UZ", cam_sp500uz_iso_100_orf, "raw_modes/SP500UZ_ISO_100.ORF");
}
mod camera_sp510uz_raw_modes {
  super::camera_file_check!("Olympus", "SP510UZ", cam_sp510uz_iso_50_orf, "raw_modes/SP510UZ_ISO_50.ORF");
}
mod camera_sp565uz_raw_modes {
  super::camera_file_check!("Olympus", "SP565UZ", cam_sp565uz_iso_64_orf, "raw_modes/SP565UZ_ISO_64.ORF");
}
mod camera_sp570uz_raw_modes {
  super::camera_file_check!("Olympus", "SP570UZ", cam_olympus_sp570uz_12bit_orf, "raw_modes/Olympus_SP570UZ_12bit.ORF");
}
mod camera_stylus1_raw_modes {
  super::camera_file_check!("Olympus", "Stylus1", cam_stylus1_iso_100_orf, "raw_modes/STYLUS1_ISO_100.ORF");
}
mod camera_tg_4_raw_modes {
  super::camera_file_check!("Olympus", "TG-4", cam_tg_4_iso_100_orf, "raw_modes/TG-4_ISO_100.ORF");
}
mod camera_tg_5_raw_modes {
  super::camera_file_check!("Olympus", "TG-5", cam_tg_5_iso_100_orf, "raw_modes/TG-5_ISO_100.ORF");
}
mod camera_tg_6_raw_modes {
  super::camera_file_check!("Olympus", "TG-6", cam_tg_6_iso_100_orf, "raw_modes/TG-6_ISO_100.ORF");
}
mod camera_xz_10_raw_modes {
  super::camera_file_check!("Olympus", "XZ-10", cam_xz_10_iso_100_orf, "raw_modes/XZ-10_ISO_100.ORF");
}
mod camera_xz_1_raw_modes {
  super::camera_file_check!("Olympus", "XZ-1", cam_xz_1_iso_100_orf, "raw_modes/XZ-1_ISO_100.ORF");
}
mod camera_xz_2_raw_modes {
  super::camera_file_check!("Olympus", "XZ-2", cam_xz_2_iso_100_orf, "raw_modes/XZ-2_ISO_100.ORF");
}
mod camera_dc_fz10002_raw_modes {
  super::camera_file_check!("Panasonic", "DC-FZ10002", cam_dc_fz10002_iso_320_4fmt_3x2_rw2, "raw_modes/DC-FZ10002_ISO_320_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DC-FZ10002", cam_dc_fz10002_iso_250_4fmt_1x1_rw2, "raw_modes/DC-FZ10002_ISO_250_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-FZ10002", cam_dc_fz10002_iso_250_4fmt_4x3_rw2, "raw_modes/DC-FZ10002_ISO_250_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-FZ10002", cam_dc_fz10002_iso_250_4fmt_16x9_rw2, "raw_modes/DC-FZ10002_ISO_250_4fmt_16x9.RW2");
}
mod camera_dc_fz45_raw_modes {
  super::camera_file_check!("Panasonic", "DC-FZ45", cam_dmc_fz45_iso_500_4fmt_4320x2880_rw2, "raw_modes/DMC-FZ45_ISO_500_4fmt_4320x2880.RW2");
  super::camera_file_check!("Panasonic", "DC-FZ45", cam_dmc_fz45_iso_400_4fmt_4320x3240_rw2, "raw_modes/DMC-FZ45_ISO_400_4fmt_4320x3240.RW2");
  super::camera_file_check!("Panasonic", "DC-FZ45", cam_dmc_fz45_iso_500_4fmt_3232x3234_rw2, "raw_modes/DMC-FZ45_ISO_500_4fmt_3232x3234.RW2");
  super::camera_file_check!("Panasonic", "DC-FZ45", cam_dmc_fz45_iso_500_4fmt_4320x2436_rw2, "raw_modes/DMC-FZ45_ISO_500_4fmt_4320x2436.RW2");
}
mod camera_dc_fz80_raw_modes {
  super::camera_file_check!("Panasonic", "DC-FZ80", cam_dc_fz80_iso_80_4fmt_1x1_rw2, "raw_modes/DC-FZ80_ISO_80_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-FZ80", cam_dc_fz80_iso_80_4fmt_4x3_rw2, "raw_modes/DC-FZ80_ISO_80_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-FZ80", cam_dc_fz80_iso_80_4fmt_3x2_rw2, "raw_modes/DC-FZ80_ISO_80_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DC-FZ80", cam_dc_fz80_iso_80_4fmt_16x9_rw2, "raw_modes/DC-FZ80_ISO_80_4fmt_16x9.RW2");
}
mod camera_dc_fz82_raw_modes {
  super::camera_file_check!("Panasonic", "DC-FZ82", cam_dc_fz82_iso_80_4fmt_4x3_rw2, "raw_modes/DC-FZ82_ISO_80_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-FZ82", cam_dc_fz82_iso_80_4fmt_1x1_rw2, "raw_modes/DC-FZ82_ISO_80_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-FZ82", cam_dc_fz82_iso_80_4fmt_3x2_rw2, "raw_modes/DC-FZ82_ISO_80_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DC-FZ82", cam_dc_fz82_iso_80_4fmt_16x9_rw2, "raw_modes/DC-FZ82_ISO_80_4fmt_16x9.RW2");
}
mod camera_dc_g100_raw_modes {
  super::camera_file_check!("Panasonic", "DC-G100", cam_dc_g100_iso_200_4fmt_16x9_rw2, "raw_modes/DC-G100_ISO_200_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DC-G100", cam_dc_g100_iso_200_4fmt_3x2_rw2, "raw_modes/DC-G100_ISO_200_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DC-G100", cam_dc_g100_iso_200_4fmt_1x1_rw2, "raw_modes/DC-G100_ISO_200_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-G100", cam_dc_g100_iso_200_4fmt_4x3_rw2, "raw_modes/DC-G100_ISO_200_4fmt_4x3.RW2");
}
mod camera_dc_g110_raw_modes {
  super::camera_file_check!("Panasonic", "DC-G110", cam_dc_g110_iso_400_4fmt_1x1_rw2, "raw_modes/DC-G110_ISO_400_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-G110", cam_dc_g110_iso_400_4fmt_4x3_rw2, "raw_modes/DC-G110_ISO_400_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-G110", cam_dc_g110_iso_400_4fmt_16x9_rw2, "raw_modes/DC-G110_ISO_400_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DC-G110", cam_dc_g110_iso_400_4fmt_3x2_rw2, "raw_modes/DC-G110_ISO_400_4fmt_3x2.RW2");
}
mod camera_dc_g90_raw_modes {
  super::camera_file_check!("Panasonic", "DC-G90", cam_dc_g90_iso_200_4fmt_4x3_rw2, "raw_modes/DC-G90_ISO_200_4fmt_4x3.RW2");
}
mod camera_dc_g91_raw_modes {
  super::camera_file_check!("Panasonic", "DC-G91", cam_dc_g91_iso_200_4fmt_4x3_rw2, "raw_modes/DC-G91_ISO_200_4fmt_4x3.RW2");
}
mod camera_dc_g95_raw_modes {
  super::camera_file_check!("Panasonic", "DC-G95", cam_dc_g95_iso_400_4fmt_16x9_rw2, "raw_modes/DC-G95_ISO_400_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DC-G95", cam_dc_g95_iso_400_4fmt_3x2_rw2, "raw_modes/DC-G95_ISO_400_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DC-G95", cam_dc_g95_iso_400_4fmt_4x3_rw2, "raw_modes/DC-G95_ISO_400_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-G95", cam_dc_g95_iso_400_4fmt_1x1_rw2, "raw_modes/DC-G95_ISO_400_4fmt_1x1.RW2");
}
mod camera_dc_g9_raw_modes {
  super::camera_file_check!("Panasonic", "DC-G9", cam_dc_g9_iso_3200_4fmt_4x3_sh2_burst_rw2, "raw_modes/DC-G9_ISO_3200_4fmt_4x3_SH2-Burst.RW2");
  super::camera_file_check!("Panasonic", "DC-G9", cam_dc_g9_iso_200_4fmt_1x1_rw2, "raw_modes/DC-G9_ISO_200_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-G9", cam_dc_g9_iso_200_4fmt_4x3_rw2, "raw_modes/DC-G9_ISO_200_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-G9", cam_dc_g9_iso_200_4fmt_16x9_rw2, "raw_modes/DC-G9_ISO_200_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DC-G9", cam_dc_g9_iso_200_5fmt_4x3_hires_secondary_rw2, "raw_modes/DC-G9_ISO_200_5fmt_4x3_hires_secondary.RW2");
  super::camera_file_check!("Panasonic", "DC-G9", cam_dc_g9_iso_200_5fmt_80mp_hires_rw2, "raw_modes/DC-G9_ISO_200_5fmt_80mp_hires.RW2");
  super::camera_file_check!("Panasonic", "DC-G9", cam_dc_g9_iso_200_4fmt_3x2_rw2, "raw_modes/DC-G9_ISO_200_4fmt_3x2.RW2");
}
mod camera_dc_g9m2_raw_modes {
  super::camera_file_check!("Panasonic", "DC-G9M2", cam_dc_g9m2_iso_100_8fmt_5776x4336_rw2, "raw_modes/DC-G9M2_ISO_100_8fmt_5776x4336.RW2");
  super::camera_file_check!("Panasonic", "DC-G9M2", cam_dc_g9m2_iso_100_8fmt_11552x8672_rw2, "raw_modes/DC-G9M2_ISO_100_8fmt_11552x8672.RW2");
}
mod camera_dc_gf10_raw_modes {
  super::camera_file_check!("Panasonic", "DC-GF10", cam_dc_gf10_iso_200_panasonic_raw_1_4592x3448_rw2, "raw_modes/DC-GF10_ISO_200_Panasonic RAW 1_4592x3448.RW2");
  super::camera_file_check!("Panasonic", "DC-GF10", cam_p1010137_rw2, "raw_modes/P1010137.RW2");
  super::camera_file_check!("Panasonic", "DC-GF10", cam_p1010141_rw2, "raw_modes/P1010141.RW2");
  super::camera_file_check!("Panasonic", "DC-GF10", cam_p1010140_rw2, "raw_modes/P1010140.RW2");
}
mod camera_dc_gh5m2_raw_modes {
  super::camera_file_check!("Panasonic", "DC-GH5M2", cam_dc_gh5m2_iso_250_6fmt_3x2_rw2, "raw_modes/DC-GH5M2_ISO_250_6fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5M2", cam_dc_gh5m2_iso_250_6fmt_16x9_rw2, "raw_modes/DC-GH5M2_ISO_250_6fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5M2", cam_dc_gh5m2_iso_250_6fmt_4x3_rw2, "raw_modes/DC-GH5M2_ISO_250_6fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5M2", cam_dc_gh5m2_iso_250_6fmt_1x1_rw2, "raw_modes/DC-GH5M2_ISO_250_6fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5M2", cam_dc_gh5m2_colortarget_rw2, "raw_modes/DC-GH5M2_colortarget.RW2");
}
mod camera_dc_gh5_raw_modes {
  super::camera_file_check!("Panasonic", "DC-GH5", cam_dc_gh5_iso_400_4fmt_16x9_rw2, "raw_modes/DC-GH5_ISO_400_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5", cam_dc_gh5_iso_400_4fmt_1x1_rw2, "raw_modes/DC-GH5_ISO_400_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5", cam_dc_gh5_iso_400_4fmt_4x3_rw2, "raw_modes/DC-GH5_ISO_400_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5", cam_dc_gh5_iso_400_4fmt_3x2_rw2, "raw_modes/DC-GH5_ISO_400_4fmt_3x2.RW2");
}
mod camera_dc_gh5s_raw_modes {
  super::camera_file_check!("Panasonic", "DC-GH5S", cam_p1022091_rw2, "raw_modes/P1022091.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5S", cam_dc_gh5s_iso_800_panasonic_raw_1_3840x2560_rw2, "raw_modes/DC-GH5S_ISO_800_Panasonic RAW 1_3840x2560.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5S", cam_dc_gh5s_iso_800_panasonic_raw_1_4016x2256_rw2, "raw_modes/DC-GH5S_ISO_800_Panasonic RAW 1_4016x2256.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5S", cam_dc_gh5s_iso_800_panasonic_raw_1_3680x2760_rw2, "raw_modes/DC-GH5S_ISO_800_Panasonic RAW 1_3680x2760.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5S", cam_p1022090_rw2, "raw_modes/P1022090.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5S", cam_p1022085_rw2, "raw_modes/P1022085.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5S", cam_dc_gh5s_iso_800_panasonic_raw_1_2752x2752_rw2, "raw_modes/DC-GH5S_ISO_800_Panasonic RAW 1_2752x2752.RW2");
  super::camera_file_check!("Panasonic", "DC-GH5S", cam_p1022092_rw2, "raw_modes/P1022092.RW2");
}
mod camera_dc_gh6_raw_modes {
  super::camera_file_check!("Panasonic", "DC-GH6", cam_dc_gh6_iso_800_8fmt_1x1_hires_rw2, "raw_modes/DC-GH6_ISO_800_8fmt_1x1_hires.RW2");
  super::camera_file_check!("Panasonic", "DC-GH6", cam_dc_gh6_iso_800_8fmt_4x3_rw2, "raw_modes/DC-GH6_ISO_800_8fmt_4x3.RW2");
}
mod camera_dc_gx7mk3_raw_modes {
  super::camera_file_check!("Panasonic", "DC-GX7MK3", cam_dc_gx7mk3_iso_1600_panasonic_raw_1_5184x3888_rw2, "raw_modes/DC-GX7MK3_ISO_1600_Panasonic RAW 1_5184x3888.RW2");
}
mod camera_dc_gx800_raw_modes {
  super::camera_file_check!("Panasonic", "DC-GX800", cam_dc_gx800_iso_200_4fmt_3x2_rw2, "raw_modes/DC-GX800_ISO_200_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DC-GX800", cam_dc_gx800_iso_200_4fmt_1x1_rw2, "raw_modes/DC-GX800_ISO_200_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-GX800", cam_dc_gx800_iso_200_4fmt_4x3_rw2, "raw_modes/DC-GX800_ISO_200_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-GX800", cam_dc_gx800_iso_200_4fmt_16x9_rw2, "raw_modes/DC-GX800_ISO_200_4fmt_16x9.RW2");
}
mod camera_dc_gx850_raw_modes {
  super::camera_file_check!("Panasonic", "DC-GX850", cam_dc_gx850_iso_2000_4fmt_1x1_rw2, "raw_modes/DC-GX850_ISO_2000_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-GX850", cam_dc_gx850_iso_2000_4fmt_4x3_rw2, "raw_modes/DC-GX850_ISO_2000_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-GX850", cam_dc_gx850_iso_2000_4fmt_16x9_rw2, "raw_modes/DC-GX850_ISO_2000_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DC-GX850", cam_dc_gx850_iso_2000_4fmt_3x2_rw2, "raw_modes/DC-GX850_ISO_2000_4fmt_3x2.RW2");
}
mod camera_dc_gx880_raw_modes {
  super::camera_file_check!("Panasonic", "DC-GX880", cam_dc_gx880_iso_1250_4fmt_16x9_rw2, "raw_modes/DC-GX880_ISO_1250_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DC-GX880", cam_dc_gx880_iso_1250_4fmt_3x2_rw2, "raw_modes/DC-GX880_ISO_1250_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DC-GX880", cam_dc_gx880_iso_1250_4fmt_1x1_rw2, "raw_modes/DC-GX880_ISO_1250_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-GX880", cam_dc_gx880_iso_1250_4fmt_4x3_rw2, "raw_modes/DC-GX880_ISO_1250_4fmt_4x3.RW2");
}
mod camera_dc_gx9_raw_modes {
  super::camera_file_check!("Panasonic", "DC-GX9", cam_dc_gx9_iso_200_4fmt_16x9_rw2, "raw_modes/DC-GX9_ISO_200_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DC-GX9", cam_dc_gx9_iso_200_4fmt_3x2_rw2, "raw_modes/DC-GX9_ISO_200_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DC-GX9", cam_dc_gx9_iso_200_4fmt_4x3_rw2, "raw_modes/DC-GX9_ISO_200_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-GX9", cam_dc_gx9_iso_200_4fmt_1x1_rw2, "raw_modes/DC-GX9_ISO_200_4fmt_1x1.RW2");
}
mod camera_dc_lx100m2_raw_modes {
  super::camera_file_check!("Panasonic", "DC-LX100M2", cam_dc_lx100m2_iso_200_panasonic_raw_1_4928x3288_rw2, "raw_modes/DC-LX100M2_ISO_200_Panasonic RAW 1_4928x3288.RW2");
  super::camera_file_check!("Panasonic", "DC-LX100M2", cam_dc_lx100m2_iso_200_panasonic_raw_1_3552x3552_rw2, "raw_modes/DC-LX100M2_ISO_200_Panasonic RAW 1_3552x3552.RW2");
  super::camera_file_check!("Panasonic", "DC-LX100M2", cam_dc_lx100m2_iso_200_panasonic_raw_1_4736x3552_rw2, "raw_modes/DC-LX100M2_ISO_200_Panasonic RAW 1_4736x3552.RW2");
  super::camera_file_check!("Panasonic", "DC-LX100M2", cam_dc_lx100m2_iso_200_panasonic_raw_1_5152x2904_rw2, "raw_modes/DC-LX100M2_ISO_200_Panasonic RAW 1_5152x2904.RW2");
}
mod camera_dc_s1h_raw_modes {
  super::camera_file_check!("Panasonic", "DC-S1H", cam_dc_s1h_iso_100_6fmt_6000x4000_rw2, "raw_modes/DC-S1H_ISO_100_6fmt_6000x4000.RW2");
}
mod camera_dc_s1_raw_modes {
  super::camera_file_check!("Panasonic", "DC-S1", cam_dc_s1_iso_800_6fmt_6000x4000_rw2, "raw_modes/DC-S1_ISO_800_6fmt_6000x4000.RW2");
}
mod camera_dc_s1r_raw_modes {
  super::camera_file_check!("Panasonic", "DC-S1R", cam_dc_s1r_iso_100_6fmt_8368x5584_rw2, "raw_modes/DC-S1R_ISO_100_6fmt_8368x5584.RW2");
}
mod camera_dc_s5_raw_modes {
  super::camera_file_check!("Panasonic", "DC-S5", cam_dc_s5_iso_640_6fmt_6000x4000_rw2, "raw_modes/DC-S5_ISO_640_6fmt_6000x4000.RW2");
  super::camera_file_check!("Panasonic", "DC-S5", cam_dc_s5_iso_640_7fmt_12000x8000_rw2, "raw_modes/DC-S5_ISO_640_7fmt_12000x8000.RW2");
}
mod camera_dc_s5m2_raw_modes {
  super::camera_file_check!("Panasonic", "DC-S5M2", cam_dc_s5m2_3x2_rw2, "raw_modes/DC-S5M2_3x2.RW2");
}
mod camera_dc_s5m2x_raw_modes {
  super::camera_file_check!("Panasonic", "DC-S5M2X", cam_dc_s5m2x_3x2_14bits_rw2, "raw_modes/DC-S5M2X_3x2_14bits.RW2");
  super::camera_file_check!("Panasonic", "DC-S5M2X", cam_dc_s5m2x_3x2_sensorshift_96mp_rw2, "raw_modes/DC-S5M2X_3x2_sensorshift_96MP.RW2");
  super::camera_file_check!("Panasonic", "DC-S5M2X", cam_dc_s5m2x_3x2_12bits_burst_rw2, "raw_modes/DC-S5M2X_3x2_12bits_burst.RW2");
}
mod camera_dc_s9_raw_modes {
  super::camera_file_check!("Panasonic", "DC-S9", cam_dc_s9_iso6400_medium_rw2, "raw_modes/DC-S9_ISO6400_Medium.RW2");
  super::camera_file_check!("Panasonic", "DC-S9", cam_dc_s9_iso400_hires_ll_rw2, "raw_modes/DC-S9_ISO400_HiRes-LL.RW2");
  super::camera_file_check!("Panasonic", "DC-S9", cam_dc_s9_iso400_hires_xl_rw2, "raw_modes/DC-S9_ISO400_HiRes-XL.RW2");
  super::camera_file_check!("Panasonic", "DC-S9", cam_dc_s9_iso800_rw2, "raw_modes/DC-S9_ISO800.RW2");
  super::camera_file_check!("Panasonic", "DC-S9", cam_dc_s9_iso6400_rw2, "raw_modes/DC-S9_ISO6400.RW2");
  super::camera_file_check!("Panasonic", "DC-S9", cam_dc_s9_iso800_medium_rw2, "raw_modes/DC-S9_ISO800_Medium.RW2");
  super::camera_file_check!("Panasonic", "DC-S9", cam_dc_s9_iso400_medium_rw2, "raw_modes/DC-S9_ISO400_Medium.RW2");
  super::camera_file_check!("Panasonic", "DC-S9", cam_dc_s9_iso100_rw2, "raw_modes/DC-S9_ISO100.RW2");
  super::camera_file_check!("Panasonic", "DC-S9", cam_dc_s9_iso51200_medium_rw2, "raw_modes/DC-S9_ISO51200_Medium.RW2");
  super::camera_file_check!("Panasonic", "DC-S9", cam_dc_s9_iso51200_rw2, "raw_modes/DC-S9_ISO51200.RW2");
  super::camera_file_check!("Panasonic", "DC-S9", cam_dc_s9_iso100_medium_rw2, "raw_modes/DC-S9_ISO100_Medium.RW2");
}
mod camera_dc_tz200_raw_modes {
  super::camera_file_check!("Panasonic", "DC-TZ200", cam_dc_tz202_iso_125_4fmt_1x1_rw2, "raw_modes/DC-TZ202_ISO_125_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ200", cam_dc_tz202_iso_125_4fmt_4x3_rw2, "raw_modes/DC-TZ202_ISO_125_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ200", cam_dc_tz202_iso_125_4fmt_16x9_rw2, "raw_modes/DC-TZ202_ISO_125_4fmt_16x9.RW2");
}
mod camera_dc_tz202_raw_modes {
  super::camera_file_check!("Panasonic", "DC-TZ202", cam_dc_tz202_iso_200_4fmt_1x1_rw2, "raw_modes/DC-TZ202_ISO_200_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ202", cam_dc_tz202_iso_200_4fmt_4x3_rw2, "raw_modes/DC-TZ202_ISO_200_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ202", cam_dc_tz202_iso_200_4fmt_16x9_rw2, "raw_modes/DC-TZ202_ISO_200_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ202", cam_dc_tz202_iso_200_4fmt_3x2_rw2, "raw_modes/DC-TZ202_ISO_200_4fmt_3x2.RW2");
}
mod camera_dc_tz90_raw_modes {
  super::camera_file_check!("Panasonic", "DC-TZ90", cam_dc_tz90_iso_125_4fmt_5184x3888_rw2, "raw_modes/DC-TZ90_ISO_125_4fmt_5184x3888.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ90", cam_dc_tz90_iso_160_4fmt_5184x3888_rw2, "raw_modes/DC-TZ90_ISO_160_4fmt_5184x3888.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ90", cam_dc_tz90_iso_200_4fmt_5184x3888_rw2, "raw_modes/DC-TZ90_ISO_200_4fmt_5184x3888.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ90", cam_dc_tz90_iso_100_4fmt_5184x3888_rw2, "raw_modes/DC-TZ90_ISO_100_4fmt_5184x3888.RW2");
}
mod camera_dc_tz91_raw_modes {
  super::camera_file_check!("Panasonic", "DC-TZ91", cam_dc_tz91_iso_80_4fmt_5184x3888_rw2, "raw_modes/DC-TZ91_ISO_80_4fmt_5184x3888.RW2");
}
mod camera_dc_tz95_raw_modes {
  super::camera_file_check!("Panasonic", "DC-TZ95", cam_dc_tz95_iso_80_panasonic_raw_1_5184x3888_rw2, "raw_modes/DC-TZ95_ISO_80_Panasonic RAW 1_5184x3888.RW2");
}
mod camera_dc_tz96_raw_modes {
  super::camera_file_check!("Panasonic", "DC-TZ96", cam_dc_tz96_iso_80_4fmt_1x1_rw2, "raw_modes/DC-TZ96_ISO_80_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ96", cam_dc_tz96_iso_80_4fmt_4x3_rw2, "raw_modes/DC-TZ96_ISO_80_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ96", cam_dc_tz96_iso_80_4fmt_16x9_rw2, "raw_modes/DC-TZ96_ISO_80_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ96", cam_dc_tz96_iso_80_4fmt_3x2_rw2, "raw_modes/DC-TZ96_ISO_80_4fmt_3x2.RW2");
}
mod camera_dc_tz220d_raw_modes {
  super::camera_file_check!("Panasonic", "DC-TZ220D", cam_panasonic_dc_tz220d_iso100_3x2_1_rw2, "raw_modes/panasonic_dc-tz220d_iso100_3x2_1.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ220D", cam_panasonic_dc_tz220d_iso100_16x9_2_rw2, "raw_modes/panasonic_dc-tz220d_iso100_16x9_2.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ220D", cam_panasonic_dc_tz220d_iso100_4x3_2_rw2, "raw_modes/panasonic_dc-tz220d_iso100_4x3_2.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ220D", cam_panasonic_dc_tz220d_iso100_1x1_2_rw2, "raw_modes/panasonic_dc-tz220d_iso100_1x1_2.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ220D", cam_panasonic_dc_tz220d_iso100_1x1_1_rw2, "raw_modes/panasonic_dc-tz220d_iso100_1x1_1.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ220D", cam_panasonic_dc_tz220d_iso100_16x9_1_rw2, "raw_modes/panasonic_dc-tz220d_iso100_16x9_1.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ220D", cam_panasonic_dc_tz220d_iso100_4x3_1_rw2, "raw_modes/panasonic_dc-tz220d_iso100_4x3_1.RW2");
  super::camera_file_check!("Panasonic", "DC-TZ220D", cam_panasonic_dc_tz220d_iso100_3x2_2_rw2, "raw_modes/panasonic_dc-tz220d_iso100_3x2_2.RW2");
}
mod camera_dmc_cm1_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-CM1", cam_dmc_cm1_iso_125_panasonic_raw_1_5472x3648_rw2, "raw_modes/DMC-CM1_ISO_125_Panasonic RAW 1_5472x3648.RW2");
  super::camera_file_check!("Panasonic", "DMC-CM1", cam_dmc_cm1_iso_125_panasonic_raw_1_3648x3648_rw2, "raw_modes/DMC-CM1_ISO_125_Panasonic RAW 1_3648x3648.RW2");
  super::camera_file_check!("Panasonic", "DMC-CM1", cam_dmc_cm1_iso_125_panasonic_raw_1_5472x3080_rw2, "raw_modes/DMC-CM1_ISO_125_Panasonic RAW 1_5472x3080.RW2");
  super::camera_file_check!("Panasonic", "DMC-CM1", cam_dmc_cm1_iso_125_panasonic_raw_1_4864x3648_rw2, "raw_modes/DMC-CM1_ISO_125_Panasonic RAW 1_4864x3648.RW2");
}
mod camera_dmc_fx150_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FX150", cam_dmc_fx150_3x2_rw2, "raw_modes/DMC-FX150_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-FX150", cam_dmc_fx150_4x3_rw2, "raw_modes/DMC-FX150_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-FX150", cam_dmc_fx150_16x9_rw2, "raw_modes/DMC-FX150_16x9.RW2");
}
mod camera_dmc_fz1000_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ1000", cam_dmc_fz1000_iso_640_4fmt_5472x3648_rw2, "raw_modes/DMC-FZ1000_ISO_640_4fmt_5472x3648.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ1000", cam_dmc_fz1000_iso_800_4fmt_3648x3648_rw2, "raw_modes/DMC-FZ1000_ISO_800_4fmt_3648x3648.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ1000", cam_dmc_fz1000_iso_640_4fmt_4864x3648_rw2, "raw_modes/DMC-FZ1000_ISO_640_4fmt_4864x3648.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ1000", cam_dmc_fz1000_iso_640_4fmt_5472x3080_rw2, "raw_modes/DMC-FZ1000_ISO_640_4fmt_5472x3080.RW2");
}
mod camera_dmc_fz100_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ100", cam_dmc_fz100_iso_320_panasonic_raw_1_4320x2880_rw2, "raw_modes/DMC-FZ100_ISO_320_Panasonic RAW 1_4320x2880.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ100", cam_dmc_fz100_iso_800_panasonic_raw_1_4320x2432_rw2, "raw_modes/DMC-FZ100_ISO_800_Panasonic RAW 1_4320x2432.RW2");
}
mod camera_dmc_fz150_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ150", cam_dmc_fz150_iso_100_panasonic_raw_1_4000x2248_rw2, "raw_modes/DMC-FZ150_ISO_100_Panasonic RAW 1_4000x2248.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ150", cam_dmc_fz150_iso_100_panasonic_raw_1_4000x3000_rw2, "raw_modes/DMC-FZ150_ISO_100_Panasonic RAW 1_4000x3000.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ150", cam_dmc_fz150_iso_100_panasonic_raw_1_4000x2672_rw2, "raw_modes/DMC-FZ150_ISO_100_Panasonic RAW 1_4000x2672.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ150", cam_dmc_fz150_iso_100_panasonic_raw_1_2992x2992_rw2, "raw_modes/DMC-FZ150_ISO_100_Panasonic RAW 1_2992x2992.RW2");
}
mod camera_dmc_fz18_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ18", cam_dmc_fz18_iso_100_2fmt_3264x2448_raw, "raw_modes/DMC-FZ18_ISO_100_2fmt_3264x2448.RAW");
}
mod camera_dmc_fz2000_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ2000", cam_dmc_fz2000_iso_80_4fmt_3x2_rw2, "raw_modes/DMC-FZ2000_ISO_80_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ2000", cam_dmc_fz2000_iso_80_4fmt_16x9_rw2, "raw_modes/DMC-FZ2000_ISO_80_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ2000", cam_dmc_fz2000_iso_80_4fmt_4x3_rw2, "raw_modes/DMC-FZ2000_ISO_80_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ2000", cam_dmc_fz2000_iso_80_4fmt_1x1_rw2, "raw_modes/DMC-FZ2000_ISO_80_4fmt_1x1.RW2");
}
mod camera_dmc_fz200_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ200", cam_dmc_fz200_iso_100_4fmt_2992x2992_rw2, "raw_modes/DMC-FZ200_ISO_100_4fmt_2992x2992.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ200", cam_dmc_fz200_iso_100_4fmt_4000x3000_rw2, "raw_modes/DMC-FZ200_ISO_100_4fmt_4000x3000.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ200", cam_dmc_fz200_iso_100_4fmt_4000x2672_rw2, "raw_modes/DMC-FZ200_ISO_100_4fmt_4000x2672.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ200", cam_dmc_fz200_iso_100_4fmt_4000x2248_rw2, "raw_modes/DMC-FZ200_ISO_100_4fmt_4000x2248.RW2");
}
mod camera_dmc_fz2500_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ2500", cam_dmc_fz2500_iso_125_4fmt_1x1_rw2, "raw_modes/DMC-FZ2500_ISO_125_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ2500", cam_dmc_fz2500_iso_125_4fmt_16x9_rw2, "raw_modes/DMC-FZ2500_ISO_125_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ2500", cam_dmc_fz2500_iso_125_4fmt_4x3_rw2, "raw_modes/DMC-FZ2500_ISO_125_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ2500", cam_dmc_fz2500_iso_125_4fmt_3x2_rw2, "raw_modes/DMC-FZ2500_ISO_125_4fmt_3x2.RW2");
}
mod camera_dmc_fz28_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ28", cam_dmc_fz28_iso_400_4fmt_3648x2056_rw2, "raw_modes/DMC-FZ28_ISO_400_4fmt_3648x2056.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ28", cam_dmc_fz28_iso_100_4fmt_3648x2736_rw2, "raw_modes/DMC-FZ28_ISO_100_4fmt_3648x2736.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ28", cam_dmc_fz28_iso_400_4fmt_3648x2432_rw2, "raw_modes/DMC-FZ28_ISO_400_4fmt_3648x2432.RW2");
}
mod camera_dmc_fz300_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ300", cam_dmc_fz300_iso_100_4fmt_3x2_rw2, "raw_modes/DMC-FZ300_ISO_100_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ300", cam_dmc_fz300_iso_100_4fmt_4x2_rw2, "raw_modes/DMC-FZ300_ISO_100_4fmt_4x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ300", cam_dmc_fz300_iso_100_4fmt_16x9_rw2, "raw_modes/DMC-FZ300_ISO_100_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ300", cam_dmc_fz300_iso_100_4fmt_1x1_rw2, "raw_modes/DMC-FZ300_ISO_100_4fmt_1x1.RW2");
}
mod camera_dmc_fz30_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ30", cam_dmc_fz30_iso_80_panasonic_raw_3_3264x2448_raw, "raw_modes/DMC-FZ30_ISO_80_Panasonic RAW 3_3264x2448.RAW");
}
mod camera_dmc_fz330_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ330", cam_dmc_fz330_iso_100_4fmt_16x9_rw2, "raw_modes/DMC-FZ330_ISO_100_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ330", cam_dmc_fz330_iso_100_4fmt_3x2_rw2, "raw_modes/DMC-FZ330_ISO_100_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ330", cam_dmc_fz330_iso_100_4fmt_4x3_rw2, "raw_modes/DMC-FZ330_ISO_100_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ330", cam_dmc_fz330_iso_100_4fmt_1x1_rw2, "raw_modes/DMC-FZ330_ISO_100_4fmt_1x1.RW2");
}
mod camera_dmc_fz35_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ35", cam_dmc_fz35_iso_80_panasonic_raw_1_4000x2672_rw2, "raw_modes/DMC-FZ35_ISO_80_Panasonic RAW 1_4000x2672.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ35", cam_dmc_fz35_iso_80_panasonic_raw_1_4000x3000_rw2, "raw_modes/DMC-FZ35_ISO_80_Panasonic RAW 1_4000x3000.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ35", cam_dmc_fz35_iso_80_panasonic_raw_1_4000x2248_rw2, "raw_modes/DMC-FZ35_ISO_80_Panasonic RAW 1_4000x2248.RW2");
}
mod camera_dmc_fz38_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ38", cam_dmc_fz38_iso_80_panasonic_raw_1_4000x3000_rw2, "raw_modes/DMC-FZ38_ISO_80_Panasonic RAW 1_4000x3000.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ38", cam_dmc_fz38_iso_80_panasonic_raw_1_4000x2672_rw2, "raw_modes/DMC-FZ38_ISO_80_Panasonic RAW 1_4000x2672.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ38", cam_dmc_fz38_iso_80_panasonic_raw_1_4000x2248_rw2, "raw_modes/DMC-FZ38_ISO_80_Panasonic RAW 1_4000x2248.RW2");
}
mod camera_dmc_fz45_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ45", cam_dmc_fz45_iso_500_panasonic_raw_1_4320x2436_rw2, "raw_modes/DMC-FZ45_ISO_500_Panasonic RAW 1_4320x2436.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ45", cam_dmc_fz45_iso_500_panasonic_raw_1_3232x3234_rw2, "raw_modes/DMC-FZ45_ISO_500_Panasonic RAW 1_3232x3234.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ45", cam_dmc_fz45_iso_400_panasonic_raw_1_4320x3240_rw2, "raw_modes/DMC-FZ45_ISO_400_Panasonic RAW 1_4320x3240.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ45", cam_dmc_fz45_iso_500_panasonic_raw_1_4320x2880_rw2, "raw_modes/DMC-FZ45_ISO_500_Panasonic RAW 1_4320x2880.RW2");
}
mod camera_dmc_fz50_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ50", cam_dmc_fz50_iso_100_panasonic_raw_3_3648x2424_raw, "raw_modes/DMC-FZ50_ISO_100_Panasonic RAW 3_3648x2424.RAW");
  super::camera_file_check!("Panasonic", "DMC-FZ50", cam_dmc_fz50_iso_100_panasonic_raw_3_3648x2052_raw, "raw_modes/DMC-FZ50_ISO_100_Panasonic RAW 3_3648x2052.RAW");
  super::camera_file_check!("Panasonic", "DMC-FZ50", cam_dmc_fz50_iso_100_panasonic_raw_3_3648x2736_raw, "raw_modes/DMC-FZ50_ISO_100_Panasonic RAW 3_3648x2736.RAW");
}
mod camera_dmc_fz70_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ70", cam_dmc_fz70_iso_100_panasonic_raw_1_4608x3456_rw2, "raw_modes/DMC-FZ70_ISO_100_Panasonic RAW 1_4608x3456.RW2");
}
mod camera_dmc_fz72_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ72", cam_dmc_fz72_iso_200_4fmt_4608x3456_rw2, "raw_modes/DMC-FZ72_ISO_200_4fmt_4608x3456.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ72", cam_dmc_fz72_iso_100_4fmt_4608x3072_rw2, "raw_modes/DMC-FZ72_ISO_100_4fmt_4608x3072.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ72", cam_dmc_fz72_iso_100_4fmt_3456x3456_rw2, "raw_modes/DMC-FZ72_ISO_100_4fmt_3456x3456.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ72", cam_dmc_fz72_iso_100_4fmt_4608x2592_rw2, "raw_modes/DMC-FZ72_ISO_100_4fmt_4608x2592.RW2");
  super::camera_file_check!("Panasonic", "DMC-FZ72", cam_dmc_fz72_iso_100_4fmt_4608x3456_rw2, "raw_modes/DMC-FZ72_ISO_100_4fmt_4608x3456.RW2");
}
mod camera_dmc_fz8_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-FZ8", cam_dmc_fz8_iso_100_panasonic_raw_1_3072x2304_raw, "raw_modes/DMC-FZ8_ISO_100_Panasonic RAW 1_3072x2304.RAW");
}
mod camera_dmc_g10_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-G10", cam_dmc_g10_iso_200_panasonic_raw_1_4000x2672_rw2, "raw_modes/DMC-G10_ISO_200_Panasonic RAW 1_4000x2672.RW2");
  super::camera_file_check!("Panasonic", "DMC-G10", cam_dmc_g10_iso_200_panasonic_raw_1_4000x3000_rw2, "raw_modes/DMC-G10_ISO_200_Panasonic RAW 1_4000x3000.RW2");
  super::camera_file_check!("Panasonic", "DMC-G10", cam_dmc_g10_iso_200_panasonic_raw_1_2992x2992_rw2, "raw_modes/DMC-G10_ISO_200_Panasonic RAW 1_2992x2992.RW2");
  super::camera_file_check!("Panasonic", "DMC-G10", cam_dmc_g10_iso_200_panasonic_raw_1_4000x2248_rw2, "raw_modes/DMC-G10_ISO_200_Panasonic RAW 1_4000x2248.RW2");
}
mod camera_dmc_g1_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-G1", cam_dmc_g1_iso_100_panasonic_raw_1_4000x3000_rw2, "raw_modes/DMC-G1_ISO_100_Panasonic RAW 1_4000x3000.RW2");
}
mod camera_dmc_g2_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-G2", cam_dmc_g2_iso_400_4fmt_19x9_rw2, "raw_modes/DMC-G2_ISO_400_4fmt_19x9.RW2");
}
mod camera_dmc_g3_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-G3", cam_dmc_g3_iso_640_panasonic_raw_1_4576x2576_rw2, "raw_modes/DMC-G3_ISO_640_Panasonic RAW 1_4576x2576.RW2");
  super::camera_file_check!("Panasonic", "DMC-G3", cam_dmc_g3_iso_640_panasonic_raw_1_4576x3056_rw2, "raw_modes/DMC-G3_ISO_640_Panasonic RAW 1_4576x3056.RW2");
  super::camera_file_check!("Panasonic", "DMC-G3", cam_dmc_g3_iso_640_panasonic_raw_1_3424x3424_rw2, "raw_modes/DMC-G3_ISO_640_Panasonic RAW 1_3424x3424.RW2");
  super::camera_file_check!("Panasonic", "DMC-G3", cam_dmc_g3_iso_640_panasonic_raw_1_4592x3448_rw2, "raw_modes/DMC-G3_ISO_640_Panasonic RAW 1_4592x3448.RW2");
}
mod camera_dmc_g5_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-G5", cam_dmc_g5_iso_160_panasonic_raw_1_4608x3456_rw2, "raw_modes/DMC-G5_ISO_160_Panasonic RAW 1_4608x3456.RW2");
}
mod camera_dmc_g6_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-G6", cam_dmc_g6_iso_160_panasonic_raw_1_3456x3456_rw2, "raw_modes/DMC-G6_ISO_160_Panasonic RAW 1_3456x3456.RW2");
  super::camera_file_check!("Panasonic", "DMC-G6", cam_dmc_g6_iso_160_panasonic_raw_1_4608x3072_rw2, "raw_modes/DMC-G6_ISO_160_Panasonic RAW 1_4608x3072.RW2");
  super::camera_file_check!("Panasonic", "DMC-G6", cam_dmc_g6_iso_160_panasonic_raw_1_4608x3456_rw2, "raw_modes/DMC-G6_ISO_160_Panasonic RAW 1_4608x3456.RW2");
  super::camera_file_check!("Panasonic", "DMC-G6", cam_dmc_g6_iso_160_panasonic_raw_1_4608x2592_rw2, "raw_modes/DMC-G6_ISO_160_Panasonic RAW 1_4608x2592.RW2");
}
mod camera_dmc_g70_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-G70", cam_dmc_g70_iso_100_4fmt_4592x3448_rw2, "raw_modes/DMC-G70_ISO_100_4fmt_4592x3448.RW2");
}
mod camera_dmc_g7_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-G7", cam_dmc_g7_iso_200_4fmt_4x3_gbrg_rw2, "raw_modes/DMC-G7_ISO_200_4fmt_4x3_GBRG.RW2");
  super::camera_file_check!("Panasonic", "DMC-G7", cam_dmc_g7_iso_200_4fmt_4x3_bggr_rw2, "raw_modes/DMC-G7_ISO_200_4fmt_4x3_BGGR.RW2");
  super::camera_file_check!("Panasonic", "DMC-G7", cam_dmc_g7_iso_200_4fmt_16x9_rw2, "raw_modes/DMC-G7_ISO_200_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-G7", cam_dmc_g7_iso_200_4fmt_1x1_rw2, "raw_modes/DMC-G7_ISO_200_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-G7", cam_dmc_g7_iso_200_4fmt_4x3_rw2, "raw_modes/DMC-G7_ISO_200_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-G7", cam_dmc_g7_iso_200_4fmt_3x2_rw2, "raw_modes/DMC-G7_ISO_200_4fmt_3x2.RW2");
}
mod camera_dmc_g80_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-G80", cam_dmc_g80_iso_200_4fmt_1x1_rw2, "raw_modes/DMC-G80_ISO_200_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-G80", cam_dmc_g80_iso_200_4fmt_16x9_rw2, "raw_modes/DMC-G80_ISO_200_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-G80", cam_dmc_g80_iso_200_4fmt_3x2_rw2, "raw_modes/DMC-G80_ISO_200_4fmt_3x2.RW2");
}
mod camera_dmc_g81_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-G81", cam_dmc_g81_iso_400_4fmt_3x2_rw2, "raw_modes/DMC-G81_ISO_400_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-G81", cam_dmc_g81_iso_500_4fmt_16x9_rw2, "raw_modes/DMC-G81_ISO_500_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-G81", cam_dmc_g81_iso_400_4fmt_4x3_rw2, "raw_modes/DMC-G81_ISO_400_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-G81", cam_dmc_g81_iso_400_4fmt_1x1_rw2, "raw_modes/DMC-G81_ISO_400_4fmt_1x1.RW2");
}
mod camera_dmc_g85_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-G85", cam_dmc_g85_iso_320_4fmt_1x1_rw2, "raw_modes/DMC-G85_ISO_320_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-G85", cam_dmc_g85_iso_320_4fmt_16x9_rw2, "raw_modes/DMC-G85_ISO_320_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-G85", cam_dmc_g85_iso_320_4fmt_3x2_rw2, "raw_modes/DMC-G85_ISO_320_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-G85", cam_dmc_g85_iso_250_4fmt_4x3_rw2, "raw_modes/DMC-G85_ISO_250_4fmt_4x3.RW2");
}
mod camera_dmc_gf1_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GF1", cam_dmc_gf1_iso_100_panasonic_raw_1_4000x2248_rw2, "raw_modes/DMC-GF1_ISO_100_Panasonic RAW 1_4000x2248.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF1", cam_dmc_gf1_iso_100_panasonic_raw_1_2992x2992_rw2, "raw_modes/DMC-GF1_ISO_100_Panasonic RAW 1_2992x2992.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF1", cam_dmc_gf1_iso_100_panasonic_raw_1_4000x2672_rw2, "raw_modes/DMC-GF1_ISO_100_Panasonic RAW 1_4000x2672.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF1", cam_dmc_gf1_iso_100_panasonic_raw_1_4000x3000_rw2, "raw_modes/DMC-GF1_ISO_100_Panasonic RAW 1_4000x3000.RW2");
}
mod camera_dmc_gf2_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GF2", cam_dmc_gf2_iso_100_panasonic_raw_1_4000x2248_rw2, "raw_modes/DMC-GF2_ISO_100_Panasonic RAW 1_4000x2248.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF2", cam_dmc_gf2_iso_100_panasonic_raw_1_2992x2992_rw2, "raw_modes/DMC-GF2_ISO_100_Panasonic RAW 1_2992x2992.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF2", cam_dmc_gf2_iso_100_panasonic_raw_1_4000x3000_rw2, "raw_modes/DMC-GF2_ISO_100_Panasonic RAW 1_4000x3000.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF2", cam_dmc_gf2_iso_100_panasonic_raw_1_4000x2672_rw2, "raw_modes/DMC-GF2_ISO_100_Panasonic RAW 1_4000x2672.RW2");
}
mod camera_dmc_gf3_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GF3", cam_dmc_gf3_iso_160_panasonic_raw_1_4000x2248_rw2, "raw_modes/DMC-GF3_ISO_160_Panasonic RAW 1_4000x2248.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF3", cam_dmc_gf3_iso_160_panasonic_raw_1_4000x3000_rw2, "raw_modes/DMC-GF3_ISO_160_Panasonic RAW 1_4000x3000.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF3", cam_dmc_gf3_iso_160_panasonic_raw_1_4000x2672_rw2, "raw_modes/DMC-GF3_ISO_160_Panasonic RAW 1_4000x2672.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF3", cam_dmc_gf3_iso_160_panasonic_raw_1_2992x2992_rw2, "raw_modes/DMC-GF3_ISO_160_Panasonic RAW 1_2992x2992.RW2");
}
mod camera_dmc_gf5_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GF5", cam_dmc_gf5_iso_160_panasonic_raw_1_4000x3000_rw2, "raw_modes/DMC-GF5_ISO_160_Panasonic RAW 1_4000x3000.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF5", cam_dmc_gf5_iso_160_panasonic_raw_1_4000x2672_rw2, "raw_modes/DMC-GF5_ISO_160_Panasonic RAW 1_4000x2672.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF5", cam_dmc_gf5_iso_160_panasonic_raw_1_2992x2992_rw2, "raw_modes/DMC-GF5_ISO_160_Panasonic RAW 1_2992x2992.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF5", cam_dmc_gf5_iso_160_panasonic_raw_1_4000x2248_rw2, "raw_modes/DMC-GF5_ISO_160_Panasonic RAW 1_4000x2248.RW2");
}
mod camera_dmc_gf6_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GF6", cam_dmc_gf6_iso_160_panasonic_raw_1_4592x2584_rw2, "raw_modes/DMC-GF6_ISO_160_Panasonic RAW 1_4592x2584.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF6", cam_dmc_gf6_iso_160_panasonic_raw_1_3424x3424_rw2, "raw_modes/DMC-GF6_ISO_160_Panasonic RAW 1_3424x3424.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF6", cam_dmc_gf6_iso_160_panasonic_raw_1_4592x3448_rw2, "raw_modes/DMC-GF6_ISO_160_Panasonic RAW 1_4592x3448.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF6", cam_dmc_gf6_iso_160_panasonic_raw_1_4592x3064_rw2, "raw_modes/DMC-GF6_ISO_160_Panasonic RAW 1_4592x3064.RW2");
}
mod camera_dmc_gf7_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GF7", cam_dmc_gf7_iso_200_panasonic_raw_1_4592x3064_rw2, "raw_modes/DMC-GF7_ISO_200_Panasonic RAW 1_4592x3064.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF7", cam_dmc_gf7_iso_200_panasonic_raw_1_3424x3424_rw2, "raw_modes/DMC-GF7_ISO_200_Panasonic RAW 1_3424x3424.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF7", cam_dmc_gf7_iso_200_panasonic_raw_1_4592x3448_rw2, "raw_modes/DMC-GF7_ISO_200_Panasonic RAW 1_4592x3448.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF7", cam_dmc_gf7_iso_200_panasonic_raw_1_4592x2584_rw2, "raw_modes/DMC-GF7_ISO_200_Panasonic RAW 1_4592x2584.RW2");
}
mod camera_dmc_gf8_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GF8", cam_dmc_gf8_iso_200_4fmt_4592x3064_rw2, "raw_modes/DMC-GF8_ISO_200_4fmt_4592x3064.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF8", cam_dmc_gf8_iso_200_4fmt_4592x2584_rw2, "raw_modes/DMC-GF8_ISO_200_4fmt_4592x2584.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF8", cam_dmc_gf8_iso_200_4fmt_4592x3448_rw2, "raw_modes/DMC-GF8_ISO_200_4fmt_4592x3448.RW2");
  super::camera_file_check!("Panasonic", "DMC-GF8", cam_dmc_gf8_iso_200_4fmt_3424x3424_rw2, "raw_modes/DMC-GF8_ISO_200_4fmt_3424x3424.RW2");
}
mod camera_dmc_gh1_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GH1", cam_dmc_gh1_iso_100_panasonic_raw_1_4352x2448_rw2, "raw_modes/DMC-GH1_ISO_100_Panasonic RAW 1_4352x2448.RW2");
  super::camera_file_check!("Panasonic", "DMC-GH1", cam_dmc_gh1_iso_100_panasonic_raw_1_4128x2752_rw2, "raw_modes/DMC-GH1_ISO_100_Panasonic RAW 1_4128x2752.RW2");
  super::camera_file_check!("Panasonic", "DMC-GH1", cam_dmc_gh1_iso_100_panasonic_raw_1_4000x3000_rw2, "raw_modes/DMC-GH1_ISO_100_Panasonic RAW 1_4000x3000.RW2");
  super::camera_file_check!("Panasonic", "DMC-GH1", cam_dmc_gh1_iso_100_panasonic_raw_1_2992x2992_rw2, "raw_modes/DMC-GH1_ISO_100_Panasonic RAW 1_2992x2992.RW2");
}
mod camera_dmc_gh2_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GH2", cam_dmc_gh2_iso_160_panasonic_raw_1_4608x3456_rw2, "raw_modes/DMC-GH2_ISO_160_Panasonic RAW 1_4608x3456.RW2");
}
mod camera_dmc_gh3_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GH3", cam_dmc_gh3_iso_400_panasonic_raw_1_4608x2592_rw2, "raw_modes/DMC-GH3_ISO_400_Panasonic RAW 1_4608x2592.RW2");
  super::camera_file_check!("Panasonic", "DMC-GH3", cam_dmc_gh3_iso_400_panasonic_raw_1_4608x3456_rw2, "raw_modes/DMC-GH3_ISO_400_Panasonic RAW 1_4608x3456.RW2");
  super::camera_file_check!("Panasonic", "DMC-GH3", cam_dmc_gh3_iso_400_panasonic_raw_1_4608x3072_rw2, "raw_modes/DMC-GH3_ISO_400_Panasonic RAW 1_4608x3072.RW2");
  super::camera_file_check!("Panasonic", "DMC-GH3", cam_dmc_gh3_iso_400_panasonic_raw_1_3456x3456_rw2, "raw_modes/DMC-GH3_ISO_400_Panasonic RAW 1_3456x3456.RW2");
}
mod camera_dmc_gh4_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GH4", cam_dmc_gh4_iso_400_panasonic_raw_1_3456x3456_rw2, "raw_modes/DMC-GH4_ISO_400_Panasonic RAW 1_3456x3456.RW2");
  super::camera_file_check!("Panasonic", "DMC-GH4", cam_dmc_gh4_iso_400_panasonic_raw_1_4608x3072_rw2, "raw_modes/DMC-GH4_ISO_400_Panasonic RAW 1_4608x3072.RW2");
  super::camera_file_check!("Panasonic", "DMC-GH4", cam_dmc_gh4_iso_400_panasonic_raw_1_4608x3456_rw2, "raw_modes/DMC-GH4_ISO_400_Panasonic RAW 1_4608x3456.RW2");
  super::camera_file_check!("Panasonic", "DMC-GH4", cam_dmc_gh4_iso_400_panasonic_raw_1_4608x2592_rw2, "raw_modes/DMC-GH4_ISO_400_Panasonic RAW 1_4608x2592.RW2");
}
mod camera_dmc_gm1_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GM1", cam_dmc_gm1_iso_200_4fmt_4592x3064_rw2, "raw_modes/DMC-GM1_ISO_200_4fmt_4592x3064.RW2");
  super::camera_file_check!("Panasonic", "DMC-GM1", cam_dmc_gm1_iso_200_4fmt_3424x3424_rw2, "raw_modes/DMC-GM1_ISO_200_4fmt_3424x3424.RW2");
  super::camera_file_check!("Panasonic", "DMC-GM1", cam_dmc_gm1_iso_200_4fmt_4592x3448_rw2, "raw_modes/DMC-GM1_ISO_200_4fmt_4592x3448.RW2");
  super::camera_file_check!("Panasonic", "DMC-GM1", cam_dmc_gm1_iso_200_4fmt_4592x2584_rw2, "raw_modes/DMC-GM1_ISO_200_4fmt_4592x2584.RW2");
}
mod camera_dmc_gm1s_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GM1S", cam_dmc_gm1s_iso_200_panasonic_raw_1_4592x3448_rw2, "raw_modes/DMC-GM1S_ISO_200_Panasonic RAW 1_4592x3448.RW2");
}
mod camera_dmc_gm5_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GM5", cam_dmc_gm5_iso_400_panasonic_raw_1_4592x3064_rw2, "raw_modes/DMC-GM5_ISO_400_Panasonic RAW 1_4592x3064.RW2");
  super::camera_file_check!("Panasonic", "DMC-GM5", cam_dmc_gm5_iso_400_panasonic_raw_1_3424x3424_rw2, "raw_modes/DMC-GM5_ISO_400_Panasonic RAW 1_3424x3424.RW2");
  super::camera_file_check!("Panasonic", "DMC-GM5", cam_dmc_gm5_iso_400_panasonic_raw_1_4592x3448_rw2, "raw_modes/DMC-GM5_ISO_400_Panasonic RAW 1_4592x3448.RW2");
  super::camera_file_check!("Panasonic", "DMC-GM5", cam_dmc_gm5_iso_400_panasonic_raw_1_4592x2584_rw2, "raw_modes/DMC-GM5_ISO_400_Panasonic RAW 1_4592x2584.RW2");
}
mod camera_dmc_gx1_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GX1", cam_dmc_gx1_iso_320_panasonic_raw_1_4576x3056_rw2, "raw_modes/DMC-GX1_ISO_320_Panasonic RAW 1_4576x3056.RW2");
}
mod camera_dmc_gx7mk2_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GX7MK2", cam_dmc_gx7mk2_iso_2500_4fmt_16x9_rw2, "raw_modes/DMC-GX7MK2_ISO_2500_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX7MK2", cam_dmc_gx7mk2_iso_2500_4fmt_3x2_rw2, "raw_modes/DMC-GX7MK2_ISO_2500_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX7MK2", cam_dmc_gx7mk2_iso_2500_4fmt_1x1_rw2, "raw_modes/DMC-GX7MK2_ISO_2500_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX7MK2", cam_dmc_gx7mk2_iso_2500_4fmt_4x3_rw2, "raw_modes/DMC-GX7MK2_ISO_2500_4fmt_4x3.RW2");
}
mod camera_dmc_gx7_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GX7", cam_dmc_gx7_iso_125_panasonic_raw_1_4592x2584_rw2, "raw_modes/DMC-GX7_ISO_125_Panasonic RAW 1_4592x2584.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX7", cam_dmc_gx7_iso_125_panasonic_raw_1_4592x3448_rw2, "raw_modes/DMC-GX7_ISO_125_Panasonic RAW 1_4592x3448.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX7", cam_dmc_gx7_iso_125_panasonic_raw_1_3424x3424_rw2, "raw_modes/DMC-GX7_ISO_125_Panasonic RAW 1_3424x3424.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX7", cam_dmc_gx7_iso_125_panasonic_raw_1_4592x3064_rw2, "raw_modes/DMC-GX7_ISO_125_Panasonic RAW 1_4592x3064.RW2");
}
mod camera_dmc_gx80_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GX80", cam_dmc_gx80_iso_200_4fmt_16x9_rw2, "raw_modes/DMC-GX80_ISO_200_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX80", cam_dmc_gx80_iso_200_4fmt_4x3_rw2, "raw_modes/DMC-GX80_ISO_200_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX80", cam_dmc_gx80_iso_200_4fmt_1x1_rw2, "raw_modes/DMC-GX80_ISO_200_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX80", cam_dmc_gx80_iso_200_4fmt_3x2_rw2, "raw_modes/DMC-GX80_ISO_200_4fmt_3x2.RW2");
}
mod camera_dmc_gx85_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GX85", cam_dmc_gx85_iso_200_4fmt_16x9_rw2, "raw_modes/DMC-GX85_ISO_200_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX85", cam_dmc_gx85_iso_200_4fmt_4x3_rw2, "raw_modes/DMC-GX85_ISO_200_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX85", cam_dmc_gx85_iso_200_4fmt_1x1_rw2, "raw_modes/DMC-GX85_ISO_200_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX85", cam_dmc_gx85_iso_200_4fmt_3x2_rw2, "raw_modes/DMC-GX85_ISO_200_4fmt_3x2.RW2");
}
mod camera_dmc_gx8_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-GX8", cam_dmc_gx8_iso_200_4fmt_16x9_rw2, "raw_modes/DMC-GX8_ISO_200_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX8", cam_dmc_gx8_iso_200_4fmt_3x2_rw2, "raw_modes/DMC-GX8_ISO_200_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX8", cam_dmc_gx8_iso_200_4fmt_1x1_rw2, "raw_modes/DMC-GX8_ISO_200_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-GX8", cam_dmc_gx8_iso_200_4fmt_4x3_rw2, "raw_modes/DMC-GX8_ISO_200_4fmt_4x3.RW2");
}
mod camera_dmc_l10_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-L10", cam_dmc_l10_iso_100_3fmt_3648x2736_raw, "raw_modes/DMC-L10_ISO_100_3fmt_3648x2736.RAW");
}
mod camera_dmc_l1_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-L1", cam_dmc_l1_iso_100_panasonic_raw_4_3136x2352_raw, "raw_modes/DMC-L1_ISO_100_Panasonic RAW 4_3136x2352.RAW");
}
mod camera_dmc_lf1_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-LF1", cam_dmc_lf1_iso_80_4fmt_4000x2672_rw2, "raw_modes/DMC-LF1_ISO_80_4fmt_4000x2672.RW2");
  super::camera_file_check!("Panasonic", "DMC-LF1", cam_dmc_lf1_iso_80_4fmt_4000x3000_rw2, "raw_modes/DMC-LF1_ISO_80_4fmt_4000x3000.RW2");
}
mod camera_dmc_lx100_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-LX100", cam_dmc_lx100_iso_500_panasonic_raw_1_4272x2856_rw2, "raw_modes/DMC-LX100_ISO_500_Panasonic RAW 1_4272x2856.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX100", cam_dmc_lx100_iso_500_panasonic_raw_1_3088x3088_rw2, "raw_modes/DMC-LX100_ISO_500_Panasonic RAW 1_3088x3088.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX100", cam_dmc_lx100_iso_500_panasonic_raw_1_4112x3088_rw2, "raw_modes/DMC-LX100_ISO_500_Panasonic RAW 1_4112x3088.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX100", cam_dmc_lx100_iso_500_panasonic_raw_1_4480x2520_rw2, "raw_modes/DMC-LX100_ISO_500_Panasonic RAW 1_4480x2520.RW2");
}
mod camera_dmc_lx10_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-LX10", cam_dmc_lx10_iso_160_3x2_rw2, "raw_modes/DMC-LX10_ISO_160_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX10", cam_dmc_lx10_iso_160_1x1_rw2, "raw_modes/DMC-LX10_ISO_160_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX10", cam_dmc_lx10_iso_160_4x3_rw2, "raw_modes/DMC-LX10_ISO_160_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX10", cam_dmc_lx10_iso_160_16x9_rw2, "raw_modes/DMC-LX10_ISO_160_16x9.RW2");
}
mod camera_dmc_lx15_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-LX15", cam_dmc_lx15_iso_125_4fmt_16x9_rw2, "raw_modes/DMC-LX15_ISO_125_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX15", cam_dmc_lx15_iso_125_4fmt_3x2_rw2, "raw_modes/DMC-LX15_ISO_125_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX15", cam_dmc_lx15_iso_125_4fmt_1x1_rw2, "raw_modes/DMC-LX15_ISO_125_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX15", cam_dmc_lx15_iso_125_4fmt_4x3_rw2, "raw_modes/DMC-LX15_ISO_125_4fmt_4x3.RW2");
}
mod camera_dmc_lx1_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-LX1", cam_dmc_lx1_iso_100_panasonic_raw_3_3840x2160_raw, "raw_modes/DMC-LX1_ISO_100_Panasonic RAW 3_3840x2160.RAW");
}
mod camera_dmc_lx2_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-LX2", cam_dmc_lx2_iso_100_panasonic_raw_3_4224x2376_raw, "raw_modes/DMC-LX2_ISO_100_Panasonic RAW 3_4224x2376.RAW");
}
mod camera_dmc_lx3_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-LX3", cam_dmc_lx3_iso_400_4fmt_3968x2232_rw2, "raw_modes/DMC-LX3_ISO_400_4fmt_3968x2232.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX3", cam_dmc_lx3_iso_80_4fmt_2736x2736_rw2, "raw_modes/DMC-LX3_ISO_80_4fmt_2736x2736.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX3", cam_dmc_lx3_iso_400_4fmt_3648x2736_rw2, "raw_modes/DMC-LX3_ISO_400_4fmt_3648x2736.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX3", cam_dmc_lx3_iso_100_4fmt_3968x2232_rw2, "raw_modes/DMC-LX3_ISO_100_4fmt_3968x2232.RW2");
}
mod camera_dmc_lx5_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-LX5", cam_dmc_lx5_iso_80_panasonic_raw_1_3648x2736_rw2, "raw_modes/DMC-LX5_ISO_80_Panasonic RAW 1_3648x2736.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX5", cam_dmc_lx5_iso_80_panasonic_raw_1_2736x2736_rw2, "raw_modes/DMC-LX5_ISO_80_Panasonic RAW 1_2736x2736.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX5", cam_dmc_lx5_iso_80_panasonic_raw_1_3776x2520_rw2, "raw_modes/DMC-LX5_ISO_80_Panasonic RAW 1_3776x2520.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX5", cam_dmc_lx5_iso_80_panasonic_raw_1_3968x2232_rw2, "raw_modes/DMC-LX5_ISO_80_Panasonic RAW 1_3968x2232.RW2");
}
mod camera_dmc_lx7_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-LX7", cam_dmc_lx7_iso_100_panasonic_raw_1_3968x2232_rw2, "raw_modes/DMC-LX7_ISO_100_Panasonic RAW 1_3968x2232.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX7", cam_dmc_lx7_iso_100_panasonic_raw_1_3776x2520_rw2, "raw_modes/DMC-LX7_ISO_100_Panasonic RAW 1_3776x2520.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX7", cam_dmc_lx7_iso_100_panasonic_raw_1_3648x2736_rw2, "raw_modes/DMC-LX7_ISO_100_Panasonic RAW 1_3648x2736.RW2");
  super::camera_file_check!("Panasonic", "DMC-LX7", cam_dmc_lx7_iso_100_panasonic_raw_1_2736x2736_rw2, "raw_modes/DMC-LX7_ISO_100_Panasonic RAW 1_2736x2736.RW2");
}
mod camera_dmc_tx1_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-TX1", cam_dmc_tx1_iso_125_4fmt_3x2_rw2, "raw_modes/DMC-TX1_ISO_125_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-TX1", cam_dmc_tx1_iso_125_4fmt_4x3_rw2, "raw_modes/DMC-TX1_ISO_125_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-TX1", cam_dmc_tx1_iso_125_4fmt_1x1_rw2, "raw_modes/DMC-TX1_ISO_125_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-TX1", cam_dmc_tx1_iso_125_4fmt_16x9_rw2, "raw_modes/DMC-TX1_ISO_125_4fmt_16x9.RW2");
}
mod camera_dmc_tz100_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-TZ100", cam_dmc_tz100_iso_640_4fmt_1x1_rw2, "raw_modes/DMC-TZ100_ISO_640_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ100", cam_dmc_tz100_iso_640_4fmt_4x2_rw2, "raw_modes/DMC-TZ100_ISO_640_4fmt_4x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ100", cam_dmc_tz100_iso_640_4fmt_16x9_rw2, "raw_modes/DMC-TZ100_ISO_640_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ100", cam_dmc_tz100_iso_640_4fmt_3x2_rw2, "raw_modes/DMC-TZ100_ISO_640_4fmt_3x2.RW2");
}
mod camera_dmc_tz101_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-TZ101", cam_dmc_tz101_iso_125_4fmt_5472x3648_rw2, "raw_modes/DMC-TZ101_ISO_125_4fmt_5472x3648.RW2");
}
mod camera_dmc_tz110_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-TZ110", cam_dmc_tz110_iso_200_4fmt_3x2_rw2, "raw_modes/DMC-TZ110_ISO_200_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ110", cam_dmc_tz110_iso_200_4fmt_1x1_rw2, "raw_modes/DMC-TZ110_ISO_200_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ110", cam_dmc_tz110_iso_200_4fmt_4x3_rw2, "raw_modes/DMC-TZ110_ISO_200_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ110", cam_dmc_tz110_iso_200_4fmt_16x9_rw2, "raw_modes/DMC-TZ110_ISO_200_4fmt_16x9.RW2");
}
mod camera_dmc_tz60_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-TZ60", cam_dmc_tz60_iso_200_panasonic_raw_1_4896x3672_rw2, "raw_modes/DMC-TZ60_ISO_200_Panasonic RAW 1_4896x3672.RW2");
}
mod camera_dmc_tz61_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-TZ61", cam_dmc_tz61_iso_400_panasonic_raw_1_3672x3672_rw2, "raw_modes/DMC-TZ61_ISO_400_Panasonic RAW 1_3672x3672.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ61", cam_dmc_tz61_iso_400_panasonic_raw_1_4896x2754_rw2, "raw_modes/DMC-TZ61_ISO_400_Panasonic RAW 1_4896x2754.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ61", cam_dmc_tz61_iso_400_panasonic_raw_1_4896x3672_rw2, "raw_modes/DMC-TZ61_ISO_400_Panasonic RAW 1_4896x3672.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ61", cam_dmc_tz61_iso_400_panasonic_raw_1_4896x3264_rw2, "raw_modes/DMC-TZ61_ISO_400_Panasonic RAW 1_4896x3264.RW2");
}
mod camera_dmc_tz70_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-TZ70", cam_dmc_tz70_iso_80_panasonic_raw_1_4000x2248_rw2, "raw_modes/DMC-TZ70_ISO_80_Panasonic RAW 1_4000x2248.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ70", cam_dmc_tz70_iso_80_panasonic_raw_1_2992x2992_rw2, "raw_modes/DMC-TZ70_ISO_80_Panasonic RAW 1_2992x2992.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ70", cam_dmc_tz70_iso_80_panasonic_raw_1_4000x3000_rw2, "raw_modes/DMC-TZ70_ISO_80_Panasonic RAW 1_4000x3000.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ70", cam_dmc_tz70_iso_80_panasonic_raw_1_4000x2672_rw2, "raw_modes/DMC-TZ70_ISO_80_Panasonic RAW 1_4000x2672.RW2");
}
mod camera_dmc_tz71_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-TZ71", cam_dmc_tz71_iso_80_panasonic_raw_1_4000x3000_rw2, "raw_modes/DMC-TZ71_ISO_80_Panasonic RAW 1_4000x3000.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ71", cam_dmc_tz71_iso_80_panasonic_raw_1_4000x2672_rw2, "raw_modes/DMC-TZ71_ISO_80_Panasonic RAW 1_4000x2672.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ71", cam_dmc_tz71_iso_80_panasonic_raw_1_2992x2992_rw2, "raw_modes/DMC-TZ71_ISO_80_Panasonic RAW 1_2992x2992.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ71", cam_dmc_tz71_iso_80_panasonic_raw_1_4000x2248_rw2, "raw_modes/DMC-TZ71_ISO_80_Panasonic RAW 1_4000x2248.RW2");
}
mod camera_dmc_tz80_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-TZ80", cam_dmc_tz80_iso_1600_4fmt_3x2_rw2, "raw_modes/DMC-TZ80_ISO_1600_4fmt_3x2.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ80", cam_dmc_tz80_iso_1600_4fmt_16x9_rw2, "raw_modes/DMC-TZ80_ISO_1600_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ80", cam_dmc_tz80_iso_1600_4fmt_4x3_rw2, "raw_modes/DMC-TZ80_ISO_1600_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ80", cam_dmc_tz80_iso_1600_4fmt_1x1_rw2, "raw_modes/DMC-TZ80_ISO_1600_4fmt_1x1.RW2");
}
mod camera_dmc_tz81_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-TZ81", cam_dmc_tz81_iso_80_4fmt_4x3_rw2, "raw_modes/DMC-TZ81_ISO_80_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ81", cam_dmc_tz81_iso_80_4fmt_1x1_rw2, "raw_modes/DMC-TZ81_ISO_80_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ81", cam_dmc_tz81_iso_80_4fmt_16x9_rw2, "raw_modes/DMC-TZ81_ISO_80_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-TZ81", cam_dmc_tz81_iso_80_4fmt_3x2_rw2, "raw_modes/DMC-TZ81_ISO_80_4fmt_3x2.RW2");
}
mod camera_dmc_zs100_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-ZS100", cam_dmc_zs100_iso_125_4fmt_4x3_rw2, "raw_modes/DMC-ZS100_ISO_125_4fmt_4x3.RW2");
  super::camera_file_check!("Panasonic", "DMC-ZS100", cam_dmc_zs100_iso_125_4fmt_1x1_rw2, "raw_modes/DMC-ZS100_ISO_125_4fmt_1x1.RW2");
  super::camera_file_check!("Panasonic", "DMC-ZS100", cam_dmc_zs100_iso_125_4fmt_16x9_rw2, "raw_modes/DMC-ZS100_ISO_125_4fmt_16x9.RW2");
  super::camera_file_check!("Panasonic", "DMC-ZS100", cam_dmc_zs100_iso_125_4fmt_3x2_rw2, "raw_modes/DMC-ZS100_ISO_125_4fmt_3x2.RW2");
}
mod camera_dmc_zs40_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-ZS40", cam_dmc_zs40_iso_100_panasonic_raw_1_4896x3672_rw2, "raw_modes/DMC-ZS40_ISO_100_Panasonic RAW 1_4896x3672.RW2");
}
mod camera_dmc_zs60_raw_modes {
  super::camera_file_check!("Panasonic", "DMC-ZS60", cam_dmc_zs60_iso_400_panasonic_raw_1_4896x3672_rw2, "raw_modes/DMC-ZS60_ISO_400_Panasonic RAW 1_4896x3672.RW2");
}
mod camera_sigma_fp_cinemadng {
  super::camera_file_check!("Sigma", "SIGMA fp", cam_sigma_fp_6k_14bit_dng, "cinemadng/SIGMA_FP_6k_14bit.DNG");
  super::camera_file_check!("Sigma", "SIGMA fp", cam_sigma_fp_653_20240229_000001_2k_8bit_dng, "cinemadng/SIGMA_FP_653_20240229_000001_2k_8bit.DNG");
  super::camera_file_check!("Sigma", "SIGMA fp", cam_sigma_fp_648_20240229_000001_4k_10bit_dng, "cinemadng/SIGMA_FP_648_20240229_000001_4k_10bit.DNG");
  super::camera_file_check!("Sigma", "SIGMA fp", cam_sigma_fp_647_20240229_000001_4k_12bit_dng, "cinemadng/SIGMA_FP_647_20240229_000001_4k_12bit.DNG");
  super::camera_file_check!("Sigma", "SIGMA fp", cam_sigma_fp_652_20240229_000001_2k_10bit_dng, "cinemadng/SIGMA_FP_652_20240229_000001_2k_10bit.DNG");
  super::camera_file_check!("Sigma", "SIGMA fp", cam_sigma_fp_650_20240229_000001_4k_8bit_dng, "cinemadng/SIGMA_FP_650_20240229_000001_4k_8bit.DNG");
  super::camera_file_check!("Sigma", "SIGMA fp", cam_sigma_fp_651_20240229_000001_2k_12bit_dng, "cinemadng/SIGMA_FP_651_20240229_000001_2k_12bit.DNG");
}
mod camera_c_lux_raw_modes {
  super::camera_file_check!("Leica", "C-Lux", cam_c_lux_iso_125_4fmt_5472x3648_rwl, "raw_modes/C-Lux_ISO_125_4fmt_5472x3648.RWL");
}
mod camera_c_typ_112_raw_modes {
  super::camera_file_check!("Leica", "C Typ 112", cam_c_typ_112_iso_80_4fmt_3x2_rwl, "raw_modes/C Typ 112_ISO_80_4fmt_3x2.RWL");
  super::camera_file_check!("Leica", "C Typ 112", cam_c_typ_112_iso_640_4fmt_4x3_rwl, "raw_modes/C Typ 112_ISO_640_4fmt_4x3.RWL");
}
mod camera_digilux_2_raw_modes {
  super::camera_file_check!("Leica", "Digilux 2", cam_digilux_2_iso_100_raw, "raw_modes/DIGILUX 2_ISO_100.RAW");
}
mod camera_digilux_3_raw_modes {
  super::camera_file_check!("Leica", "Digilux 3", cam_digilux_3_iso_100_raw, "raw_modes/DIGILUX 3_ISO_100.RAW");
}
mod camera_d_lux_3_raw_modes {
  super::camera_file_check!("Leica", "D-LUX 3", cam_raw_leica_dlux3_raw, "raw_modes/RAW_LEICA_DLUX3.RAW");
}
mod camera_d_lux_4_raw_modes {
  super::camera_file_check!("Leica", "D-LUX 4", cam_d_lux_4_iso_80_4fmt_3x2_rwl, "raw_modes/D-LUX 4_ISO_80_4fmt_3x2.RWL");
}
mod camera_d_lux_5_raw_modes {
  super::camera_file_check!("Leica", "D-LUX 5", cam_d_lux_5_iso_80_4fmt_3x2_rwl, "raw_modes/D-LUX 5_ISO_80_4fmt_3x2.RWL");
  super::camera_file_check!("Leica", "D-LUX 5", cam_d_lux_5_iso_80_4fmt_16x9_rwl, "raw_modes/D-LUX 5_ISO_80_4fmt_16x9.RWL");
  super::camera_file_check!("Leica", "D-LUX 5", cam_d_lux_5_iso_80_4fmt_1x1_rwl, "raw_modes/D-LUX 5_ISO_80_4fmt_1x1.RWL");
  super::camera_file_check!("Leica", "D-LUX 5", cam_d_lux_5_iso_80_4fmt_4x3_rwl, "raw_modes/D-LUX 5_ISO_80_4fmt_4x3.RWL");
}
mod camera_d_lux_7_raw_modes {
  super::camera_file_check!("Leica", "D-LUX 7", cam_d_lux_7_iso_200_4fmt_4x3_rwl, "raw_modes/D-Lux 7_ISO_200_4fmt_4x3.RWL");
}
mod camera_d_lux_typ_109_raw_modes {
  super::camera_file_check!("Leica", "D-LUX Typ 109", cam_d_lux_typ_109_iso_500_4fmt_16x9_rwl, "raw_modes/D-LUX Typ 109_ISO_500_4fmt_16x9.RWL");
  super::camera_file_check!("Leica", "D-LUX Typ 109", cam_d_lux_typ_109_iso_500_4fmt_3x2_rwl, "raw_modes/D-LUX Typ 109_ISO_500_4fmt_3x2.RWL");
  super::camera_file_check!("Leica", "D-LUX Typ 109", cam_d_lux_typ_109_iso_640_4fmt_1x1_rwl, "raw_modes/D-LUX Typ 109_ISO_640_4fmt_1x1.RWL");
  super::camera_file_check!("Leica", "D-LUX Typ 109", cam_d_lux_typ_109_iso_640_4fmt_4x3_rwl, "raw_modes/D-LUX Typ 109_ISO_640_4fmt_4x3.RWL");
}
mod camera_v_lux_1_raw_modes {
  super::camera_file_check!("Leica", "V-LUX 1", cam_v_lux_1_iso_100_raw, "raw_modes/V-LUX 1_ISO_100.RAW");
}
mod camera_v_lux_4_raw_modes {
  super::camera_file_check!("Leica", "V-LUX 4", cam_v_lux_4_iso_100_4fmt_4000x3000_rwl, "raw_modes/V-LUX 4_ISO_100_4fmt_4000x3000.RWL");
}
mod camera_v_lux_5_raw_modes {
  super::camera_file_check!("Leica", "V-LUX 5", cam_v_lux_5_iso_125_4fmt_5472x3648_rwl, "raw_modes/V-Lux 5_ISO_125_4fmt_5472x3648.RWL");
}
mod camera_v_lux_typ_114_raw_modes {
  super::camera_file_check!("Leica", "V-LUX Typ 114", cam_v_lux_typ_114_iso_125_4fmt_3x2_rwl, "raw_modes/V-LUX Typ 114_ISO_125_4fmt_3x2.RWL");
  super::camera_file_check!("Leica", "V-LUX Typ 114", cam_v_lux_typ_114_iso_125_4fmt_16x9_rwl, "raw_modes/V-LUX Typ 114_ISO_125_4fmt_16x9.RWL");
  super::camera_file_check!("Leica", "V-LUX Typ 114", cam_v_lux_typ_114_iso_125_4fmt_1x1_rwl, "raw_modes/V-LUX Typ 114_ISO_125_4fmt_1x1.RWL");
  super::camera_file_check!("Leica", "V-LUX Typ 114", cam_v_lux_typ_114_iso_125_4fmt_4x3_rwl, "raw_modes/V-LUX Typ 114_ISO_125_4fmt_4x3.RWL");
}
mod camera_dbp_for_gx680_raw_modes {
  super::camera_file_check!("Fujifilm", "DBP for GX680", cam_dbp_for_gx680_iso_100_raf, "raw_modes/DBP for GX680_ISO_100.RAF");
}
mod camera_finepix_e550_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix E550", cam_finepix_e550_iso_200_raf, "raw_modes/FinePix E550_ISO_200.RAF");
}
mod camera_finepix_e900_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix E900", cam_finepix_e900_iso_80_raf, "raw_modes/FinePix E900_ISO_80.RAF");
}
mod camera_finepix_f550exr_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix F550EXR", cam_finepix_f550exr_iso_400_raf, "raw_modes/FinePix F550EXR_ISO_400.RAF");
}
mod camera_finepix_f600exr_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix F600EXR", cam_finepix_f600exr_iso_100_raf, "raw_modes/FinePix F600EXR_ISO_100.RAF");
}
mod camera_finepix_f700_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix F700", cam_finepix_f700_iso_200_raf, "raw_modes/FinePix F700_ISO_200.RAF");
}
mod camera_finepix_f770exr_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix F770EXR", cam_finepix_f770exr_iso_100_raf, "raw_modes/FinePix F770EXR_ISO_100.RAF");
}
mod camera_finepix_f900exr_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix F900EXR", cam_finepix_f900exr_iso_400_raf, "raw_modes/FinePix F900EXR_ISO_400.RAF");
}
mod camera_finepix_hs10_hs11_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix HS10 HS11", cam_finepix_hs10_hs11_iso_200_raf, "raw_modes/FinePix HS10 HS11_ISO_200.RAF");
}
mod camera_finepix_hs20exr_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix HS20EXR", cam_finepix_hs20exr_iso_100_raf, "raw_modes/FinePix HS20EXR_ISO_100.RAF");
}
mod camera_finepix_hs30exr_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix HS30EXR", cam_finepix_hs30exr_iso_400_raf, "raw_modes/FinePix HS30EXR_ISO_400.RAF");
}
mod camera_finepix_hs33exr_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix HS33EXR", cam_finepix_hs33exr_iso_100_raf, "raw_modes/FinePix HS33EXR_ISO_100.RAF");
}
mod camera_finepix_hs50exr_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix HS50EXR", cam_finepix_hs50exr_iso_100_raf, "raw_modes/FinePix HS50EXR_ISO_100.RAF");
}
mod camera_finepix_s100fs_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S100FS", cam_finepix_s100fs_iso_100_raf, "raw_modes/FinePix S100FS_ISO_100.RAF");
}
mod camera_finepix_sl1000_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix SL1000", cam_finepix_sl1000_iso_100_12bits_raf, "raw_modes/FinePix SL1000_ISO_100_12bits.RAF");
}
mod camera_finepix_s1_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S1", cam_finepix_s1_iso_200_raf, "raw_modes/FinePix S1_ISO_200.RAF");
}
mod camera_finepix_s200exr_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S200EXR", cam_finepix_s200exr_iso_100_raf, "raw_modes/FinePix S200EXR_ISO_100.RAF");
}
mod camera_finepix_s2pro_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S2Pro", cam_finepixs2pro_iso_100_raf, "raw_modes/FinePixS2Pro_ISO_100.RAF");
}
mod camera_finepix_s3pro_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S3Pro", cam_finepix_s3pro_iso_100_raf, "raw_modes/FinePix S3Pro_ISO_100.RAF");
}
mod camera_finepix_s5000_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S5000", cam_finepix_s5000_iso_200_raf, "raw_modes/FinePix S5000_ISO_200.RAF");
}
mod camera_finepix_s5200_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S5200", cam_finepix_s5200_iso_64_raf, "raw_modes/FinePix S5200_ISO_64.RAF");
}
mod camera_finepix_s5500_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S5500", cam_finepix_s5500_iso_100_raf, "raw_modes/FinePix S5500_ISO_100.RAF");
}
mod camera_finepix_s5600_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S5600", cam_finepix_s5600_iso_64_raf, "raw_modes/FinePix S5600_ISO_64.RAF");
}
mod camera_finepix_s5pro_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S5Pro", cam_finepix_s5pro_iso_100_raf, "raw_modes/FinePix S5Pro_ISO_100.RAF");
}
mod camera_finepix_s6500fd_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S6500fd", cam_finepix_s6500fd_iso_100_raf, "raw_modes/FinePix S6500fd_ISO_100.RAF");
}
mod camera_finepix_s7000_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S7000", cam_finepix_s7000_iso_200_raf, "raw_modes/FinePix S7000_ISO_200.RAF");
}
mod camera_finepix_s9500_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S9500", cam_finepix_s9500_iso_80_raf, "raw_modes/FinePix S9500_ISO_80.RAF");
}
mod camera_finepix_s9600_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix S9600", cam_finepix_s9600_iso_200_raf, "raw_modes/FinePix S9600_ISO_200.RAF");
}
mod camera_finepix_x100_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix X100", cam_finepix_x100_iso_400_raf, "raw_modes/FinePix X100_ISO_400.RAF");
}
mod camera_finepix_x10_raw_modes {
  super::camera_file_check!("Fujifilm", "FinePix X10", cam_x10_iso_200_raf, "raw_modes/X10_ISO_200.RAF");
}
mod camera_gfx_100_compressed {
  super::camera_file_check!("Fujifilm", "GFX 100", cam_gfx_100_iso_100_bitdepth_16_124_mib_raf, "compressed/GFX 100_ISO_100_Bitdepth_16_124 MiB.RAF");
  super::camera_file_check!("Fujifilm", "GFX 100", cam_gfx_100_iso_100_bitdepth_14_101_mib_raf, "compressed/GFX 100_ISO_100_Bitdepth_14_101 MiB.RAF");
}
mod camera_gfx_100_raw_modes {
  super::camera_file_check!("Fujifilm", "GFX 100", cam_gfx_100_iso_100_bitdepth_14_200_mib_raf, "raw_modes/GFX 100_ISO_100_Bitdepth_14_200 MiB.RAF");
  super::camera_file_check!("Fujifilm", "GFX 100", cam_gfx_100_iso_100_bitdepth_16_200_mib_raf, "raw_modes/GFX 100_ISO_100_Bitdepth_16_200 MiB.RAF");
}
mod camera_gfx_100_ii_raw_modes {
  super::camera_file_check!("Fujifilm", "GFX 100 II", cam_gfx100_ii_14bits_lossy_4x3_raf, "raw_modes/GFX100_II_14bits_lossy_4x3.RAF");
  super::camera_file_check!("Fujifilm", "GFX 100 II", cam_gfx100_ii_14bits_lossless_4x3_raf, "raw_modes/GFX100_II_14bits_lossless_4x3.RAF");
  super::camera_file_check!("Fujifilm", "GFX 100 II", cam_gfx100_ii_14bits_uncompressed_4x3_raf, "raw_modes/GFX100_II_14bits_uncompressed_4x3.RAF");
  super::camera_file_check!("Fujifilm", "GFX 100 II", cam_gfx100_ii_16bits_lossy_4x3_raf, "raw_modes/GFX100_II_16bits_lossy_4x3.RAF");
  super::camera_file_check!("Fujifilm", "GFX 100 II", cam_gfx100_ii_16bits_lossless_4x3_raf, "raw_modes/GFX100_II_16bits_lossless_4x3.RAF");
}
mod camera_gfx100s_compressed {
  super::camera_file_check!("Fujifilm", "GFX100S", cam_fujifilm_gfx100s_16bits_compress_4_3_raf, "compressed/Fujifilm-GFX100S-16bits-compress-4_3.RAF");
  super::camera_file_check!("Fujifilm", "GFX100S", cam_fujifilm_gfx100s_16bits_losslesscompressed_4_3_raf, "compressed/Fujifilm-GFX100S-16bits-losslesscompressed-4_3.RAF");
  super::camera_file_check!("Fujifilm", "GFX100S", cam_fujifilm_gfx100s_14bits_losslescompressed_4_3_raf, "compressed/Fujifilm-GFX100S-14bits-losslescompressed-4_3.RAF");
  super::camera_file_check!("Fujifilm", "GFX100S", cam_fujifilm_gfx100s_14bits_compress_4_3_raf, "compressed/Fujifilm-GFX100S-14bits-compress-4_3.RAF");
}
mod camera_gfx100s_raw_modes {
  super::camera_file_check!("Fujifilm", "GFX100S", cam_fujifilm_gfx100s_16bits_uncompress_4_3_raf, "raw_modes/Fujifilm-GFX100S-16bits-uncompress-4_3.RAF");
  super::camera_file_check!("Fujifilm", "GFX100S", cam_fujifilm_gfx100s_14bits_uncompress_4_3_raf, "raw_modes/Fujifilm-GFX100S-14bits-uncompress-4_3.RAF");
}
mod camera_gfx_50r_compressed {
  super::camera_file_check!("Fujifilm", "GFX 50R", cam_gfx_50r_iso_100_bitdepth_14_50_mib_raf, "compressed/GFX 50R_ISO_100_Bitdepth_14_50 MiB.RAF");
}
mod camera_gfx_50r_raw_modes {
  super::camera_file_check!("Fujifilm", "GFX 50R", cam_gfx_50r_iso_100_bitdepth_14_112_mib_raf, "raw_modes/GFX 50R_ISO_100_Bitdepth_14_112 MiB.RAF");
}
mod camera_gfx_50s_compressed {
  super::camera_file_check!("Fujifilm", "GFX 50S", cam_gfx_50s_iso_100_bitdepth_14_48_mib_raf, "compressed/GFX 50S_ISO_100_Bitdepth_14_48 MiB.RAF");
}
mod camera_gfx50s_ii_compressed {
  super::camera_file_check!("Fujifilm", "GFX50S II", cam_fuji_gfx50s_ii___compressed_raf, "compressed/Fuji_GFX50S_II_-_Compressed.RAF");
  super::camera_file_check!("Fujifilm", "GFX50S II", cam_fuji_gfx50s_ii___lossless_compressed_raf, "compressed/Fuji_GFX50S_II_-_Lossless_Compressed.RAF");
}
mod camera_gfx50s_ii_raw_modes {
  super::camera_file_check!("Fujifilm", "GFX50S II", cam_fuji_gfx50s_ii___uncompressed_raf, "raw_modes/Fuji_GFX50S_II_-_Uncompressed.RAF");
}
mod camera_gfx_50s_raw_modes {
  super::camera_file_check!("Fujifilm", "GFX 50S", cam_gfx_50s_iso_100_bitdepth_14_111_mib_raf, "raw_modes/GFX 50S_ISO_100_Bitdepth_14_111 MiB.RAF");
}
mod camera_x100f_compressed {
  super::camera_file_check!("Fujifilm", "X100F", cam_x100f_lossless_compressed_raw_temple_raf, "compressed/X100F_lossless_compressed_raw_Temple.RAF");
}
mod camera_x100f_raw_modes {
  super::camera_file_check!("Fujifilm", "X100F", cam_x100f_uncompressed_raw_temple_raf, "raw_modes/X100F_uncompressed_raw_Temple.RAF");
}
mod camera_x100s_raw_modes {
  super::camera_file_check!("Fujifilm", "X100S", cam_x100s_iso_200_bitdepth_14_raf, "raw_modes/X100S_ISO_200_Bitdepth_14.RAF");
}
mod camera_x100t_raw_modes {
  super::camera_file_check!("Fujifilm", "X100T", cam_x100t_iso_400_bitdepth_14_raf, "raw_modes/X100T_ISO_400_Bitdepth_14.RAF");
}
mod camera_x100v_compressed {
  super::camera_file_check!("Fujifilm", "X100V", cam_x100v_iso_160_bitdepth_14_31_mib_raf, "compressed/X100V_ISO_160_Bitdepth_14_31 MiB.RAF");
}
mod camera_x100v_raw_modes {
  super::camera_file_check!("Fujifilm", "X100V", cam_x100v_iso_160_bitdepth_14_56_mib_raf, "raw_modes/X100V_ISO_160_Bitdepth_14_56 MiB.RAF");
}
mod camera_x100vi_raw_modes {
  super::camera_file_check!("Fujifilm", "X100VI", cam_x100vi_14bits_3x2_uncompressed_raf, "raw_modes/X100VI_14bits_3x2_uncompressed.RAF");
  super::camera_file_check!("Fujifilm", "X100VI", cam_x100vi_14bits_3x2_lossless_raf, "raw_modes/X100VI_14bits_3x2_lossless.RAF");
  super::camera_file_check!("Fujifilm", "X100VI", cam_x100vi_14bits_3x2_lossy_raf, "raw_modes/X100VI_14bits_3x2_lossy.RAF");
}
mod camera_x20_raw_modes {
  super::camera_file_check!("Fujifilm", "X20", cam_x20_iso_200_raf, "raw_modes/X20_ISO_200.RAF");
}
mod camera_x30_raw_modes {
  super::camera_file_check!("Fujifilm", "X30", cam_x30_iso_100_raf, "raw_modes/X30_ISO_100.RAF");
}
mod camera_x70_raw_modes {
  super::camera_file_check!("Fujifilm", "X70", cam_x70_iso_6400_raf, "raw_modes/X70_ISO_6400.RAF");
}
mod camera_x_a10_raw_modes {
  super::camera_file_check!("Fujifilm", "X-A10", cam_x_a10_iso_200_raf, "raw_modes/X-A10_ISO_200.RAF");
}
mod camera_x_a1_raw_modes {
  super::camera_file_check!("Fujifilm", "X-A1", cam_x_a1_iso_1000_raf, "raw_modes/X-A1_ISO_1000.RAF");
}
mod camera_x_a2_raw_modes {
  super::camera_file_check!("Fujifilm", "X-A2", cam_x_a2_iso_200_raf, "raw_modes/X-A2_ISO_200.RAF");
}
mod camera_x_a3_raw_modes {
  super::camera_file_check!("Fujifilm", "X-A3", cam_x_a3_iso_400_raf, "raw_modes/X-A3_ISO_400.RAF");
}
mod camera_x_a5_raw_modes {
  super::camera_file_check!("Fujifilm", "X-A5", cam_x_a5_iso_200_raf, "raw_modes/X-A5_ISO_200.RAF");
}
mod camera_x_a7_raw_modes {
  super::camera_file_check!("Fujifilm", "X-A7", cam_x_a7_iso_200_raf, "raw_modes/X-A7_ISO_200.RAF");
}
mod camera_x_e1_raw_modes {
  super::camera_file_check!("Fujifilm", "X-E1", cam_x_e1_iso_500_raf, "raw_modes/X-E1_ISO_500.RAF");
}
mod camera_x_e2_raw_modes {
  super::camera_file_check!("Fujifilm", "X-E2", cam_x_e2_iso_200_raf, "raw_modes/X-E2_ISO_200.RAF");
}
mod camera_x_e2s_raw_modes {
  super::camera_file_check!("Fujifilm", "X-E2S", cam_x_e2s_iso_400_raf, "raw_modes/X-E2S_ISO_400.RAF");
}
mod camera_x_e3_compressed {
  super::camera_file_check!("Fujifilm", "X-E3", cam_x_e3_iso_250_bitdepth_14_27_mib_raf, "compressed/X-E3_ISO_250_Bitdepth_14_27 MiB.RAF");
}
mod camera_x_e3_raw_modes {
  super::camera_file_check!("Fujifilm", "X-E3", cam_x_e3_iso_250_bitdepth_14_48_mib_raf, "raw_modes/X-E3_ISO_250_Bitdepth_14_48 MiB.RAF");
}
mod camera_x_e4_compressed {
  super::camera_file_check!("Fujifilm", "X-E4", cam_fuji_xe4_32_lossy_raf, "compressed/fuji_xe4_32_lossy.RAF");
  super::camera_file_check!("Fujifilm", "X-E4", cam_fuji_xe4_32_lossless_raf, "compressed/fuji_xe4_32_lossless.RAF");
}
mod camera_x_e4_raw_modes {
  super::camera_file_check!("Fujifilm", "X-E4", cam_fuji_xe4_32_uncompressed_raf, "raw_modes/fuji_xe4_32_uncompressed.RAF");
}
mod camera_xf10_raw_modes {
  super::camera_file_check!("Fujifilm", "XF10", cam_xf10_iso_200_raf, "raw_modes/XF10_ISO_200.RAF");
}
mod camera_xf1_raw_modes {
  super::camera_file_check!("Fujifilm", "XF1", cam_xf1_iso_1250_raf, "raw_modes/XF1_ISO_1250.RAF");
}
mod camera_x_h1_compressed {
  super::camera_file_check!("Fujifilm", "X-H1", cam_fuji_xh1_compressed_raf, "compressed/fuji_xh1_compressed.RAF");
}
mod camera_x_h1_raw_modes {
  super::camera_file_check!("Fujifilm", "X-H1", cam_fuji_xh1_uncompressed_raf, "raw_modes/fuji_xh1_uncompressed.RAF");
}
mod camera_x_h2s_raw_modes {
  super::camera_file_check!("Fujifilm", "X-H2S", cam_fujifilm_x_h2s_14bit_lossy_raf, "raw_modes/Fujifilm_X-H2S_14bit_lossy.raf");
  super::camera_file_check!("Fujifilm", "X-H2S", cam_fujifilm_x_h2s_14bit_uncompressed_raf, "raw_modes/Fujifilm_X-H2S_14bit_uncompressed.raf");
  super::camera_file_check!("Fujifilm", "X-H2S", cam_fujifilm_x_h2s_14bit_lossless_raf, "raw_modes/Fujifilm_X-H2S_14bit_lossless.raf");
}
mod camera_x_h2_raw_modes {
  super::camera_file_check!("Fujifilm", "X-H2", cam_fujifilm_x_h2_14bit_lossy_raf, "raw_modes/Fujifilm_X-H2_14bit_lossy.raf");
  super::camera_file_check!("Fujifilm", "X-H2", cam_fujifilm_x_h2_14bit_uncompressed_raf, "raw_modes/Fujifilm_X-H2_14bit_uncompressed.raf");
  super::camera_file_check!("Fujifilm", "X-H2", cam_fujifilm_x_h2_14bit_lossless_raf, "raw_modes/Fujifilm_X-H2_14bit_lossless.raf");
}
mod camera_x_m1_raw_modes {
  super::camera_file_check!("Fujifilm", "X-M1", cam_x_m1_iso_200_raf, "raw_modes/X-M1_ISO_200.RAF");
}
mod camera_x_m5_raw_modes {
  super::camera_file_check!("Fujifilm", "X-M5", cam_fujifilm_x_m5_iso100_lossy_compressed2_raf, "raw_modes/fujifilm_X-M5_ISO100_lossy_compressed2.RAF");
  super::camera_file_check!("Fujifilm", "X-M5", cam_fujifilm_x_m5_iso100_lossless_compressed_raf, "raw_modes/fujifilm_X-M5_ISO100_lossless_compressed.RAF");
  super::camera_file_check!("Fujifilm", "X-M5", cam_fujifilm_x_m5_iso100_uncompressed2_raf, "raw_modes/fujifilm_X-M5_ISO100_uncompressed2.RAF");
  super::camera_file_check!("Fujifilm", "X-M5", cam_fujifilm_x_m5_iso100_lossy_compressed_raf, "raw_modes/fujifilm_X-M5_ISO100_lossy_compressed.RAF");
  super::camera_file_check!("Fujifilm", "X-M5", cam_fujifilm_x_m5_iso100_lossless_compressed2_raf, "raw_modes/fujifilm_X-M5_ISO100_lossless_compressed2.RAF");
  super::camera_file_check!("Fujifilm", "X-M5", cam_fujifilm_x_m5_iso100_uncompressed_raf, "raw_modes/fujifilm_X-M5_ISO100_uncompressed.RAF");
}
mod camera_x_pro1_raw_modes {
  super::camera_file_check!("Fujifilm", "X-Pro1", cam_x_pro1_iso_200_raf, "raw_modes/X-Pro1_ISO_200.RAF");
}
mod camera_x_pro2_compressed {
  super::camera_file_check!("Fujifilm", "X-Pro2", cam_x_pro2_iso_500_bitdepth_14_26_mib_raf, "compressed/X-Pro2_ISO_500_Bitdepth_14_26 MiB.RAF");
}
mod camera_x_pro2_raw_modes {
  super::camera_file_check!("Fujifilm", "X-Pro2", cam_x_pro2_iso_500_bitdepth_14_48_mib_raf, "raw_modes/X-Pro2_ISO_500_Bitdepth_14_48 MiB.RAF");
}
mod camera_x_pro3_compressed {
  super::camera_file_check!("Fujifilm", "X-Pro3", cam_x_pro3_iso_640_bitdepth_14_29_mib_raf, "compressed/X-Pro3_ISO_640_Bitdepth_14_29 MiB.RAF");
}
mod camera_x_pro3_raw_modes {
  super::camera_file_check!("Fujifilm", "X-Pro3", cam_x_pro3_iso_640_bitdepth_14_54_mib_raf, "raw_modes/X-Pro3_ISO_640_Bitdepth_14_54 MiB.RAF");
}
mod camera_xq1_raw_modes {
  super::camera_file_check!("Fujifilm", "XQ1", cam_xq1_iso_400_raf, "raw_modes/XQ1_ISO_400.RAF");
}
mod camera_xq2_raw_modes {
  super::camera_file_check!("Fujifilm", "XQ2", cam_xq2_iso_100_raf, "raw_modes/XQ2_ISO_100.RAF");
}
mod camera_x_s10_compressed {
  super::camera_file_check!("Fujifilm", "X-S10", cam_fujifilm_x_s10_lossless_compressed_raf, "compressed/Fujifilm-X-S10-lossless-compressed.RAF");
  super::camera_file_check!("Fujifilm", "X-S10", cam_fujifilm_x_s10_compressed_raf, "compressed/Fujifilm-X-S10-compressed.RAF");
}
mod camera_x_s10_raw_modes {
  super::camera_file_check!("Fujifilm", "X-S10", cam_fujifilm_x_s10_uncompressed_raf, "raw_modes/Fujifilm-X-S10-uncompressed.RAF");
}
mod camera_x_s20_raw_modes {
  super::camera_file_check!("Fujifilm", "X-S20", cam_x_s20_iso_160_14bits_lossy_raf, "raw_modes/X-S20_ISO_160_14bits_Lossy.RAF");
  super::camera_file_check!("Fujifilm", "X-S20", cam_x_s20_iso_160_14bits_lossless_raf, "raw_modes/X-S20_ISO_160_14bits_Lossless.RAF");
  super::camera_file_check!("Fujifilm", "X-S20", cam_x_s20_iso_160_14bits_uncompressed_raf, "raw_modes/X-S20_ISO_160_14bits_uncompressed.RAF");
}
mod camera_x_s1_raw_modes {
  super::camera_file_check!("Fujifilm", "X-S1", cam_x_s1_iso_400_raf, "raw_modes/X-S1_ISO_400.RAF");
}
mod camera_x_t100_raw_modes {
  super::camera_file_check!("Fujifilm", "X-T100", cam_x_t100_iso_200_raf, "raw_modes/X-T100_ISO_200.RAF");
}
mod camera_x_t10_raw_modes {
  super::camera_file_check!("Fujifilm", "X-T10", cam_x_t10_iso_4000_raf, "raw_modes/X-T10_ISO_4000.RAF");
}
mod camera_x_t1_raw_modes {
  super::camera_file_check!("Fujifilm", "X-T1", cam_x_t1_iso_200_raf, "raw_modes/X-T1_ISO_200.RAF");
}
mod camera_x_t200_raw_modes {
  super::camera_file_check!("Fujifilm", "X-T200", cam_x_t200_iso_200_raf, "raw_modes/X-T200_ISO_200.RAF");
}
mod camera_x_t20_compressed {
  super::camera_file_check!("Fujifilm", "X-T20", cam_x_t20_iso_200_bitdepth_14_24_mib_raf, "compressed/X-T20_ISO_200_Bitdepth_14_24 MiB.RAF");
}
mod camera_x_t20_raw_modes {
  super::camera_file_check!("Fujifilm", "X-T20", cam_x_t20_iso_200_bitdepth_14_48_mib_raf, "raw_modes/X-T20_ISO_200_Bitdepth_14_48 MiB.RAF");
}
mod camera_x_t2_compressed {
  super::camera_file_check!("Fujifilm", "X-T2", cam_x_t2_iso_400_bitdepth_14_22_mib_raf, "compressed/X-T2_ISO_400_Bitdepth_14_22 MiB.RAF");
}
mod camera_x_t2_raw_modes {
  super::camera_file_check!("Fujifilm", "X-T2", cam_x_t2_iso_200_bitdepth_14_48_mib_raf, "raw_modes/X-T2_ISO_200_Bitdepth_14_48 MiB.RAF");
}
mod camera_x_t30_compressed {
  super::camera_file_check!("Fujifilm", "X-T30", cam_x_t30_iso_100_bitdepth_14_30_mib_raf, "compressed/X-T30_ISO_100_Bitdepth_14_30 MiB.RAF");
}
mod camera_x_t30_ii_compressed {
  super::camera_file_check!("Fujifilm", "X-T30 II", cam_x_t30_ii_14_bits_lossy_raf, "compressed/X-T30-II-14-bits-lossy.RAF");
  super::camera_file_check!("Fujifilm", "X-T30 II", cam_x_t30_ii_14_bits_lossless_raf, "compressed/X-T30-II-14-bits-lossless.RAF");
}
mod camera_x_t30_ii_raw_modes {
  super::camera_file_check!("Fujifilm", "X-T30 II", cam_x_t30_ii_14_bits_uncompressed_raf, "raw_modes/X-T30-II-14-bits-uncompressed.RAF");
}
mod camera_x_t30_raw_modes {
  super::camera_file_check!("Fujifilm", "X-T30", cam_x_t30_iso_100_bitdepth_14_54_mib_raf, "raw_modes/X-T30_ISO_100_Bitdepth_14_54 MiB.RAF");
}
mod camera_x_t3_compressed {
  super::camera_file_check!("Fujifilm", "X-T3", cam_x_t3_iso_160_bitdepth_14_26_mib_raf, "compressed/X-T3_ISO_160_Bitdepth_14_26 MiB.RAF");
}
mod camera_x_t3_raw_modes {
  super::camera_file_check!("Fujifilm", "X-T3", cam_x_t3_iso_160_bitdepth_14_53_mib_raf, "raw_modes/X-T3_ISO_160_Bitdepth_14_53 MiB.RAF");
}
mod camera_x_t4_raw_modes {
  super::camera_file_check!("Fujifilm", "X-T4", cam_x_t4_iso_160_bitdepth_14_55_mib_raf, "raw_modes/X-T4_ISO_160_Bitdepth_14_55 MiB.RAF");
}
mod camera_x_t4_compressed {
  super::camera_file_check!("Fujifilm", "X-T4", cam_x_t4_iso_160_bitdepth_14_26_mib_raf, "compressed/X-T4_ISO_160_Bitdepth_14_26 MiB.RAF");
  super::camera_file_check!("Fujifilm", "X-T4", cam_x_t4_iso_160_bitdepth_14_27_mib_raf, "compressed/X-T4_ISO_160_Bitdepth_14_27 MiB.RAF");
}
mod camera_x_t5_raw_modes {
  super::camera_file_check!("Fujifilm", "X-T5", cam_x_t5_iso_125_bitdepth_14_lossy_raf, "raw_modes/X-T5_ISO_125_Bitdepth_14_lossy.RAF");
  super::camera_file_check!("Fujifilm", "X-T5", cam_x_t5_iso_125_bitdepth_14_lossless_raf, "raw_modes/X-T5_ISO_125_Bitdepth_14_lossless.RAF");
  super::camera_file_check!("Fujifilm", "X-T5", cam_x_t5_iso_125_bitdepth_14_uncompressed_raf, "raw_modes/X-T5_ISO_125_Bitdepth_14_uncompressed.RAF");
}
mod camera_x_t50_raw_modes {
  super::camera_file_check!("Fujifilm", "X-T50", cam_xt50_14bit_uncompressed_raf, "raw_modes/XT50_14bit_uncompressed.RAF");
  super::camera_file_check!("Fujifilm", "X-T50", cam_xt50_14bit_lossless_raf, "raw_modes/XT50_14bit_lossless.RAF");
  super::camera_file_check!("Fujifilm", "X-T50", cam_xt50_14bit_lossy_raf, "raw_modes/XT50_14bit_lossy.RAF");
}
mod camera_om_1_raw_modes {
  super::camera_file_check!("OM", "OM-1", cam_om_1_iso_200_16bits_normal_orf, "raw_modes/OM-1_ISO_200_16bits_normal.ORF");
  super::camera_file_check!("OM", "OM-1", cam_om_1_iso_200_16bits_handheld_hires_orf, "raw_modes/OM-1_ISO_200_16bits_handheld_hires.ORF");
  super::camera_file_check!("OM", "OM-1", cam_om_1_iso_200_16bits_tripod_hires_orf, "raw_modes/OM-1_ISO_200_16bits_tripod_hires.ORF");
}
mod camera_om_1_mark_ii_raw_modes {
  super::camera_file_check!("OM", "OM-1 Mark II", cam_om_1_mark_ii_16bits_normal_orf, "raw_modes/OM-1-Mark-II_16bits_normal.ORF");
  super::camera_file_check!("OM", "OM-1 Mark II", cam_om_1_mark_ii_16bits_handheld_hires_orf, "raw_modes/OM-1-Mark-II_16bits_handheld_hires.ORF");
  super::camera_file_check!("OM", "OM-1 Mark II", cam_om_1_mark_ii_16bits_tripod_hires_orf, "raw_modes/OM-1-Mark-II_16bits_tripod_hires.ORF");
}
mod camera_om_5_raw_modes {
  super::camera_file_check!("OM", "OM-5", cam_om_5_iso_100_16bits_tripod_hires_orf, "raw_modes/OM-5_ISO_100_16bits_tripod_hires.ORF");
  super::camera_file_check!("OM", "OM-5", cam_om_5_iso_100_16bits_normal_orf, "raw_modes/OM-5_ISO_100_16bits_normal.ORF");
  super::camera_file_check!("OM", "OM-5", cam_om_5_iso_100_16bits_handheld_hires_orf, "raw_modes/OM-5_ISO_100_16bits_handheld_hires.ORF");
}
mod camera_tg_7_raw_modes {
  super::camera_file_check!("OM", "TG-7", cam_tg_7_iso_100_16bits_orf, "raw_modes/TG-7_ISO_100_16bits.ORF");
}
