% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pack.R
\name{pack}
\alias{pack}
\alias{unpack}
\title{Pack and unpack}
\usage{
pack(.data, ..., .names_sep = NULL, .error_call = current_env())

unpack(
  data,
  cols,
  ...,
  names_sep = NULL,
  names_repair = "check_unique",
  error_call = current_env()
)
}
\arguments{
\item{...}{For \code{pack()}, <\code{\link[=tidyr_tidy_select]{tidy-select}}> columns to
pack, specified using name-variable pairs of the form
\code{new_col = c(col1, col2, col3)}. The right hand side can be any valid tidy
select expression.

For \code{unpack()}, these dots are for future extensions and must be empty.}

\item{data, .data}{A data frame.}

\item{cols}{<\code{\link[=tidyr_tidy_select]{tidy-select}}> Columns to unpack.}

\item{names_sep, .names_sep}{If \code{NULL}, the default, the names will be left
as is. In \code{pack()}, inner names will come from the former outer names;
in \code{unpack()}, the new outer names will come from the inner names.

If a string, the inner and outer names will be used together. In
\code{unpack()}, the names of the new outer columns will be formed by pasting
together the outer and the inner column names, separated by \code{names_sep}. In
\code{pack()}, the new inner names will have the outer names + \code{names_sep}
automatically stripped. This makes \code{names_sep} roughly symmetric between
packing and unpacking.}

\item{names_repair}{Used to check that output data frame has valid
names. Must be one of the following options:
\itemize{
\item \verb{"minimal}": no name repair or checks, beyond basic existence,
\item \verb{"unique}": make sure names are unique and not empty,
\item \verb{"check_unique}": (the default), no name repair, but check they are unique,
\item \verb{"universal}": make the names unique and syntactic
\item a function: apply custom name repair.
\item \link{tidyr_legacy}: use the name repair from tidyr 0.8.
\item a formula: a purrr-style anonymous function (see \code{\link[rlang:as_function]{rlang::as_function()}})
}

See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for more details on these terms and the
strategies used to enforce them.}

\item{error_call, .error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\description{
Packing and unpacking preserve the length of a data frame, changing its
width. \code{pack()} makes \code{df} narrow by collapsing a set of columns into a
single df-column. \code{unpack()} makes \code{data} wider by expanding df-columns
back out into individual columns.
}
\details{
Generally, unpacking is more useful than packing because it simplifies
a complex data structure. Currently, few functions work with df-cols,
and they are mostly a curiosity, but seem worth exploring further because
they mimic the nested column headers that are so popular in Excel.
}
\examples{
# Packing -------------------------------------------------------------------
# It's not currently clear why you would ever want to pack columns
# since few functions work with this sort of data.
df <- tibble(x1 = 1:3, x2 = 4:6, x3 = 7:9, y = 1:3)
df
df |> pack(x = starts_with("x"))
df |> pack(x = c(x1, x2, x3), y = y)

# .names_sep allows you to strip off common prefixes; this
# acts as a natural inverse to name_sep in unpack()
iris |>
  as_tibble() |>
  pack(
    Sepal = starts_with("Sepal"),
    Petal = starts_with("Petal"),
    .names_sep = "."
  )

# Unpacking -----------------------------------------------------------------
df <- tibble(
  x = 1:3,
  y = tibble(a = 1:3, b = 3:1),
  z = tibble(X = c("a", "b", "c"), Y = runif(3), Z = c(TRUE, FALSE, NA))
)
df
df |> unpack(y)
df |> unpack(c(y, z))
df |> unpack(c(y, z), names_sep = "_")
}
