% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Analysis-class.R
\docType{class}
\name{RLum.Analysis-class}
\alias{RLum.Analysis-class}
\title{Class \code{"RLum.Analysis"}}
\description{
Object class to represent analysis data for protocol analysis, i.e. all curves,
spectra etc. from one measurements. Objects from this class are produced,
by e.g. \link{read_XSYG2R}, \link{read_Daybreak2R}
}
\section{Slots}{

\describe{
\item{\code{protocol}}{Object of class \link{character} describing the applied measurement protocol}

\item{\code{records}}{Object of class \link{list} containing objects of class \linkS4class{RLum.Data}}
}}

\note{
The method \link{structure_RLum} is currently just available for objects
containing \linkS4class{RLum.Data.Curve}.
}
\section{Objects from the Class}{

Objects can be created by calls of the form \code{set_RLum("RLum.Analysis", ...)}.
}

\section{Class version}{
 0.4.18
}

\examples{

## show method
showClass("RLum.Analysis")

##set an empty object
set_RLum(class = "RLum.Analysis")

## use example data
##load data
data(ExampleData.RLum.Analysis, envir = environment())

##show curves in object
get_RLum(IRSAR.RF.Data)

##show only the first object, but by keeping the object
get_RLum(IRSAR.RF.Data, record.id = 1, drop = FALSE)

## subsetting with SAR sample data
data(ExampleData.BINfileData, envir = environment())
sar <- object <- Risoe.BINfileData2RLum.Analysis(CWOSL.SAR.Data)

## get
get_RLum(sar, subset = "NPOINTS == 250")

## remove
remove_RLum(sar, subset = "NPOINTS == 250")

}
\seealso{
\link{Risoe.BINfileData2RLum.Analysis},
\linkS4class{Risoe.BINfileData}, \linkS4class{RLum}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{classes}
\keyword{methods}
