% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lint.R
\name{lint}
\alias{lint}
\alias{lint_dir}
\alias{lint_package}
\title{Lint a file, directory, or package}
\usage{
lint(
  filename,
  linters = NULL,
  ...,
  cache = FALSE,
  parse_settings = !inline_data,
  text = NULL
)

lint_dir(
  path = ".",
  ...,
  relative_path = TRUE,
  exclusions = list("renv", "packrat"),
  pattern = "(?i)[.](r|rmd|qmd|rnw|rhtml|rrst|rtex|rtxt)$",
  parse_settings = TRUE,
  show_progress = NULL
)

lint_package(
  path = ".",
  ...,
  relative_path = TRUE,
  exclusions = list("R/RcppExports.R"),
  parse_settings = TRUE,
  show_progress = NULL
)
}
\arguments{
\item{filename}{Either the filename for a file to lint, or a character string of inline R code for linting.
The latter (inline data) applies whenever \code{filename} has a newline character (\\n).}

\item{linters}{A named list of linter functions to apply. See \link{linters} for a full list of default and available
linters.}

\item{...}{Provide additional arguments to be passed to:
\itemize{
\item \code{\link[=exclude]{exclude()}} (in case of \code{lint()}; e.g. \code{lints} or \code{exclusions})
\item \code{\link[=lint]{lint()}} (in case of \code{lint_dir()} and \code{lint_package()}; e.g. \code{linters} or \code{cache})
}}

\item{cache}{When logical, toggle caching of lint results. If passed a character string, store the cache in this
directory.}

\item{parse_settings}{Logical. Whether to try and parse the \link[=read_settings]{settings}. Otherwise, the
\code{\link[=default_settings]{default_settings()}} are used. \code{TRUE} by default when linting files, as opposed to \verb{text=}.}

\item{text}{Optional argument for supplying a string or lines directly, e.g. if the file is already in memory or
linting is being done ad hoc.}

\item{path}{For the base directory of the project (for \code{lint_dir()}) or
package (for \code{lint_package()}).}

\item{relative_path}{if \code{TRUE}, file paths are printed using their path relative to the base directory.
If \code{FALSE}, use the full absolute path.}

\item{exclusions}{exclusions for \code{\link[=exclude]{exclude()}}, relative to the package path.}

\item{pattern}{pattern for files, by default it will take files with any of the extensions
.R, .Rmd, .qmd, .Rnw, .Rhtml, .Rrst, .Rtex, .Rtxt allowing for lowercase r (.r, ...).}

\item{show_progress}{Logical controlling whether to show linting progress with
\code{\link[cli:cli_progress_along]{cli::cli_progress_along()}}. The default behavior is to show progress in \code{\link[=interactive]{interactive()}} sessions
not running a testthat suite.}
}
\value{
An object of class \code{c("lints", "list")}, each element of which is a \code{"list"} object.
}
\description{
\itemize{
\item \code{lint()} lints a single file.
\item \code{lint_dir()} lints all files in a directory.
\item \code{lint_package()} lints all likely locations for R files in a package, i.e.
\verb{R/}, \verb{tests/}, \verb{inst/}, \verb{vignettes/}, \verb{data-raw/}, \verb{demo/}, and \verb{exec/}.
}
}
\details{
Read \code{vignette("lintr")} to learn how to configure which linters are run
by default.
Note that if files contain unparseable encoding problems, only the encoding problem will be linted to avoid
unintelligible error messages from other linters.
}
\examples{
# linting inline-code
lint("a = 123\n")
lint(text = "a = 123")

# linting a file
f <- tempfile()
writeLines("a=1", f)
lint(f)
unlink(f)

if (FALSE) {
  lint_dir()

  lint_dir(
    linters = list(semicolon_linter()),
    exclusions = list(
      "inst/doc/creating_linters.R" = 1,
      "inst/example/bad.R",
      "renv"
    )
  )
}
if (FALSE) {
  lint_package()

  lint_package(
    linters = linters_with_defaults(semicolon_linter = semicolon_linter()),
    exclusions = list("inst/doc/creating_linters.R" = 1, "inst/example/bad.R")
  )
}
}
