% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BatchtoolsTemplateFutureBackend-class.R
\name{BatchtoolsTemplateFutureBackend}
\alias{BatchtoolsTemplateFutureBackend}
\alias{BatchtoolsLsfFutureBackend}
\alias{BatchtoolsOpenLavaFutureBackend}
\alias{BatchtoolsSGEFutureBackend}
\alias{BatchtoolsSlurmFutureBackend}
\alias{BatchtoolsTorqueFutureBackend}
\title{Batchtools futures for LSF, OpenLava, SGE, Slurm, TORQUE etc.}
\usage{
BatchtoolsTemplateFutureBackend(
  type,
  scheduler.latency = 1,
  fs.latency = 65,
  resources = list(),
  delete = getOption("future.batchtools.delete", "on-success"),
  template = NULL,
  makeClusterFunctions = NULL,
  workers = getOption("future.batchtools.workers", default = 100L),
  ...
)
}
\arguments{
\item{type}{(character string) Type of job scheduler.}

\item{scheduler.latency}{[\code{numeric(1)}]\cr
Time to sleep after important interactions with the scheduler to ensure a sane state.
Currently only triggered after calling \code{\link[batchtools]{submitJobs}}.}

\item{fs.latency}{[\code{numeric(1)}]\cr
Expected maximum latency of the file system, in seconds.
Set to a positive number for network file systems like NFS which enables more robust (but also more expensive) mechanisms to
access files and directories.
Usually safe to set to \code{0} to disable the heuristic, e.g. if you are working on a local file system.}

\item{resources}{(optional) A named list passed to the \pkg{batchtools}
job-script template as variable \code{resources}. This is based on how
\code{\link[batchtools:submitJobs]{batchtools::submitJobs()}} works, with the exception for specially
reserved names defined by the \pkg{future.batchtools} package;
\itemize{
\item \code{resources[["details"]]}, if TRUE, results in the job script outputting
job details and job summaries at the beginning and at the end.
\item \code{resources[["startup"]]} and \code{resources[["shutdown"]]} are character
vectors of shell code to be injected to the job script as-is.
\item \code{resources[["modules"]]} is character vector of Linux environment
modules to be loaded.
\item \code{resources[["envs"]]}, is an optional names character vector specifying
environment variables to be set.
\item \code{resources[["rscript"]]} is an optional character vector specifying
how the 'Rscript' is launched. The \code{resources[["rscript_args"]]} field
is an optional character vector specifying the 'Rscript' command-line
arguments.
\item \code{resources[["asis"]]} is a character vector that are passed as-is to
the job script and are injected as job resource declarations.
\item All remaining \code{resources} named elements are injected as named resource
specification for the scheduler.
}}

\item{delete}{Controls if and when the batchtools job registry folder is
deleted.
If \code{"on-success"} (default), it is deleted if the future was resolved
successfully \emph{and} the expression did not produce an error.
If \code{"never"}, then it is never deleted.
If \code{"always"}, then it is always deleted.}

\item{template}{(optional) A batchtools template file or a template string
(in \pkg{brew} format).  If not specified, it is left to the
\pkg{batchtools} package to locate such file using its search rules.}

\item{workers}{The maximum number of workers the batchtools backend may
use at any time, which for HPC schedulers corresponds to the maximum number
of queued jobs. The default is
\code{getOption("\link{future.batchtools.workers}", 100)}.}

\item{\ldots}{Additional arguments passed to \code{\link[=BatchtoolsFutureBackend]{BatchtoolsFutureBackend()}}.}
}
\value{
An object of class \code{BatchtoolsFutureBackend}.
}
\description{
Batchtools futures for LSF, OpenLava, SGE, Slurm, TORQUE etc. are
asynchronous multiprocess futures that will be evaluated on a compute
cluster via a job scheduler.
}
\details{
These type of batchtools futures rely on batchtools backends set
up using the following \pkg{batchtools} functions:
\itemize{
\item \code{\link[batchtools:makeClusterFunctionsLSF]{batchtools::makeClusterFunctionsLSF()}} for
\href{https://en.wikipedia.org/wiki/Platform_LSF}{Load Sharing Facility (LSF)}
\item \code{\link[batchtools:makeClusterFunctionsOpenLava]{batchtools::makeClusterFunctionsOpenLava()}} for
\href{https://en.wikipedia.org/wiki/OpenLava}{OpenLava}
\item \code{\link[batchtools:makeClusterFunctionsSGE]{batchtools::makeClusterFunctionsSGE()}} for
\href{https://en.wikipedia.org/wiki/Oracle_Grid_Engine}{Sun/Oracle Grid Engine (SGE)}
\item \code{\link[batchtools:makeClusterFunctionsSlurm]{batchtools::makeClusterFunctionsSlurm()}} for
\href{https://en.wikipedia.org/wiki/Slurm_Workload_Manager}{Slurm}
\item \code{\link[batchtools:makeClusterFunctionsTORQUE]{batchtools::makeClusterFunctionsTORQUE()}} for
\href{https://en.wikipedia.org/wiki/TORQUE}{TORQUE} / PBS
}
}
\keyword{internal}
