%feature("docstring") PERSALYS::FMUInfo
"Retrieve information from a FMU file.

Parameters
----------
fmuFile : str
    FMU file name
fmuType : str, default='auto'
    FMU type, either auto, ME or CS"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getVariableNames
"Variable names accessor.

Returns
-------
description : :py:class:`openturns.Description`
    Variable names"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getFileName
"File name accessor.

Returns
-------
fn : str
    FMU file name"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getVariability
"Variability accessor.

Returns
-------
variability : :py:class:`openturns.Indices`
    Variability values"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getCausality
"Causality accessor.

Returns
-------
causality : :py:class:`openturns.Indices`
    Causality values"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getAuthor
"Author accessor.

Returns
-------
author : str
    Author name"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getCopyright
"Copyright accessor.

Returns
-------
copyright : str
    Copyright text"


// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getDateTime
"Date/Time accessor.

Returns
-------
dateTime : str
    Date and time"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getFMIVersion
"FMI version accessor.

Returns
-------
fmiVersion : str
    FMI specification version string"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getModelType
"Model type accessor.

Returns
-------
model_type : str
    Model type string: either `Model Exchange` or `Co-Simulation`"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getVersion
"Model version accessor.

Returns
-------
version : str
    Model version string"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getPlatform
"Platform accessor.

Returns
-------
platform : str
    Platform string"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getIdentifier
"Model identifier accessor.

Returns
-------
identifier : str
    Model identifier string"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getGUID
"GUID accessor.

Returns
-------
guid : str
    Globally Unique Identifier string"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getTool
"Tool identifier accessor.

Returns
-------
tool : str
    Generation tool identifier string"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getStartKeys
"Variables with values: names accessor.

Returns
-------
startKeys : :py:class:`openturns.Description`
    Variables names"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FMUInfo::getStartValues
"Variables with values: values accessor.

Returns
-------
startValues : :py:class:`openturns.NumericalPoint`
    Default values"
