// Copyright 2021 Filippo Rusconi
// GPLv3+

/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QString>


/////////////////////// Local includes
#include "massspectraceplotcontext.h"

namespace pappso
{


MassSpecTracePlotContext::MassSpecTracePlotContext(QObject *parent) : BasePlotContext(parent)
{
}

MassSpecTracePlotContext::~MassSpecTracePlotContext()
{
}

MassSpecTracePlotContext *
MassSpecTracePlotContext::clone(QObject *parent)
{
  MassSpecTracePlotContext *copy_p = new MassSpecTracePlotContext(parent);

  copy_p->initialize(*const_cast<const MassSpecTracePlotContext *>(this));

  copy_p->m_lastZ              = m_lastZ;
  copy_p->m_lastMz             = m_lastMz;
  copy_p->m_lastTicIntensity   = m_lastTicIntensity;
  copy_p->m_lastMr             = m_lastMr;
  copy_p->m_lastResolvingPower = m_lastResolvingPower;

  return copy_p;
}

void
MassSpecTracePlotContext::initialize(const BasePlotContext &other)
{
  BasePlotContext::initialize(other);
}

void
MassSpecTracePlotContext::initialize(const MassSpecTracePlotContext &other)
{
  BasePlotContext::initialize(other);

  m_lastZ              = other.m_lastZ;
  m_lastMz             = other.m_lastMz;
  m_lastTicIntensity   = other.m_lastTicIntensity;
  m_lastMr             = other.m_lastMr;
  m_lastResolvingPower = other.m_lastResolvingPower;
}


void
MassSpecTracePlotContext::resetDeconvolutionData()
{
  m_lastZ  = std::numeric_limits<quint16>::max();
  m_lastMz = qQNaN();
  m_lastMr = qQNaN();
}

QString
MassSpecTracePlotContext::toString() const
{
  QString text("Base context:\n");

  text += BasePlotContext::toString();

  text += "\n";

  text += "Mass spectrum trace plot context\n";

  text += QString("last z: %1").arg(m_lastZ);
  text += QString(" -- last m/z: %1").arg(m_lastMz, 0, 'f', 6);
  text += QString(" -- last TIC intensity: %1").arg(m_lastTicIntensity, 0, 'f', 0);
  text += QString(" -- last Mr: %1").arg(m_lastMr, 0, 'f', 6);
  text += QString(" -- last resolving power: %1").arg(m_lastResolvingPower, 0, 'f', 0);

  text += "\n";

  return text;
}

void
MassSpecTracePlotContext::registerJsConstructor(QJSEngine *engine)
{
  if(!engine)
    {
      qWarning() << "Cannot register class: engine is null";
      return;
    }

  // Register the meta object as a constructor
  QJSValue jsMetaObject = engine->newQMetaObject(&MassSpecTracePlotContext::staticMetaObject);
  engine->globalObject().setProperty("MassSpecTracePlotContext", jsMetaObject);
}

} // namespace pappso
