/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// ListOfIds struct for ListOfIds
type ListOfIds struct {
	// The list of IDs
	Ids *[]string `json:"ids"`
}

// NewListOfIds instantiates a new ListOfIds object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewListOfIds(ids []string) *ListOfIds {
	this := ListOfIds{}

	this.Ids = &ids

	return &this
}

// NewListOfIdsWithDefaults instantiates a new ListOfIds object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewListOfIdsWithDefaults() *ListOfIds {
	this := ListOfIds{}
	return &this
}

// GetIds returns the Ids field value
// If the value is explicit nil, nil is returned
func (o *ListOfIds) GetIds() *[]string {
	if o == nil {
		return nil
	}

	return o.Ids

}

// GetIdsOk returns a tuple with the Ids field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ListOfIds) GetIdsOk() (*[]string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Ids, true
}

// SetIds sets field value
func (o *ListOfIds) SetIds(v []string) {

	o.Ids = &v

}

// HasIds returns a boolean if a field has been set.
func (o *ListOfIds) HasIds() bool {
	if o != nil && o.Ids != nil {
		return true
	}

	return false
}

func (o ListOfIds) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Ids != nil {
		toSerialize["ids"] = o.Ids
	}

	return json.Marshal(toSerialize)
}

type NullableListOfIds struct {
	value *ListOfIds
	isSet bool
}

func (v NullableListOfIds) Get() *ListOfIds {
	return v.value
}

func (v *NullableListOfIds) Set(val *ListOfIds) {
	v.value = val
	v.isSet = true
}

func (v NullableListOfIds) IsSet() bool {
	return v.isSet
}

func (v *NullableListOfIds) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableListOfIds(val *ListOfIds) *NullableListOfIds {
	return &NullableListOfIds{value: val, isSet: true}
}

func (v NullableListOfIds) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableListOfIds) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
