//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armedgeorder

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AddressDetails.
func (a AddressDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "forwardAddress", a.ForwardAddress)
	populate(objectMap, "returnAddress", a.ReturnAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressDetails.
func (a *AddressDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "forwardAddress":
			err = unpopulate(val, "ForwardAddress", &a.ForwardAddress)
			delete(rawMsg, key)
		case "returnAddress":
			err = unpopulate(val, "ReturnAddress", &a.ReturnAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddressProperties.
func (a AddressProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressValidationStatus", a.AddressValidationStatus)
	populate(objectMap, "contactDetails", a.ContactDetails)
	populate(objectMap, "shippingAddress", a.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressProperties.
func (a *AddressProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressValidationStatus":
			err = unpopulate(val, "AddressValidationStatus", &a.AddressValidationStatus)
			delete(rawMsg, key)
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &a.ContactDetails)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &a.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddressResource.
func (a AddressResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressResource.
func (a *AddressResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddressResourceList.
func (a AddressResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressResourceList.
func (a *AddressResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddressUpdateParameter.
func (a AddressUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressUpdateParameter.
func (a *AddressUpdateParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddressUpdateProperties.
func (a AddressUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contactDetails", a.ContactDetails)
	populate(objectMap, "shippingAddress", a.ShippingAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddressUpdateProperties.
func (a *AddressUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contactDetails":
			err = unpopulate(val, "ContactDetails", &a.ContactDetails)
			delete(rawMsg, key)
		case "shippingAddress":
			err = unpopulate(val, "ShippingAddress", &a.ShippingAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailabilityInformation.
func (a AvailabilityInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityStage", a.AvailabilityStage)
	populate(objectMap, "disabledReason", a.DisabledReason)
	populate(objectMap, "disabledReasonMessage", a.DisabledReasonMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailabilityInformation.
func (a *AvailabilityInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityStage":
			err = unpopulate(val, "AvailabilityStage", &a.AvailabilityStage)
			delete(rawMsg, key)
		case "disabledReason":
			err = unpopulate(val, "DisabledReason", &a.DisabledReason)
			delete(rawMsg, key)
		case "disabledReasonMessage":
			err = unpopulate(val, "DisabledReasonMessage", &a.DisabledReasonMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BasicInformation.
func (b BasicInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityInformation", b.AvailabilityInformation)
	populate(objectMap, "costInformation", b.CostInformation)
	populate(objectMap, "description", b.Description)
	populate(objectMap, "displayName", b.DisplayName)
	populate(objectMap, "hierarchyInformation", b.HierarchyInformation)
	populate(objectMap, "imageInformation", b.ImageInformation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BasicInformation.
func (b *BasicInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityInformation":
			err = unpopulate(val, "AvailabilityInformation", &b.AvailabilityInformation)
			delete(rawMsg, key)
		case "costInformation":
			err = unpopulate(val, "CostInformation", &b.CostInformation)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &b.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &b.DisplayName)
			delete(rawMsg, key)
		case "hierarchyInformation":
			err = unpopulate(val, "HierarchyInformation", &b.HierarchyInformation)
			delete(rawMsg, key)
		case "imageInformation":
			err = unpopulate(val, "ImageInformation", &b.ImageInformation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingMeterDetails.
func (b BillingMeterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "frequency", b.Frequency)
	populate(objectMap, "meterDetails", b.MeterDetails)
	populate(objectMap, "meteringType", b.MeteringType)
	populate(objectMap, "name", b.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingMeterDetails.
func (b *BillingMeterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "frequency":
			err = unpopulate(val, "Frequency", &b.Frequency)
			delete(rawMsg, key)
		case "meterDetails":
			b.MeterDetails, err = unmarshalMeterDetailsClassification(val)
			delete(rawMsg, key)
		case "meteringType":
			err = unpopulate(val, "MeteringType", &b.MeteringType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CancellationReason.
func (c CancellationReason) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CancellationReason.
func (c *CancellationReason) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonProperties.
func (c CommonProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityInformation", c.AvailabilityInformation)
	populate(objectMap, "costInformation", c.CostInformation)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "filterableProperties", c.FilterableProperties)
	populate(objectMap, "hierarchyInformation", c.HierarchyInformation)
	populate(objectMap, "imageInformation", c.ImageInformation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonProperties.
func (c *CommonProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityInformation":
			err = unpopulate(val, "AvailabilityInformation", &c.AvailabilityInformation)
			delete(rawMsg, key)
		case "costInformation":
			err = unpopulate(val, "CostInformation", &c.CostInformation)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "filterableProperties":
			err = unpopulate(val, "FilterableProperties", &c.FilterableProperties)
			delete(rawMsg, key)
		case "hierarchyInformation":
			err = unpopulate(val, "HierarchyInformation", &c.HierarchyInformation)
			delete(rawMsg, key)
		case "imageInformation":
			err = unpopulate(val, "ImageInformation", &c.ImageInformation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Configuration.
func (c Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Configuration.
func (c *Configuration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationFilters.
func (c ConfigurationFilters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "filterableProperty", c.FilterableProperty)
	populate(objectMap, "hierarchyInformation", c.HierarchyInformation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationFilters.
func (c *ConfigurationFilters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filterableProperty":
			err = unpopulate(val, "FilterableProperty", &c.FilterableProperty)
			delete(rawMsg, key)
		case "hierarchyInformation":
			err = unpopulate(val, "HierarchyInformation", &c.HierarchyInformation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationProperties.
func (c ConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityInformation", c.AvailabilityInformation)
	populate(objectMap, "costInformation", c.CostInformation)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "dimensions", c.Dimensions)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "filterableProperties", c.FilterableProperties)
	populate(objectMap, "hierarchyInformation", c.HierarchyInformation)
	populate(objectMap, "imageInformation", c.ImageInformation)
	populate(objectMap, "specifications", c.Specifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationProperties.
func (c *ConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityInformation":
			err = unpopulate(val, "AvailabilityInformation", &c.AvailabilityInformation)
			delete(rawMsg, key)
		case "costInformation":
			err = unpopulate(val, "CostInformation", &c.CostInformation)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &c.Dimensions)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "filterableProperties":
			err = unpopulate(val, "FilterableProperties", &c.FilterableProperties)
			delete(rawMsg, key)
		case "hierarchyInformation":
			err = unpopulate(val, "HierarchyInformation", &c.HierarchyInformation)
			delete(rawMsg, key)
		case "imageInformation":
			err = unpopulate(val, "ImageInformation", &c.ImageInformation)
			delete(rawMsg, key)
		case "specifications":
			err = unpopulate(val, "Specifications", &c.Specifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Configurations.
func (c Configurations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Configurations.
func (c *Configurations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfigurationsRequest.
func (c ConfigurationsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationFilters", c.ConfigurationFilters)
	populate(objectMap, "customerSubscriptionDetails", c.CustomerSubscriptionDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfigurationsRequest.
func (c *ConfigurationsRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationFilters":
			err = unpopulate(val, "ConfigurationFilters", &c.ConfigurationFilters)
			delete(rawMsg, key)
		case "customerSubscriptionDetails":
			err = unpopulate(val, "CustomerSubscriptionDetails", &c.CustomerSubscriptionDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContactDetails.
func (c ContactDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contactName", c.ContactName)
	populate(objectMap, "emailList", c.EmailList)
	populate(objectMap, "mobile", c.Mobile)
	populate(objectMap, "phone", c.Phone)
	populate(objectMap, "phoneExtension", c.PhoneExtension)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContactDetails.
func (c *ContactDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contactName":
			err = unpopulate(val, "ContactName", &c.ContactName)
			delete(rawMsg, key)
		case "emailList":
			err = unpopulate(val, "EmailList", &c.EmailList)
			delete(rawMsg, key)
		case "mobile":
			err = unpopulate(val, "Mobile", &c.Mobile)
			delete(rawMsg, key)
		case "phone":
			err = unpopulate(val, "Phone", &c.Phone)
			delete(rawMsg, key)
		case "phoneExtension":
			err = unpopulate(val, "PhoneExtension", &c.PhoneExtension)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CostInformation.
func (c CostInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingInfoUrl", c.BillingInfoURL)
	populate(objectMap, "billingMeterDetails", c.BillingMeterDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CostInformation.
func (c *CostInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingInfoUrl":
			err = unpopulate(val, "BillingInfoURL", &c.BillingInfoURL)
			delete(rawMsg, key)
		case "billingMeterDetails":
			err = unpopulate(val, "BillingMeterDetails", &c.BillingMeterDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerSubscriptionDetails.
func (c CustomerSubscriptionDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "locationPlacementId", c.LocationPlacementID)
	populate(objectMap, "quotaId", c.QuotaID)
	populate(objectMap, "registeredFeatures", c.RegisteredFeatures)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerSubscriptionDetails.
func (c *CustomerSubscriptionDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "locationPlacementId":
			err = unpopulate(val, "LocationPlacementID", &c.LocationPlacementID)
			delete(rawMsg, key)
		case "quotaId":
			err = unpopulate(val, "QuotaID", &c.QuotaID)
			delete(rawMsg, key)
		case "registeredFeatures":
			err = unpopulate(val, "RegisteredFeatures", &c.RegisteredFeatures)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomerSubscriptionRegisteredFeatures.
func (c CustomerSubscriptionRegisteredFeatures) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "state", c.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomerSubscriptionRegisteredFeatures.
func (c *CustomerSubscriptionRegisteredFeatures) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Description.
func (d Description) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributes", d.Attributes)
	populate(objectMap, "descriptionType", d.DescriptionType)
	populate(objectMap, "keywords", d.Keywords)
	populate(objectMap, "links", d.Links)
	populate(objectMap, "longDescription", d.LongDescription)
	populate(objectMap, "shortDescription", d.ShortDescription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Description.
func (d *Description) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributes":
			err = unpopulate(val, "Attributes", &d.Attributes)
			delete(rawMsg, key)
		case "descriptionType":
			err = unpopulate(val, "DescriptionType", &d.DescriptionType)
			delete(rawMsg, key)
		case "keywords":
			err = unpopulate(val, "Keywords", &d.Keywords)
			delete(rawMsg, key)
		case "links":
			err = unpopulate(val, "Links", &d.Links)
			delete(rawMsg, key)
		case "longDescription":
			err = unpopulate(val, "LongDescription", &d.LongDescription)
			delete(rawMsg, key)
		case "shortDescription":
			err = unpopulate(val, "ShortDescription", &d.ShortDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeviceDetails.
func (d DeviceDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "managementResourceId", d.ManagementResourceID)
	populate(objectMap, "managementResourceTenantId", d.ManagementResourceTenantID)
	populate(objectMap, "serialNumber", d.SerialNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeviceDetails.
func (d *DeviceDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "managementResourceId":
			err = unpopulate(val, "ManagementResourceID", &d.ManagementResourceID)
			delete(rawMsg, key)
		case "managementResourceTenantId":
			err = unpopulate(val, "ManagementResourceTenantID", &d.ManagementResourceTenantID)
			delete(rawMsg, key)
		case "serialNumber":
			err = unpopulate(val, "SerialNumber", &d.SerialNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dimensions.
func (d Dimensions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "depth", d.Depth)
	populate(objectMap, "height", d.Height)
	populate(objectMap, "length", d.Length)
	populate(objectMap, "lengthHeightUnit", d.LengthHeightUnit)
	populate(objectMap, "weight", d.Weight)
	populate(objectMap, "weightUnit", d.WeightUnit)
	populate(objectMap, "width", d.Width)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dimensions.
func (d *Dimensions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "depth":
			err = unpopulate(val, "Depth", &d.Depth)
			delete(rawMsg, key)
		case "height":
			err = unpopulate(val, "Height", &d.Height)
			delete(rawMsg, key)
		case "length":
			err = unpopulate(val, "Length", &d.Length)
			delete(rawMsg, key)
		case "lengthHeightUnit":
			err = unpopulate(val, "LengthHeightUnit", &d.LengthHeightUnit)
			delete(rawMsg, key)
		case "weight":
			err = unpopulate(val, "Weight", &d.Weight)
			delete(rawMsg, key)
		case "weightUnit":
			err = unpopulate(val, "WeightUnit", &d.WeightUnit)
			delete(rawMsg, key)
		case "width":
			err = unpopulate(val, "Width", &d.Width)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DisplayInfo.
func (d DisplayInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationDisplayName", d.ConfigurationDisplayName)
	populate(objectMap, "productFamilyDisplayName", d.ProductFamilyDisplayName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DisplayInfo.
func (d *DisplayInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationDisplayName":
			err = unpopulate(val, "ConfigurationDisplayName", &d.ConfigurationDisplayName)
			delete(rawMsg, key)
		case "productFamilyDisplayName":
			err = unpopulate(val, "ProductFamilyDisplayName", &d.ProductFamilyDisplayName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionPreferences.
func (e EncryptionPreferences) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "doubleEncryptionStatus", e.DoubleEncryptionStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionPreferences.
func (e *EncryptionPreferences) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "doubleEncryptionStatus":
			err = unpopulate(val, "DoubleEncryptionStatus", &e.DoubleEncryptionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FilterableProperty.
func (f FilterableProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "supportedValues", f.SupportedValues)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FilterableProperty.
func (f *FilterableProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "supportedValues":
			err = unpopulate(val, "SupportedValues", &f.SupportedValues)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForwardShippingDetails.
func (f ForwardShippingDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "carrierDisplayName", f.CarrierDisplayName)
	populate(objectMap, "carrierName", f.CarrierName)
	populate(objectMap, "trackingId", f.TrackingID)
	populate(objectMap, "trackingUrl", f.TrackingURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForwardShippingDetails.
func (f *ForwardShippingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "carrierDisplayName":
			err = unpopulate(val, "CarrierDisplayName", &f.CarrierDisplayName)
			delete(rawMsg, key)
		case "carrierName":
			err = unpopulate(val, "CarrierName", &f.CarrierName)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &f.TrackingID)
			delete(rawMsg, key)
		case "trackingUrl":
			err = unpopulate(val, "TrackingURL", &f.TrackingURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HierarchyInformation.
func (h HierarchyInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configurationName", h.ConfigurationName)
	populate(objectMap, "productFamilyName", h.ProductFamilyName)
	populate(objectMap, "productLineName", h.ProductLineName)
	populate(objectMap, "productName", h.ProductName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HierarchyInformation.
func (h *HierarchyInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configurationName":
			err = unpopulate(val, "ConfigurationName", &h.ConfigurationName)
			delete(rawMsg, key)
		case "productFamilyName":
			err = unpopulate(val, "ProductFamilyName", &h.ProductFamilyName)
			delete(rawMsg, key)
		case "productLineName":
			err = unpopulate(val, "ProductLineName", &h.ProductLineName)
			delete(rawMsg, key)
		case "productName":
			err = unpopulate(val, "ProductName", &h.ProductName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageInformation.
func (i ImageInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "imageType", i.ImageType)
	populate(objectMap, "imageUrl", i.ImageURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageInformation.
func (i *ImageInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "imageType":
			err = unpopulate(val, "ImageType", &i.ImageType)
			delete(rawMsg, key)
		case "imageUrl":
			err = unpopulate(val, "ImageURL", &i.ImageURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Link.
func (l Link) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linkType", l.LinkType)
	populate(objectMap, "linkUrl", l.LinkURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Link.
func (l *Link) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linkType":
			err = unpopulate(val, "LinkType", &l.LinkType)
			delete(rawMsg, key)
		case "linkUrl":
			err = unpopulate(val, "LinkURL", &l.LinkURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagementResourcePreferences.
func (m ManagementResourcePreferences) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "preferredManagementResourceId", m.PreferredManagementResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagementResourcePreferences.
func (m *ManagementResourcePreferences) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "preferredManagementResourceId":
			err = unpopulate(val, "PreferredManagementResourceID", &m.PreferredManagementResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MeterDetails.
func (m MeterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["billingType"] = m.BillingType
	populate(objectMap, "chargingType", m.ChargingType)
	populate(objectMap, "multiplier", m.Multiplier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MeterDetails.
func (m *MeterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingType":
			err = unpopulate(val, "BillingType", &m.BillingType)
			delete(rawMsg, key)
		case "chargingType":
			err = unpopulate(val, "ChargingType", &m.ChargingType)
			delete(rawMsg, key)
		case "multiplier":
			err = unpopulate(val, "Multiplier", &m.Multiplier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationPreference.
func (n NotificationPreference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sendNotification", n.SendNotification)
	populate(objectMap, "stageName", n.StageName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationPreference.
func (n *NotificationPreference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sendNotification":
			err = unpopulate(val, "SendNotification", &n.SendNotification)
			delete(rawMsg, key)
		case "stageName":
			err = unpopulate(val, "StageName", &n.StageName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrderItemDetails.
func (o OrderItemDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cancellationReason", o.CancellationReason)
	populate(objectMap, "cancellationStatus", o.CancellationStatus)
	populate(objectMap, "currentStage", o.CurrentStage)
	populate(objectMap, "deletionStatus", o.DeletionStatus)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "forwardShippingDetails", o.ForwardShippingDetails)
	populate(objectMap, "managementRpDetails", o.ManagementRpDetails)
	populate(objectMap, "managementRpDetailsList", o.ManagementRpDetailsList)
	populate(objectMap, "notificationEmailList", o.NotificationEmailList)
	populate(objectMap, "orderItemStageHistory", o.OrderItemStageHistory)
	populate(objectMap, "orderItemType", o.OrderItemType)
	populate(objectMap, "preferences", o.Preferences)
	populate(objectMap, "productDetails", o.ProductDetails)
	populate(objectMap, "returnReason", o.ReturnReason)
	populate(objectMap, "returnStatus", o.ReturnStatus)
	populate(objectMap, "reverseShippingDetails", o.ReverseShippingDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrderItemDetails.
func (o *OrderItemDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cancellationReason":
			err = unpopulate(val, "CancellationReason", &o.CancellationReason)
			delete(rawMsg, key)
		case "cancellationStatus":
			err = unpopulate(val, "CancellationStatus", &o.CancellationStatus)
			delete(rawMsg, key)
		case "currentStage":
			err = unpopulate(val, "CurrentStage", &o.CurrentStage)
			delete(rawMsg, key)
		case "deletionStatus":
			err = unpopulate(val, "DeletionStatus", &o.DeletionStatus)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "forwardShippingDetails":
			err = unpopulate(val, "ForwardShippingDetails", &o.ForwardShippingDetails)
			delete(rawMsg, key)
		case "managementRpDetails":
			err = unpopulate(val, "ManagementRpDetails", &o.ManagementRpDetails)
			delete(rawMsg, key)
		case "managementRpDetailsList":
			err = unpopulate(val, "ManagementRpDetailsList", &o.ManagementRpDetailsList)
			delete(rawMsg, key)
		case "notificationEmailList":
			err = unpopulate(val, "NotificationEmailList", &o.NotificationEmailList)
			delete(rawMsg, key)
		case "orderItemStageHistory":
			err = unpopulate(val, "OrderItemStageHistory", &o.OrderItemStageHistory)
			delete(rawMsg, key)
		case "orderItemType":
			err = unpopulate(val, "OrderItemType", &o.OrderItemType)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &o.Preferences)
			delete(rawMsg, key)
		case "productDetails":
			err = unpopulate(val, "ProductDetails", &o.ProductDetails)
			delete(rawMsg, key)
		case "returnReason":
			err = unpopulate(val, "ReturnReason", &o.ReturnReason)
			delete(rawMsg, key)
		case "returnStatus":
			err = unpopulate(val, "ReturnStatus", &o.ReturnStatus)
			delete(rawMsg, key)
		case "reverseShippingDetails":
			err = unpopulate(val, "ReverseShippingDetails", &o.ReverseShippingDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrderItemProperties.
func (o OrderItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressDetails", o.AddressDetails)
	populate(objectMap, "orderId", o.OrderID)
	populate(objectMap, "orderItemDetails", o.OrderItemDetails)
	populateDateTimeRFC3339(objectMap, "startTime", o.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrderItemProperties.
func (o *OrderItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressDetails":
			err = unpopulate(val, "AddressDetails", &o.AddressDetails)
			delete(rawMsg, key)
		case "orderId":
			err = unpopulate(val, "OrderID", &o.OrderID)
			delete(rawMsg, key)
		case "orderItemDetails":
			err = unpopulate(val, "OrderItemDetails", &o.OrderItemDetails)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrderItemResource.
func (o OrderItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "location", o.Location)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "systemData", o.SystemData)
	populate(objectMap, "tags", o.Tags)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrderItemResource.
func (o *OrderItemResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &o.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &o.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &o.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrderItemResourceList.
func (o OrderItemResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrderItemResourceList.
func (o *OrderItemResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrderItemUpdateParameter.
func (o OrderItemUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "tags", o.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrderItemUpdateParameter.
func (o *OrderItemUpdateParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &o.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrderItemUpdateProperties.
func (o OrderItemUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "forwardAddress", o.ForwardAddress)
	populate(objectMap, "notificationEmailList", o.NotificationEmailList)
	populate(objectMap, "preferences", o.Preferences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrderItemUpdateProperties.
func (o *OrderItemUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "forwardAddress":
			err = unpopulate(val, "ForwardAddress", &o.ForwardAddress)
			delete(rawMsg, key)
		case "notificationEmailList":
			err = unpopulate(val, "NotificationEmailList", &o.NotificationEmailList)
			delete(rawMsg, key)
		case "preferences":
			err = unpopulate(val, "Preferences", &o.Preferences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrderProperties.
func (o OrderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentStage", o.CurrentStage)
	populate(objectMap, "orderItemIds", o.OrderItemIDs)
	populate(objectMap, "orderStageHistory", o.OrderStageHistory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrderProperties.
func (o *OrderProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentStage":
			err = unpopulate(val, "CurrentStage", &o.CurrentStage)
			delete(rawMsg, key)
		case "orderItemIds":
			err = unpopulate(val, "OrderItemIDs", &o.OrderItemIDs)
			delete(rawMsg, key)
		case "orderStageHistory":
			err = unpopulate(val, "OrderStageHistory", &o.OrderStageHistory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrderResource.
func (o OrderResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "systemData", o.SystemData)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrderResource.
func (o *OrderResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &o.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrderResourceList.
func (o OrderResourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrderResourceList.
func (o *OrderResourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Pav2MeterDetails.
func (p Pav2MeterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["billingType"] = BillingTypePav2
	populate(objectMap, "chargingType", p.ChargingType)
	populate(objectMap, "meterGuid", p.MeterGUID)
	populate(objectMap, "multiplier", p.Multiplier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Pav2MeterDetails.
func (p *Pav2MeterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingType":
			err = unpopulate(val, "BillingType", &p.BillingType)
			delete(rawMsg, key)
		case "chargingType":
			err = unpopulate(val, "ChargingType", &p.ChargingType)
			delete(rawMsg, key)
		case "meterGuid":
			err = unpopulate(val, "MeterGUID", &p.MeterGUID)
			delete(rawMsg, key)
		case "multiplier":
			err = unpopulate(val, "Multiplier", &p.Multiplier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Preferences.
func (p Preferences) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptionPreferences", p.EncryptionPreferences)
	populate(objectMap, "managementResourcePreferences", p.ManagementResourcePreferences)
	populate(objectMap, "notificationPreferences", p.NotificationPreferences)
	populate(objectMap, "transportPreferences", p.TransportPreferences)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Preferences.
func (p *Preferences) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptionPreferences":
			err = unpopulate(val, "EncryptionPreferences", &p.EncryptionPreferences)
			delete(rawMsg, key)
		case "managementResourcePreferences":
			err = unpopulate(val, "ManagementResourcePreferences", &p.ManagementResourcePreferences)
			delete(rawMsg, key)
		case "notificationPreferences":
			err = unpopulate(val, "NotificationPreferences", &p.NotificationPreferences)
			delete(rawMsg, key)
		case "transportPreferences":
			err = unpopulate(val, "TransportPreferences", &p.TransportPreferences)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Product.
func (p Product) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Product.
func (p *Product) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductDetails.
func (p ProductDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", p.Count)
	populate(objectMap, "deviceDetails", p.DeviceDetails)
	populate(objectMap, "displayInfo", p.DisplayInfo)
	populate(objectMap, "hierarchyInformation", p.HierarchyInformation)
	populate(objectMap, "productDoubleEncryptionStatus", p.ProductDoubleEncryptionStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductDetails.
func (p *ProductDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &p.Count)
			delete(rawMsg, key)
		case "deviceDetails":
			err = unpopulate(val, "DeviceDetails", &p.DeviceDetails)
			delete(rawMsg, key)
		case "displayInfo":
			err = unpopulate(val, "DisplayInfo", &p.DisplayInfo)
			delete(rawMsg, key)
		case "hierarchyInformation":
			err = unpopulate(val, "HierarchyInformation", &p.HierarchyInformation)
			delete(rawMsg, key)
		case "productDoubleEncryptionStatus":
			err = unpopulate(val, "ProductDoubleEncryptionStatus", &p.ProductDoubleEncryptionStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductFamilies.
func (p ProductFamilies) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductFamilies.
func (p *ProductFamilies) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductFamiliesMetadata.
func (p ProductFamiliesMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductFamiliesMetadata.
func (p *ProductFamiliesMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductFamiliesMetadataDetails.
func (p ProductFamiliesMetadataDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductFamiliesMetadataDetails.
func (p *ProductFamiliesMetadataDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductFamiliesRequest.
func (p ProductFamiliesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customerSubscriptionDetails", p.CustomerSubscriptionDetails)
	populate(objectMap, "filterableProperties", p.FilterableProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductFamiliesRequest.
func (p *ProductFamiliesRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customerSubscriptionDetails":
			err = unpopulate(val, "CustomerSubscriptionDetails", &p.CustomerSubscriptionDetails)
			delete(rawMsg, key)
		case "filterableProperties":
			err = unpopulate(val, "FilterableProperties", &p.FilterableProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductFamily.
func (p ProductFamily) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductFamily.
func (p *ProductFamily) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductFamilyProperties.
func (p ProductFamilyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityInformation", p.AvailabilityInformation)
	populate(objectMap, "costInformation", p.CostInformation)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "filterableProperties", p.FilterableProperties)
	populate(objectMap, "hierarchyInformation", p.HierarchyInformation)
	populate(objectMap, "imageInformation", p.ImageInformation)
	populate(objectMap, "productLines", p.ProductLines)
	populate(objectMap, "resourceProviderDetails", p.ResourceProviderDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductFamilyProperties.
func (p *ProductFamilyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityInformation":
			err = unpopulate(val, "AvailabilityInformation", &p.AvailabilityInformation)
			delete(rawMsg, key)
		case "costInformation":
			err = unpopulate(val, "CostInformation", &p.CostInformation)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "filterableProperties":
			err = unpopulate(val, "FilterableProperties", &p.FilterableProperties)
			delete(rawMsg, key)
		case "hierarchyInformation":
			err = unpopulate(val, "HierarchyInformation", &p.HierarchyInformation)
			delete(rawMsg, key)
		case "imageInformation":
			err = unpopulate(val, "ImageInformation", &p.ImageInformation)
			delete(rawMsg, key)
		case "productLines":
			err = unpopulate(val, "ProductLines", &p.ProductLines)
			delete(rawMsg, key)
		case "resourceProviderDetails":
			err = unpopulate(val, "ResourceProviderDetails", &p.ResourceProviderDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductLine.
func (p ProductLine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductLine.
func (p *ProductLine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductLineProperties.
func (p ProductLineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityInformation", p.AvailabilityInformation)
	populate(objectMap, "costInformation", p.CostInformation)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "filterableProperties", p.FilterableProperties)
	populate(objectMap, "hierarchyInformation", p.HierarchyInformation)
	populate(objectMap, "imageInformation", p.ImageInformation)
	populate(objectMap, "products", p.Products)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductLineProperties.
func (p *ProductLineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityInformation":
			err = unpopulate(val, "AvailabilityInformation", &p.AvailabilityInformation)
			delete(rawMsg, key)
		case "costInformation":
			err = unpopulate(val, "CostInformation", &p.CostInformation)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "filterableProperties":
			err = unpopulate(val, "FilterableProperties", &p.FilterableProperties)
			delete(rawMsg, key)
		case "hierarchyInformation":
			err = unpopulate(val, "HierarchyInformation", &p.HierarchyInformation)
			delete(rawMsg, key)
		case "imageInformation":
			err = unpopulate(val, "ImageInformation", &p.ImageInformation)
			delete(rawMsg, key)
		case "products":
			err = unpopulate(val, "Products", &p.Products)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProductProperties.
func (p ProductProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityInformation", p.AvailabilityInformation)
	populate(objectMap, "configurations", p.Configurations)
	populate(objectMap, "costInformation", p.CostInformation)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "filterableProperties", p.FilterableProperties)
	populate(objectMap, "hierarchyInformation", p.HierarchyInformation)
	populate(objectMap, "imageInformation", p.ImageInformation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProductProperties.
func (p *ProductProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityInformation":
			err = unpopulate(val, "AvailabilityInformation", &p.AvailabilityInformation)
			delete(rawMsg, key)
		case "configurations":
			err = unpopulate(val, "Configurations", &p.Configurations)
			delete(rawMsg, key)
		case "costInformation":
			err = unpopulate(val, "CostInformation", &p.CostInformation)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "filterableProperties":
			err = unpopulate(val, "FilterableProperties", &p.FilterableProperties)
			delete(rawMsg, key)
		case "hierarchyInformation":
			err = unpopulate(val, "HierarchyInformation", &p.HierarchyInformation)
			delete(rawMsg, key)
		case "imageInformation":
			err = unpopulate(val, "ImageInformation", &p.ImageInformation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PurchaseMeterDetails.
func (p PurchaseMeterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["billingType"] = BillingTypePurchase
	populate(objectMap, "chargingType", p.ChargingType)
	populate(objectMap, "multiplier", p.Multiplier)
	populate(objectMap, "productId", p.ProductID)
	populate(objectMap, "skuId", p.SKUID)
	populate(objectMap, "termId", p.TermID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PurchaseMeterDetails.
func (p *PurchaseMeterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingType":
			err = unpopulate(val, "BillingType", &p.BillingType)
			delete(rawMsg, key)
		case "chargingType":
			err = unpopulate(val, "ChargingType", &p.ChargingType)
			delete(rawMsg, key)
		case "multiplier":
			err = unpopulate(val, "Multiplier", &p.Multiplier)
			delete(rawMsg, key)
		case "productId":
			err = unpopulate(val, "ProductID", &p.ProductID)
			delete(rawMsg, key)
		case "skuId":
			err = unpopulate(val, "SKUID", &p.SKUID)
			delete(rawMsg, key)
		case "termId":
			err = unpopulate(val, "TermID", &p.TermID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceIdentity.
func (r ResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", r.PrincipalID)
	populate(objectMap, "tenantId", r.TenantID)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceIdentity.
func (r *ResourceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &r.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderDetails.
func (r ResourceProviderDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resourceProviderNamespace", r.ResourceProviderNamespace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderDetails.
func (r *ResourceProviderDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resourceProviderNamespace":
			err = unpopulate(val, "ResourceProviderNamespace", &r.ResourceProviderNamespace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReturnOrderItemDetails.
func (r ReturnOrderItemDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "returnAddress", r.ReturnAddress)
	populate(objectMap, "returnReason", r.ReturnReason)
	populate(objectMap, "serviceTag", r.ServiceTag)
	populate(objectMap, "shippingBoxRequired", r.ShippingBoxRequired)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReturnOrderItemDetails.
func (r *ReturnOrderItemDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "returnAddress":
			err = unpopulate(val, "ReturnAddress", &r.ReturnAddress)
			delete(rawMsg, key)
		case "returnReason":
			err = unpopulate(val, "ReturnReason", &r.ReturnReason)
			delete(rawMsg, key)
		case "serviceTag":
			err = unpopulate(val, "ServiceTag", &r.ServiceTag)
			delete(rawMsg, key)
		case "shippingBoxRequired":
			err = unpopulate(val, "ShippingBoxRequired", &r.ShippingBoxRequired)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReverseShippingDetails.
func (r ReverseShippingDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "carrierDisplayName", r.CarrierDisplayName)
	populate(objectMap, "carrierName", r.CarrierName)
	populate(objectMap, "sasKeyForLabel", r.SasKeyForLabel)
	populate(objectMap, "trackingId", r.TrackingID)
	populate(objectMap, "trackingUrl", r.TrackingURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReverseShippingDetails.
func (r *ReverseShippingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "carrierDisplayName":
			err = unpopulate(val, "CarrierDisplayName", &r.CarrierDisplayName)
			delete(rawMsg, key)
		case "carrierName":
			err = unpopulate(val, "CarrierName", &r.CarrierName)
			delete(rawMsg, key)
		case "sasKeyForLabel":
			err = unpopulate(val, "SasKeyForLabel", &r.SasKeyForLabel)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &r.TrackingID)
			delete(rawMsg, key)
		case "trackingUrl":
			err = unpopulate(val, "TrackingURL", &r.TrackingURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ShippingAddress.
func (s ShippingAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "addressType", s.AddressType)
	populate(objectMap, "city", s.City)
	populate(objectMap, "companyName", s.CompanyName)
	populate(objectMap, "country", s.Country)
	populate(objectMap, "postalCode", s.PostalCode)
	populate(objectMap, "stateOrProvince", s.StateOrProvince)
	populate(objectMap, "streetAddress1", s.StreetAddress1)
	populate(objectMap, "streetAddress2", s.StreetAddress2)
	populate(objectMap, "streetAddress3", s.StreetAddress3)
	populate(objectMap, "zipExtendedCode", s.ZipExtendedCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ShippingAddress.
func (s *ShippingAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "addressType":
			err = unpopulate(val, "AddressType", &s.AddressType)
			delete(rawMsg, key)
		case "city":
			err = unpopulate(val, "City", &s.City)
			delete(rawMsg, key)
		case "companyName":
			err = unpopulate(val, "CompanyName", &s.CompanyName)
			delete(rawMsg, key)
		case "country":
			err = unpopulate(val, "Country", &s.Country)
			delete(rawMsg, key)
		case "postalCode":
			err = unpopulate(val, "PostalCode", &s.PostalCode)
			delete(rawMsg, key)
		case "stateOrProvince":
			err = unpopulate(val, "StateOrProvince", &s.StateOrProvince)
			delete(rawMsg, key)
		case "streetAddress1":
			err = unpopulate(val, "StreetAddress1", &s.StreetAddress1)
			delete(rawMsg, key)
		case "streetAddress2":
			err = unpopulate(val, "StreetAddress2", &s.StreetAddress2)
			delete(rawMsg, key)
		case "streetAddress3":
			err = unpopulate(val, "StreetAddress3", &s.StreetAddress3)
			delete(rawMsg, key)
		case "zipExtendedCode":
			err = unpopulate(val, "ZipExtendedCode", &s.ZipExtendedCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ShippingDetails.
func (s ShippingDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "carrierDisplayName", s.CarrierDisplayName)
	populate(objectMap, "carrierName", s.CarrierName)
	populate(objectMap, "trackingId", s.TrackingID)
	populate(objectMap, "trackingUrl", s.TrackingURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ShippingDetails.
func (s *ShippingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "carrierDisplayName":
			err = unpopulate(val, "CarrierDisplayName", &s.CarrierDisplayName)
			delete(rawMsg, key)
		case "carrierName":
			err = unpopulate(val, "CarrierName", &s.CarrierName)
			delete(rawMsg, key)
		case "trackingId":
			err = unpopulate(val, "TrackingID", &s.TrackingID)
			delete(rawMsg, key)
		case "trackingUrl":
			err = unpopulate(val, "TrackingURL", &s.TrackingURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Specification.
func (s Specification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Specification.
func (s *Specification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StageDetails.
func (s StageDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "stageName", s.StageName)
	populate(objectMap, "stageStatus", s.StageStatus)
	populateDateTimeRFC3339(objectMap, "startTime", s.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StageDetails.
func (s *StageDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "stageName":
			err = unpopulate(val, "StageName", &s.StageName)
			delete(rawMsg, key)
		case "stageStatus":
			err = unpopulate(val, "StageStatus", &s.StageStatus)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransportPreferences.
func (t TransportPreferences) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "preferredShipmentType", t.PreferredShipmentType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransportPreferences.
func (t *TransportPreferences) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "preferredShipmentType":
			err = unpopulate(val, "PreferredShipmentType", &t.PreferredShipmentType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
