//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcdn_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cdn/armcdn/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/CustomDomains_ListByEndpoint.json
func ExampleCustomDomainsClient_NewListByEndpointPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCustomDomainsClient().NewListByEndpointPager("RG", "profile1", "endpoint1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CustomDomainListResult = armcdn.CustomDomainListResult{
		// 	Value: []*armcdn.CustomDomain{
		// 		{
		// 			Name: to.Ptr("www-someDomain-net"),
		// 			Type: to.Ptr("Microsoft.Cdn/profiles/endpoints/customdomains"),
		// 			ID: to.Ptr("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/customdomains/www-someDomain-net"),
		// 			Properties: &armcdn.CustomDomainProperties{
		// 				CustomHTTPSProvisioningState: to.Ptr(armcdn.CustomHTTPSProvisioningStateDisabled),
		// 				CustomHTTPSProvisioningSubstate: to.Ptr(armcdn.CustomHTTPSProvisioningSubstate("None")),
		// 				HostName: to.Ptr("www.someDomain.net"),
		// 				ProvisioningState: to.Ptr(armcdn.CustomHTTPSProvisioningState("Succeeded")),
		// 				ResourceState: to.Ptr(armcdn.CustomDomainResourceStateActive),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/CustomDomains_Get.json
func ExampleCustomDomainsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCustomDomainsClient().Get(ctx, "RG", "profile1", "endpoint1", "www-someDomain-net", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CustomDomain = armcdn.CustomDomain{
	// 	Name: to.Ptr("www-someDomain-net"),
	// 	Type: to.Ptr("Microsoft.Cdn/profiles/endpoints/customdomains"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/customdomains/www-someDomain-net"),
	// 	Properties: &armcdn.CustomDomainProperties{
	// 		CustomHTTPSProvisioningState: to.Ptr(armcdn.CustomHTTPSProvisioningStateDisabled),
	// 		CustomHTTPSProvisioningSubstate: to.Ptr(armcdn.CustomHTTPSProvisioningSubstate("None")),
	// 		HostName: to.Ptr("www.someDomain.net"),
	// 		ProvisioningState: to.Ptr(armcdn.CustomHTTPSProvisioningState("Succeeded")),
	// 		ResourceState: to.Ptr(armcdn.CustomDomainResourceStateActive),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/CustomDomains_Create.json
func ExampleCustomDomainsClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCustomDomainsClient().BeginCreate(ctx, "RG", "profile1", "endpoint1", "www-someDomain-net", armcdn.CustomDomainParameters{
		Properties: &armcdn.CustomDomainPropertiesParameters{
			HostName: to.Ptr("www.someDomain.net"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CustomDomain = armcdn.CustomDomain{
	// 	Name: to.Ptr("www-someDomain-net"),
	// 	Type: to.Ptr("Microsoft.Cdn/profiles/endpoints/customdomains"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/customdomains/www-someDomain-net"),
	// 	Properties: &armcdn.CustomDomainProperties{
	// 		CustomHTTPSProvisioningState: to.Ptr(armcdn.CustomHTTPSProvisioningStateEnabling),
	// 		CustomHTTPSProvisioningSubstate: to.Ptr(armcdn.CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval),
	// 		HostName: to.Ptr("www.someDomain.net"),
	// 		ProvisioningState: to.Ptr(armcdn.CustomHTTPSProvisioningState("Succeeded")),
	// 		ResourceState: to.Ptr(armcdn.CustomDomainResourceStateActive),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/CustomDomains_Delete.json
func ExampleCustomDomainsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCustomDomainsClient().BeginDelete(ctx, "RG", "profile1", "endpoint1", "www-someDomain-net", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/CustomDomains_DisableCustomHttps.json
func ExampleCustomDomainsClient_BeginDisableCustomHTTPS() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCustomDomainsClient().BeginDisableCustomHTTPS(ctx, "RG", "profile1", "endpoint1", "www-someDomain-net", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CustomDomain = armcdn.CustomDomain{
	// 	Name: to.Ptr("www-someDomain-net"),
	// 	Type: to.Ptr("Microsoft.Cdn/profiles/endpoints/customdomains"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/customdomains/www-someDomain-net"),
	// 	Properties: &armcdn.CustomDomainProperties{
	// 		CustomHTTPSProvisioningState: to.Ptr(armcdn.CustomHTTPSProvisioningStateDisabled),
	// 		CustomHTTPSProvisioningSubstate: to.Ptr(armcdn.CustomHTTPSProvisioningSubstateCertificateDeleted),
	// 		HostName: to.Ptr("www.someDomain.net"),
	// 		ProvisioningState: to.Ptr(armcdn.CustomHTTPSProvisioningState("Succeeded")),
	// 		ResourceState: to.Ptr(armcdn.CustomDomainResourceStateActive),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/CustomDomains_EnableCustomHttpsUsingCDNManagedCertificate.json
func ExampleCustomDomainsClient_BeginEnableCustomHTTPS_customDomainsEnableCustomHttpsUsingCdnManagedCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCustomDomainsClient().BeginEnableCustomHTTPS(ctx, "RG", "profile1", "endpoint1", "www-someDomain-net", &armcdn.CustomDomainsClientBeginEnableCustomHTTPSOptions{CustomDomainHTTPSParameters: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CustomDomain = armcdn.CustomDomain{
	// 	Name: to.Ptr("www-someDomain-net"),
	// 	Type: to.Ptr("Microsoft.Cdn/profiles/endpoints/customdomains"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/customdomains/www-someDomain-net"),
	// 	Properties: &armcdn.CustomDomainProperties{
	// 		CustomHTTPSProvisioningState: to.Ptr(armcdn.CustomHTTPSProvisioningStateEnabled),
	// 		CustomHTTPSProvisioningSubstate: to.Ptr(armcdn.CustomHTTPSProvisioningSubstateCertificateDeployed),
	// 		HostName: to.Ptr("www.someDomain.net"),
	// 		ProvisioningState: to.Ptr(armcdn.CustomHTTPSProvisioningState("Succeeded")),
	// 		ResourceState: to.Ptr(armcdn.CustomDomainResourceStateActive),
	// 		ValidationData: to.Ptr("validationdata"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7b551033155a63739b6d28f79b9c07569f6179b8/specification/cdn/resource-manager/Microsoft.Cdn/stable/2023-05-01/examples/CustomDomains_EnableCustomHttpsUsingBYOC.json
func ExampleCustomDomainsClient_BeginEnableCustomHTTPS_customDomainsEnableCustomHttpsUsingYourOwnCertificate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcdn.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewCustomDomainsClient().BeginEnableCustomHTTPS(ctx, "RG", "profile1", "endpoint1", "www-someDomain-net", &armcdn.CustomDomainsClientBeginEnableCustomHTTPSOptions{CustomDomainHTTPSParameters: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CustomDomain = armcdn.CustomDomain{
	// 	Name: to.Ptr("www-someDomain-net"),
	// 	Type: to.Ptr("Microsoft.Cdn/profiles/endpoints/customdomains"),
	// 	ID: to.Ptr("/subscriptions/subid/resourcegroups/RG/providers/Microsoft.Cdn/profiles/profile1/endpoints/endpoint1/customdomains/www-someDomain-net"),
	// 	Properties: &armcdn.CustomDomainProperties{
	// 		CustomHTTPSProvisioningState: to.Ptr(armcdn.CustomHTTPSProvisioningStateEnabled),
	// 		CustomHTTPSProvisioningSubstate: to.Ptr(armcdn.CustomHTTPSProvisioningSubstateCertificateDeployed),
	// 		HostName: to.Ptr("www.someDomain.net"),
	// 		ProvisioningState: to.Ptr(armcdn.CustomHTTPSProvisioningState("Succeeded")),
	// 		ResourceState: to.Ptr(armcdn.CustomDomainResourceStateActive),
	// 		ValidationData: to.Ptr("validationdata"),
	// 	},
	// }
}
