// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package id

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestNodeID(t *testing.T) {
	i := "1234"
	id := NewNodeID(i)
	assert.Equal(t, i, id.String())
	v64 := int64(1234)
	assert.Equal(t, v64, id.Int64())
	v := int(1234)
	assert.Equal(t, v, id.Int())
}
