// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package options

import (
	"context"
	"fmt"

	"code.forgejo.org/f3/gof3/v3/options"
	"code.forgejo.org/f3/gof3/v3/options/logger"

	"github.com/urfave/cli/v3"
)

type Options struct {
	options.Options
	logger.OptionsLogger

	Validation bool
	Directory  string
}

func (o *Options) GetURL() string    { return o.Directory }
func (o *Options) SetURL(url string) { o.Directory = url }

func (o *Options) FromFlags(ctx context.Context, c *cli.Command, prefix string) {
	o.Directory = c.String(forgeDirectoryOption(prefix))
	if o.Directory == "" {
		panic(fmt.Errorf("--%s is required", forgeDirectoryOption(prefix)))
	}
	o.Validation = c.Bool(forgeValidationOption(prefix))
}

func forgeValidationOption(direction string) string {
	return direction + "-validation"
}

func forgeDirectoryOption(direction string) string {
	return direction + "-directory"
}

func (o *Options) GetFlags(prefix, category string) []cli.Flag {
	flags := make([]cli.Flag, 0, 10)

	flags = append(flags, &cli.BoolFlag{
		Name:     forgeValidationOption(prefix),
		Usage:    "validate the JSON files against F3 JSON schemas",
		Category: prefix,
	})

	flags = append(flags, &cli.StringFlag{
		Name:     forgeDirectoryOption(prefix),
		Usage:    "path to the F3 archive",
		Category: prefix,
	})

	return flags
}
