// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

type Topic struct {
	Common
	Name string `json:"name"`
}

func (o Topic) Equal(other Topic) bool {
	return o.Common.Equal(other.Common) &&
		o.Name == other.Name
}

func (o *Topic) Clone() Interface {
	clone := &Topic{}
	*clone = *o
	return clone
}
