// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package cmd

import (
	"context"
	"fmt"

	"code.forgejo.org/f3/gof3/v3/logger"
	// allow forges to register
	_ "code.forgejo.org/f3/gof3/v3/forges/filesystem"
	_ "code.forgejo.org/f3/gof3/v3/forges/forgejo"
)

func runApp(ctx context.Context, args ...string) (string, error) {
	l := logger.NewCaptureLogger()
	ctx = logger.ContextSetLogger(ctx, l)

	app := NewApp()

	app.Writer = l.GetBuffer()
	app.ErrWriter = l.GetBuffer()

	defer func() {
		if r := recover(); r != nil {
			fmt.Println(l.String())
			panic(r)
		}
	}()

	err := app.Run(ctx, args)

	fmt.Println(l.String())

	return l.String(), err
}
