# Logging #

`fpdf.FPDF` generates useful `DEBUG` logs on generated sections sizes
when calling the `output()` method., that can help to identify what part of a PDF
takes most space (fonts, images, pages...).

Here is an example of setup code to display them:

```python
import logging

logging.basicConfig(format="%(asctime)s %(name)s [%(levelname)s] %(message)s",
                    datefmt="%H:%M:%S", level=logging.DEBUG)
```

Example output using the [Tutorial](Tutorial.md) first code snippet:

    19:25:24 fpdf.output [DEBUG] Final size summary of the biggest document sections:
    19:25:24 fpdf.output [DEBUG] - pages: 223.0B
    19:25:24 fpdf.output [DEBUG] - fonts: 102.0B

## fonttools verbose logs

Since `fpdf2` v2.5.7, verbose **INFO** logs are generated by `fonttools`,
a library we use to parse font files:

```
fontTools.subset [INFO] maxp pruned
fontTools.subset [INFO] cmap pruned
fontTools.subset [INFO] post pruned
fontTools.subset [INFO] EBDT dropped
fontTools.subset [INFO] EBLC dropped
fontTools.subset [INFO] GDEF dropped
fontTools.subset [INFO] GPOS dropped
fontTools.subset [INFO] GSUB dropped
fontTools.subset [INFO] DSIG dropped
fontTools.subset [INFO] name pruned
fontTools.subset [INFO] glyf pruned
fontTools.subset [INFO] Added gid0 to subset
fontTools.subset [INFO] Added first four glyphs to subset
fontTools.subset [INFO] Closing glyph list over 'glyf': 25 glyphs before
fontTools.subset [INFO] Glyph names: ['.notdef', 'b', 'braceleft', 'braceright', 'd', 'e', 'eight', 'five', 'four', 'glyph1', 'glyph2', 'h', 'l', 'n', 'nine', 'o', 'one', 'r', 'seven', 'six', 'space', 'three', 'two', 'w', 'zero']
fontTools.subset [INFO] Glyph IDs:   [0, 1, 2, 3, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 69, 71, 72, 75, 79, 81, 82, 85, 90, 94, 96]
fontTools.subset [INFO] Closed glyph list over 'glyf': 25 glyphs after
fontTools.subset [INFO] Glyph names: ['.notdef', 'b', 'braceleft', 'braceright', 'd', 'e', 'eight', 'five', 'four', 'glyph1', 'glyph2', 'h', 'l', 'n', 'nine', 'o', 'one', 'r', 'seven', 'six', 'space', 'three', 'two', 'w', 'zero']
fontTools.subset [INFO] Glyph IDs:   [0, 1, 2, 3, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 69, 71, 72, 75, 79, 81, 82, 85, 90, 94, 96]
fontTools.subset [INFO] Retaining 25 glyphs
fontTools.subset [INFO] head subsetting not needed
fontTools.subset [INFO] hhea subsetting not needed
fontTools.subset [INFO] maxp subsetting not needed
fontTools.subset [INFO] OS/2 subsetting not needed
fontTools.subset [INFO] hmtx subsetted
fontTools.subset [INFO] cmap subsetted
fontTools.subset [INFO] fpgm subsetting not needed
fontTools.subset [INFO] prep subsetting not needed
fontTools.subset [INFO] cvt  subsetting not needed
fontTools.subset [INFO] loca subsetting not needed
fontTools.subset [INFO] post subsetted
fontTools.subset [INFO] name subsetting not needed
fontTools.subset [INFO] glyf subsetted
fontTools.subset [INFO] head pruned
fontTools.subset [INFO] OS/2 Unicode ranges pruned: [0]
fontTools.subset [INFO] glyf pruned
```

You can easily suppress those logs with this single line of code:
```python
logging.getLogger('fontTools.subset').level = logging.WARN
```

Similarly, you can omit verbose logs from `fontTools.ttLib.ttFont`:
```python
logging.getLogger('fontTools.ttLib.ttFont').level = logging.WARN
```

## Warning logs for unsupported SVG features ##

The `fpdf.svg` module produces `WARNING` log messages for **unsupported** SVG tags & attributes.
If need be, you can suppress those logs:

```python
logging.getLogger("fpdf.svg").propagate = False
```
