"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CharStringGlobalOptSubrFactory = void 0;
const analyzer_1 = require("./pair/analyzer");
const rule_set_1 = require("./subr/rule-set");
class CharStringGlobalOptSubr {
    constructor(ctx, fdCount) {
        this.localSubroutines = [];
        for (let fdId = 0; fdId < fdCount; fdId++) {
            this.localSubroutines[fdId] = [];
        }
        this.limits = ctx.getLimits();
        this.analyzer = analyzer_1.Pairing.create();
    }
    addCharString(gid, fdId, mirSeq) {
        this.analyzer.addInput(this.limits, mirSeq);
    }
    getResults() {
        const ruleSet = new rule_set_1.RuleSet();
        this.analyzer.analyze(ruleSet);
        ruleSet.optimize(this.limits);
        const { charStrings, subroutines: globalSubroutines } = ruleSet.compile(this.limits);
        return {
            charStrings: charStrings,
            localSubroutines: this.localSubroutines,
            globalSubroutines: globalSubroutines
        };
    }
}
exports.CharStringGlobalOptSubrFactory = {
    createOptimizer(ctx, fdCount) {
        return new CharStringGlobalOptSubr(ctx, fdCount);
    }
};
//# sourceMappingURL=subroutine-analyze.js.map